/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanAccrualAdjustmentTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanAccrualTransactionCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.loanaccount.data.AccrualBalances;
import org.apache.fineract.portfolio.loanaccount.data.AccrualChargeData;
import org.apache.fineract.portfolio.loanaccount.data.AccrualPeriodData;
import org.apache.fineract.portfolio.loanaccount.data.AccrualPeriodsData;
import org.apache.fineract.portfolio.loanaccount.data.CumulativeIncomeFromIncomePosting;
import org.apache.fineract.portfolio.loanaccount.data.TransactionPortionsForForeclosure;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidBy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidByRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanInstallmentCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanInterestRecalcualtionAdditionalDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanInterestRecalculationDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleProcessingWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionComparator;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionToRepaymentScheduleMapping;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGenerator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGeneratorFactory;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingServiceImpl;
import org.apache.fineract.portfolio.loanaccount.service.LoanBalanceService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanproduct.domain.InterestRecalculationCompoundingMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRelatedDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class LoanAccrualsProcessingServiceImpl
implements LoanAccrualsProcessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanAccrualsProcessingServiceImpl.class);
    private static final Set<LoanTransactionType> ACCRUAL_TYPES = Set.of(LoanTransactionType.ACCRUAL, LoanTransactionType.ACCRUAL_ADJUSTMENT);
    private static final String ACCRUAL_ON_CHARGE_SUBMITTED_ON_DATE = "submitted-date";
    private final ExternalIdFactory externalIdFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final ConfigurationDomainService configurationDomainService;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanScheduleGeneratorFactory loanScheduleFactory;
    @Qualifier(value="fineractConfigurableThreadPoolTaskExecutor")
    private final ThreadPoolTaskExecutor taskExecutor;
    private final TransactionTemplate transactionTemplate;
    private final LoanChargeService loanChargeService;
    private final LoanBalanceService loanBalanceService;
    private final LoanChargePaidByRepository loanChargePaidByRepository;
    private final LoanJournalEntryPoster journalEntryPoster;

    @Transactional
    public void addPeriodicAccruals(@NonNull LocalDate tillDate) throws JobExecutionException {
        List loans = this.loanRepositoryWrapper.findLoansForPeriodicAccrual(AccountingRuleType.ACCRUAL_PERIODIC, tillDate, !this.isChargeOnDueDate());
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Loan loan : loans) {
            try {
                this.addPeriodicAccruals(tillDate, loan);
            }
            catch (Exception e) {
                log.error("Failed to add accrual for loan {}", (Object)loan.getId(), (Object)e);
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new JobExecutionException(errors);
        }
    }

    @Transactional
    public void addPeriodicAccruals(@NonNull LocalDate tillDate, @NonNull Loan loan) {
        if (loan.isClosed() || loan.getStatus().isOverpaid()) {
            return;
        }
        boolean chargeOnDueDate = this.isChargeOnDueDate();
        this.addAccruals(loan, tillDate, true, false, true, chargeOnDueDate);
    }

    @Transactional
    public void addAccruals(@NonNull LocalDate tillDate) throws JobExecutionException {
        boolean chargeOnDueDate = this.isChargeOnDueDate();
        List loans = this.loanRepositoryWrapper.findLoansForAddAccrual(AccountingRuleType.ACCRUAL_PERIODIC, tillDate, !chargeOnDueDate);
        ArrayList loanTasks = new ArrayList();
        FineractContext context = ThreadLocalContextUtil.getContext();
        loans.forEach(outerLoan -> loanTasks.add(this.taskExecutor.submit(() -> {
            try {
                ThreadLocalContextUtil.init((FineractContext)context);
                this.transactionTemplate.executeWithoutResult(status -> {
                    Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection((Long)outerLoan.getId());
                    try {
                        log.debug("Adding accruals for loan '{}'", (Object)loan.getId());
                        this.addAccruals(loan, tillDate, false, false, true, chargeOnDueDate);
                        log.debug("Successfully processed loan: '{}' for accrual entries", (Object)loan.getId());
                    }
                    catch (Exception e) {
                        log.error("Failed to add accrual for loan {}", (Object)loan.getId(), (Object)e);
                        throw new RuntimeException("Failed to add accrual for loan " + String.valueOf(loan.getId()), e);
                    }
                });
            }
            finally {
                ThreadLocalContextUtil.reset();
            }
        })));
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Future task : loanTasks) {
            try {
                task.get();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new JobExecutionException(errors);
        }
    }

    public void reprocessExistingAccruals(@NonNull Loan loan, boolean addEvent) {
        List accrualTransactions = this.retrieveListOfAccrualTransactions(loan);
        if (!accrualTransactions.isEmpty()) {
            if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue()) {
                this.reprocessPeriodicAccruals(loan, accrualTransactions, addEvent);
            } else if (loan.isNoneOrCashOrUpfrontAccrualAccountingEnabledOnLoanProduct().booleanValue()) {
                this.reprocessNonPeriodicAccruals(loan, accrualTransactions, addEvent);
            }
        }
    }

    @Transactional
    public void processAccrualsOnInterestRecalculation(@NonNull Loan loan, boolean isInterestRecalculationEnabled, boolean addJournal) {
        if (this.isProgressiveAccrual(loan)) {
            return;
        }
        LocalDate accruedTill = loan.getAccruedTill();
        if (!isInterestRecalculationEnabled || accruedTill == null) {
            return;
        }
        try {
            boolean chargeOnDueDate = this.isChargeOnDueDate();
            this.addAccruals(loan, accruedTill, true, false, addJournal, chargeOnDueDate);
        }
        catch (Exception e) {
            String globalisationMessageCode = "error.msg.accrual.exception";
            throw new GeneralPlatformDomainRuleException(globalisationMessageCode, e.getMessage(), new Object[]{e});
        }
    }

    @Transactional
    public void addIncomePostingAndAccruals(Long loanId) throws LoanNotFoundException {
        if (loanId == null) {
            return;
        }
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        if (this.isProgressiveAccrual(loan)) {
            return;
        }
        this.processIncomePostingAndAccruals(loan, true);
        this.loanRepositoryWrapper.saveAndFlush(loan);
    }

    public void processIncomePostingAndAccruals(@NonNull Loan loan, boolean addEvent) {
        LoanInterestRecalcualtionAdditionalDetails compoundingDetail;
        if (this.isProgressiveAccrual(loan)) {
            return;
        }
        LoanInterestRecalculationDetails recalculationDetails = loan.getLoanInterestRecalculationDetails();
        if (recalculationDetails == null || !recalculationDetails.isCompoundingToBePostedAsTransaction()) {
            return;
        }
        LocalDate lastCompoundingDate = loan.getDisbursementDate();
        List compoundingDetails = this.extractInterestRecalculationAdditionalDetails(loan);
        Iterator iterator = compoundingDetails.iterator();
        while (iterator.hasNext() && DateUtils.isBeforeBusinessDate((LocalDate)(compoundingDetail = (LoanInterestRecalcualtionAdditionalDetails)iterator.next()).getEffectiveDate())) {
            this.addUpdateIncomeAndAccrualTransaction(loan, compoundingDetail, lastCompoundingDate, addEvent);
            lastCompoundingDate = compoundingDetail.getEffectiveDate();
        }
        List installments = loan.getRepaymentScheduleInstallments();
        LoanRepaymentScheduleInstallment lastInstallment = LoanRepaymentScheduleInstallment.getLastNonDownPaymentInstallment((List)installments);
        this.reverseTransactionsAfter(loan, Set.of(LoanTransactionType.ACCRUAL, LoanTransactionType.ACCRUAL_ADJUSTMENT, LoanTransactionType.INCOME_POSTING), lastInstallment.getDueDate(), addEvent);
    }

    public void processAccrualsOnLoanClosure(@NonNull Loan loan, boolean addJournal) {
        boolean chargeOnDueDate = this.isChargeOnDueDate();
        this.addAccruals(loan, loan.getLastLoanRepaymentScheduleInstallment().getDueDate(), false, true, addJournal, chargeOnDueDate);
        if (this.isProgressiveAccrual(loan)) {
            return;
        }
        this.processIncomeAndAccrualTransactionOnLoanClosure(loan);
    }

    public void processAccrualsOnLoanForeClosure(@NonNull Loan loan, @NonNull LocalDate foreClosureDate, @NonNull List<LoanTransaction> newAccrualTransactions) {
        if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue() && (loan.getAccruedTill() == null || !DateUtils.isEqual((LocalDate)foreClosureDate, (LocalDate)loan.getAccruedTill()))) {
            LoanRepaymentScheduleInstallment foreCloseDetail = this.loanBalanceService.fetchLoanForeclosureDetail(loan, foreClosureDate);
            MonetaryCurrency currency = loan.getCurrency();
            this.reverseTransactionsAfter(loan, ACCRUAL_TYPES, foreClosureDate, false);
            Map incomeDetails = this.determineReceivableIncomeForeClosure(loan, foreClosureDate);
            Money interestPortion = foreCloseDetail.getInterestCharged(currency).minus((Money)incomeDetails.get("interest"));
            Money feePortion = foreCloseDetail.getFeeChargesCharged(currency).minus((Money)incomeDetails.get("fee"));
            Money penaltyPortion = foreCloseDetail.getPenaltyChargesCharged(currency).minus((Money)incomeDetails.get("penalties"));
            Money total = interestPortion.plus(feePortion).plus(penaltyPortion);
            if (total.isGreaterThanZero()) {
                this.createAccrualTransactionAndUpdateChargesPaidBy(loan, foreClosureDate, newAccrualTransactions, currency, interestPortion, feePortion, penaltyPortion, total);
            }
        }
    }

    private void addAccruals(@NonNull Loan loan, @NonNull LocalDate tillDate, boolean periodic, boolean isFinal, boolean addJournal, boolean chargeOnDueDate) {
        LocalDate accrualDate;
        if (!isFinal && !loan.isOpen() || loan.isNpa() || loan.isChargedOff() || !loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue() || loan.isContractTermination()) {
            return;
        }
        LoanInterestRecalculationDetails recalculationDetails = loan.getLoanInterestRecalculationDetails();
        if (recalculationDetails != null && recalculationDetails.isCompoundingToBePostedAsTransaction()) {
            return;
        }
        LocalDate lastDueDate = loan.getLastLoanRepaymentScheduleInstallment().getDueDate();
        this.reverseTransactionsAfter(loan, ACCRUAL_TYPES, lastDueDate, addJournal);
        this.ensureAccrualTransactionMappings(loan, chargeOnDueDate);
        if (DateUtils.isAfter((LocalDate)tillDate, (LocalDate)lastDueDate)) {
            tillDate = lastDueDate;
        }
        boolean progressiveAccrual = this.isProgressiveAccrual(loan);
        LocalDate accruedTill = loan.getAccruedTill();
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        LocalDate localDate = isFinal ? (progressiveAccrual ? (DateUtils.isBefore((LocalDate)lastDueDate, (LocalDate)businessDate) ? lastDueDate : businessDate) : this.getFinalAccrualTransactionDate(loan)) : (accrualDate = tillDate);
        if (progressiveAccrual && accruedTill != null && !DateUtils.isAfter((LocalDate)tillDate, (LocalDate)accruedTill)) {
            if (isFinal) {
                this.reverseTransactionsAfter(loan, ACCRUAL_TYPES, accrualDate, addJournal);
            } else if (this.loanTransactionRepository.existsNonReversedByLoanAndTypesAndOnOrAfterDate(loan, ACCRUAL_TYPES, accrualDate) && this.hasNoActiveChargeOnDate(loan, accrualDate)) {
                return;
            }
        }
        AccrualPeriodsData accrualPeriods = this.calculateAccrualAmounts(loan, tillDate, periodic, isFinal, chargeOnDueDate);
        boolean mergeTransactions = isFinal || progressiveAccrual;
        MonetaryCurrency currency = loan.getLoanProductRelatedDetail().getCurrency();
        List<LoanTransaction> accrualTransactions = new ArrayList();
        Money totalInterestPortion = null;
        LoanTransaction mergeAccrualTransaction = null;
        LoanTransaction mergeAdjustTransaction = null;
        for (AccrualPeriodData period : accrualPeriods.getPeriods()) {
            Money interestAccruable = MathUtil.nullToZero((Money)period.getInterestAccruable(), (MonetaryCurrency)currency);
            Money interestPortion = MathUtil.minus((Money)interestAccruable, (Money)period.getInterestAccrued());
            Money feeAccruable = MathUtil.nullToZero((Money)period.getFeeAccruable(), (MonetaryCurrency)currency);
            Money feePortion = MathUtil.minus((Money)feeAccruable, (Money)period.getFeeAccrued());
            Money penaltyAccruable = MathUtil.nullToZero((Money)period.getPenaltyAccruable(), (MonetaryCurrency)currency);
            Money penaltyPortion = MathUtil.minus((Money)penaltyAccruable, (Money)period.getPenaltyAccrued());
            if (MathUtil.isEmpty((Money)interestPortion) && MathUtil.isEmpty((Money)feePortion) && MathUtil.isEmpty((Money)penaltyPortion)) continue;
            if (mergeTransactions) {
                totalInterestPortion = MathUtil.plus(totalInterestPortion, (Money)interestPortion);
                if (progressiveAccrual) {
                    Money feeAdjustmentPortion = MathUtil.negate((Money)feePortion);
                    Money penaltyAdjustmentPortion = MathUtil.negate((Money)penaltyPortion);
                    mergeAdjustTransaction = this.createOrMergeAccrualTransaction(loan, mergeAdjustTransaction, accrualDate, period, accrualTransactions, null, feeAdjustmentPortion, penaltyAdjustmentPortion, true);
                }
                mergeAccrualTransaction = this.createOrMergeAccrualTransaction(loan, mergeAccrualTransaction, accrualDate, period, accrualTransactions, null, feePortion, penaltyPortion, false);
            } else {
                LocalDate dueDate = period.getDueDate();
                if (!isFinal && DateUtils.isAfter((LocalDate)dueDate, (LocalDate)tillDate) && DateUtils.isBefore((LocalDate)tillDate, (LocalDate)accruedTill)) continue;
                LocalDate periodAccrualDate = DateUtils.isBefore((LocalDate)dueDate, (LocalDate)accrualDate) ? dueDate : accrualDate;
                LoanTransaction accrualTransaction = this.addAccrualTransaction(loan, periodAccrualDate, period, interestPortion, feePortion, penaltyPortion, false);
                if (accrualTransaction != null) {
                    accrualTransactions.add(accrualTransaction);
                }
            }
            LoanRepaymentScheduleInstallment installment = loan.fetchRepaymentScheduleInstallment(period.getInstallmentNumber());
            installment.updateAccrualPortion(interestAccruable, feeAccruable, penaltyAccruable);
        }
        if (mergeTransactions && !MathUtil.isEmpty(totalInterestPortion)) {
            if (progressiveAccrual) {
                Money interestAdjustmentPortion = MathUtil.negate(totalInterestPortion);
                this.createOrMergeAccrualTransaction(loan, mergeAdjustTransaction, accrualDate, null, accrualTransactions, interestAdjustmentPortion, null, null, true);
            }
            this.createOrMergeAccrualTransaction(loan, mergeAccrualTransaction, accrualDate, null, accrualTransactions, totalInterestPortion, null, null, false);
        }
        if (accrualTransactions.isEmpty()) {
            return;
        }
        if (!isFinal || progressiveAccrual) {
            loan.setAccruedTill(isFinal ? accrualDate : tillDate);
        }
        accrualTransactions = this.loanTransactionRepository.saveAll(accrualTransactions);
        this.loanTransactionRepository.flush();
        if (addJournal) {
            for (LoanTransaction accrualTransaction : accrualTransactions) {
                LoanAccrualTransactionCreatedBusinessEvent businessEvent = accrualTransaction.isAccrual() ? new LoanAccrualTransactionCreatedBusinessEvent(accrualTransaction) : new LoanAccrualAdjustmentTransactionBusinessEvent(accrualTransaction);
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(accrualTransaction, false, false);
            }
        }
    }

    private boolean hasNoActiveChargeOnDate(Loan loan, LocalDate accrualDate) {
        return loan.getLoanCharges(t -> t.isActive() && DateUtils.isEqual((LocalDate)t.getDueDate(), (LocalDate)accrualDate)).isEmpty();
    }

    private AccrualPeriodsData calculateAccrualAmounts(@NonNull Loan loan, @NonNull LocalDate tillDate, boolean periodic, boolean isFinal, boolean chargeOnDueDate) {
        LoanProductRelatedDetail productDetail = loan.getLoanProductRelatedDetail();
        MonetaryCurrency currency = productDetail.getCurrency();
        LoanScheduleGenerator scheduleGenerator = this.loanScheduleFactory.create(productDetail.getLoanScheduleType(), productDetail.getInterestMethod());
        int firstInstallmentNumber = LoanRepaymentScheduleProcessingWrapper.fetchFirstNormalInstallmentNumber((List)loan.getRepaymentScheduleInstallments());
        LocalDate interestCalculationTillDate = loan.isProgressiveSchedule() && loan.getLoanProductRelatedDetail().isInterestRecognitionOnDisbursementDate() ? tillDate.plusDays(1L) : tillDate;
        List installments = isFinal ? loan.getRepaymentScheduleInstallments() : this.getInstallmentsToAccrue(loan, interestCalculationTillDate, periodic, chargeOnDueDate);
        AccrualPeriodsData accrualPeriods = AccrualPeriodsData.create((List)installments, (Integer)firstInstallmentNumber, (MonetaryCurrency)currency);
        for (LoanRepaymentScheduleInstallment installment : installments) {
            this.addInterestAccrual(loan, interestCalculationTillDate, scheduleGenerator, installment, accrualPeriods);
            this.addChargeAccrual(loan, tillDate, chargeOnDueDate, installment, accrualPeriods);
        }
        return accrualPeriods;
    }

    @NonNull
    private List<LoanRepaymentScheduleInstallment> getInstallmentsToAccrue(@NonNull Loan loan, @NonNull LocalDate tillDate, boolean periodic, boolean chargeOnDueDate) {
        LocalDate organisationStartDate = this.configurationDomainService.retrieveOrganisationStartDate();
        int firstInstallmentNumber = LoanRepaymentScheduleProcessingWrapper.fetchFirstNormalInstallmentNumber((List)loan.getRepaymentScheduleInstallments());
        return loan.getRepaymentScheduleInstallments(i -> !i.isDownPayment() && (!chargeOnDueDate || (periodic ? !LoanRepaymentScheduleProcessingWrapper.isBeforePeriod((LocalDate)tillDate, (LoanRepaymentScheduleInstallment)i, (boolean)i.getInstallmentNumber().equals(firstInstallmentNumber)) : this.isFullPeriod(tillDate, i))) && !LoanRepaymentScheduleProcessingWrapper.isAfterPeriod((LocalDate)organisationStartDate, (LoanRepaymentScheduleInstallment)i));
    }

    private void addInterestAccrual(@NonNull Loan loan, @NonNull LocalDate tillDate, LoanScheduleGenerator scheduleGenerator, @NonNull LoanRepaymentScheduleInstallment installment, @NonNull AccrualPeriodsData accrualPeriods) {
        if (installment.isAdditional() || installment.isReAged()) {
            return;
        }
        AccrualPeriodData period = accrualPeriods.getPeriodByInstallmentNumber(installment.getInstallmentNumber());
        MonetaryCurrency currency = accrualPeriods.getCurrency();
        Money interest = null;
        boolean isPastPeriod = LoanRepaymentScheduleProcessingWrapper.isAfterPeriod((LocalDate)tillDate, (LoanRepaymentScheduleInstallment)installment);
        boolean isInPeriod = LoanRepaymentScheduleProcessingWrapper.isInPeriod((LocalDate)tillDate, (LoanRepaymentScheduleInstallment)installment, (boolean)false);
        if (isPastPeriod || loan.isClosed() || this.loanBalanceService.isOverPaid(loan)) {
            interest = installment.getInterestCharged(currency).minus(installment.getCreditedInterest());
        } else if (isInPeriod) {
            interest = scheduleGenerator.getPeriodInterestTillDate(installment, tillDate);
        }
        period.setInterestAmount(interest);
        Money accruable = null;
        Money transactionWaived = null;
        if (!MathUtil.isEmpty((Money)interest)) {
            transactionWaived = MathUtil.toMoney((BigDecimal)this.calcInterestTransactionWaivedAmount(installment, tillDate), (MonetaryCurrency)currency);
            Money unrecognizedWaived = MathUtil.toMoney((BigDecimal)this.calcInterestUnrecognizedWaivedAmount(installment, accrualPeriods, tillDate), (MonetaryCurrency)currency);
            unrecognizedWaived = MathUtil.min((Money)unrecognizedWaived, (Money)MathUtil.minusToZero((Money)installment.getInterestWaived(currency), (Money[])new Money[]{transactionWaived}), (boolean)false);
            period.setUnrecognizedWaive(unrecognizedWaived);
            Money waived = isPastPeriod ? installment.getInterestWaived(currency) : MathUtil.plus((Money)transactionWaived, (Money)unrecognizedWaived);
            accruable = MathUtil.minusToZero((Money)period.getInterestAmount(), (Money[])new Money[]{waived});
        }
        period.setInterestAccruable(accruable);
        Money transactionAccrued = MathUtil.toMoney((BigDecimal)this.calcInterestAccruedAmount(installment, accrualPeriods, tillDate), (MonetaryCurrency)currency);
        period.setTransactionAccrued(transactionAccrued);
        Money accrued = MathUtil.minusToZero((Money)transactionAccrued, (Money[])new Money[]{transactionWaived});
        period.setInterestAccrued(accrued);
    }

    @NonNull
    private BigDecimal calcInterestTransactionWaivedAmount(@NonNull LoanRepaymentScheduleInstallment installment, @NonNull LocalDate tillDate) {
        Predicate<LoanTransaction> transactionPredicate = t -> !t.isReversed() && t.isInterestWaiver() && !DateUtils.isAfter((LocalDate)t.getTransactionDate(), (LocalDate)tillDate);
        return installment.getLoanTransactionToRepaymentScheduleMappings().stream().filter(tm -> transactionPredicate.test(tm.getLoanTransaction())).map(LoanTransactionToRepaymentScheduleMapping::getInterestPortion).reduce(BigDecimal.ZERO, MathUtil::add);
    }

    @NonNull
    private BigDecimal calcInterestUnrecognizedWaivedAmount(@NonNull LoanRepaymentScheduleInstallment installment, @NonNull AccrualPeriodsData accrualPeriods, @NonNull LocalDate tillDate) {
        LocalDate dueDate = installment.getDueDate();
        LocalDate toDate = DateUtils.isBefore((LocalDate)dueDate, (LocalDate)tillDate) ? dueDate : tillDate;
        Loan loan = installment.getLoan();
        BigDecimal totalUnrecognized = this.loanTransactionRepository.findTotalUnrecognizedIncomeFromInterestWaiverByLoanAndDate(loan, toDate);
        BigDecimal prevUnrecognized = accrualPeriods.getPeriods().stream().filter(p -> p.getInstallmentNumber() < installment.getInstallmentNumber()).map(p -> MathUtil.toBigDecimal((Money)p.getUnrecognizedWaive())).reduce(BigDecimal.ZERO, MathUtil::add);
        return MathUtil.min((BigDecimal)installment.getInterestWaived(), (BigDecimal)MathUtil.subtractToZero((BigDecimal)totalUnrecognized, (BigDecimal[])new BigDecimal[]{prevUnrecognized}), (boolean)false);
    }

    @NonNull
    private BigDecimal calcInterestAccruedAmount(@NonNull LoanRepaymentScheduleInstallment installment, @NonNull AccrualPeriodsData accrualPeriods, @NonNull LocalDate tillDate) {
        Loan loan = installment.getLoan();
        if (this.isProgressiveAccrual(loan)) {
            BigDecimal totalAccrued = this.loanTransactionRepository.findTotalInterestAccruedAmount(loan);
            BigDecimal prevAccrued = accrualPeriods.getPeriods().stream().filter(p -> p.getInstallmentNumber() < installment.getInstallmentNumber()).map(p -> MathUtil.toBigDecimal((Money)p.getTransactionAccrued())).reduce(BigDecimal.ZERO, MathUtil::add);
            BigDecimal accrued = MathUtil.subtractToZero((BigDecimal)totalAccrued, (BigDecimal[])new BigDecimal[]{prevAccrued});
            return LoanRepaymentScheduleProcessingWrapper.isInPeriod((LocalDate)tillDate, (LoanRepaymentScheduleInstallment)installment, (boolean)false) ? accrued : MathUtil.min((BigDecimal)installment.getInterestAccrued(), (BigDecimal)accrued, (boolean)false);
        }
        return this.isFullPeriod(tillDate, installment) ? installment.getInterestAccrued() : this.loanTransactionRepository.findAccrualInterestInPeriod(loan, installment.getFromDate(), installment.getDueDate());
    }

    private void addChargeAccrual(@NonNull Loan loan, @NonNull LocalDate tillDate, boolean chargeOnDueDate, @NonNull LoanRepaymentScheduleInstallment installment, @NonNull AccrualPeriodsData accrualPeriods) {
        AccrualPeriodData period = accrualPeriods.getPeriodByInstallmentNumber(installment.getInstallmentNumber());
        LocalDate dueDate = installment.getDueDate();
        List loanCharges = loan.getLoanCharges(lc -> !lc.isDueAtDisbursement() && (lc.isInstalmentFee() ? !DateUtils.isBefore((LocalDate)tillDate, (LocalDate)dueDate) : this.isChargeDue(lc, tillDate, chargeOnDueDate, installment, period.isFirstPeriod())));
        for (LoanCharge loanCharge : loanCharges) {
            if (!loanCharge.isActive()) continue;
            this.addChargeAccrual(loanCharge, tillDate, chargeOnDueDate, installment, accrualPeriods);
        }
    }

    private void addChargeAccrual(@NonNull LoanCharge loanCharge, @NonNull LocalDate tillDate, boolean chargeOnDueDate, @NonNull LoanRepaymentScheduleInstallment installment, @NonNull AccrualPeriodsData accrualPeriods) {
        Money waived;
        Money chargeAmount;
        MonetaryCurrency currency = accrualPeriods.getCurrency();
        Integer firstInstallmentNumber = accrualPeriods.getFirstInstallmentNumber();
        boolean installmentFee = loanCharge.isInstalmentFee();
        LoanRepaymentScheduleInstallment dueInstallment = installmentFee || chargeOnDueDate ? installment : loanCharge.getLoan().getRepaymentScheduleInstallment(i -> LoanRepaymentScheduleProcessingWrapper.isInPeriod((LocalDate)loanCharge.getDueDate(), (LoanRepaymentScheduleInstallment)i, (boolean)i.getInstallmentNumber().equals(firstInstallmentNumber)));
        AccrualPeriodData duePeriod = accrualPeriods.getPeriodByInstallmentNumber(dueInstallment.getInstallmentNumber());
        boolean isFullPeriod = this.isFullPeriod(tillDate, dueInstallment);
        Long installmentChargeId = null;
        if (installmentFee) {
            LoanInstallmentCharge installmentCharge = loanCharge.getInstallmentLoanCharge(dueInstallment.getInstallmentNumber());
            if (installmentCharge == null) {
                return;
            }
            chargeAmount = installmentCharge.getAmount(currency);
            List paidBys = loanCharge.getLoanChargePaidBy(pb -> dueInstallment.getInstallmentNumber().equals(pb.getInstallmentNumber()));
            waived = isFullPeriod ? installmentCharge.getAmountWaived(currency) : MathUtil.toMoney((BigDecimal)this.calcChargeWaivedAmount((Collection)paidBys, tillDate), (MonetaryCurrency)currency);
            installmentChargeId = (Long)installmentCharge.getId();
        } else {
            chargeAmount = loanCharge.getAmount(currency);
            Set paidBys = loanCharge.getLoanChargePaidBySet();
            waived = isFullPeriod ? loanCharge.getAmountWaived(currency) : MathUtil.toMoney((BigDecimal)this.calcChargeWaivedAmount((Collection)paidBys, tillDate), (MonetaryCurrency)currency);
        }
        AccrualChargeData chargeData = new AccrualChargeData((Long)loanCharge.getId(), installmentChargeId, loanCharge.isPenaltyCharge()).setChargeAmount(chargeAmount);
        chargeData.setChargeAccruable(MathUtil.minusToZero((Money)chargeAmount, (Money[])new Money[]{waived}));
        Money unrecognizedWaived = MathUtil.toMoney((BigDecimal)this.loanTransactionRepository.findChargeUnrecognizedWaivedAmount(loanCharge, tillDate), (MonetaryCurrency)currency);
        Money transactionWaived = MathUtil.minusToZero((Money)waived, (Money[])new Money[]{unrecognizedWaived});
        Money transactionAccrued = installmentFee && installmentChargeId != null ? MathUtil.toMoney((BigDecimal)this.loanTransactionRepository.findChargeAccrualAmountByInstallment(loanCharge, dueInstallment.getInstallmentNumber()), (MonetaryCurrency)currency) : MathUtil.toMoney((BigDecimal)this.loanTransactionRepository.findChargeAccrualAmount(loanCharge), (MonetaryCurrency)currency);
        chargeData.setTransactionAccrued(transactionAccrued);
        chargeData.setChargeAccrued(MathUtil.minusToZero((Money)transactionAccrued, (Money[])new Money[]{transactionWaived}));
        duePeriod.addCharge(chargeData);
    }

    @NonNull
    private BigDecimal calcChargeWaivedAmount(@NonNull Collection<LoanChargePaidBy> loanChargePaidBy, @NonNull LocalDate tillDate) {
        return loanChargePaidBy.stream().filter(pb -> {
            LoanTransaction t = pb.getLoanTransaction();
            return !t.isReversed() && t.isWaiveCharge() && !DateUtils.isAfter((LocalDate)t.getTransactionDate(), (LocalDate)tillDate);
        }).map(LoanChargePaidBy::getAmount).reduce(BigDecimal.ZERO, MathUtil::add);
    }

    private boolean isChargeDue(@NonNull LoanCharge loanCharge, @NonNull LocalDate tillDate, boolean chargeOnDueDate, LoanRepaymentScheduleInstallment installment, boolean isFirstPeriod) {
        LocalDate fromDate = installment.getFromDate();
        LocalDate dueDate = installment.getDueDate();
        LocalDate toDate = DateUtils.isBefore((LocalDate)dueDate, (LocalDate)tillDate) ? dueDate : tillDate;
        chargeOnDueDate = chargeOnDueDate || loanCharge.getDueLocalDate().isBefore(loanCharge.getSubmittedOnDate());
        return chargeOnDueDate ? loanCharge.isDueInPeriod(fromDate, toDate, isFirstPeriod) : LoanRepaymentScheduleProcessingWrapper.isInPeriod((LocalDate)loanCharge.getSubmittedOnDate(), (LocalDate)fromDate, (LocalDate)toDate, (boolean)isFirstPeriod);
    }

    private LoanTransaction createOrMergeAccrualTransaction(@NonNull Loan loan, LoanTransaction transaction, LocalDate transactionDate, AccrualPeriodData accrualPeriod, List<LoanTransaction> accrualTransactions, Money interest, Money fee, Money penalty, boolean adjustment) {
        if (transaction == null) {
            transaction = this.addAccrualTransaction(loan, transactionDate, accrualPeriod, interest, fee, penalty, adjustment);
            if (transaction != null) {
                accrualTransactions.add(transaction);
            }
        } else {
            this.mergeAccrualTransaction(transaction, accrualPeriod, interest, fee, penalty, adjustment);
        }
        return transaction;
    }

    private LoanTransaction addAccrualTransaction(@NonNull Loan loan, @NonNull LocalDate transactionDate, AccrualPeriodData accrualPeriod, Money interestPortion, Money feePortion, Money penaltyPortion, boolean adjustment) {
        BigDecimal penalty;
        BigDecimal fee;
        BigDecimal interest = MathUtil.toBigDecimal((Money)(interestPortion = MathUtil.negativeToZero((Money)interestPortion)));
        BigDecimal amount = MathUtil.add((BigDecimal[])new BigDecimal[]{interest, fee = MathUtil.toBigDecimal((Money)(feePortion = MathUtil.negativeToZero((Money)feePortion))), penalty = MathUtil.toBigDecimal((Money)(penaltyPortion = MathUtil.negativeToZero((Money)penaltyPortion)))});
        if (!MathUtil.isGreaterThanZero((BigDecimal)amount)) {
            return null;
        }
        LoanTransaction transaction = adjustment ? LoanTransaction.accrualAdjustment((Loan)loan, (Office)loan.getOffice(), (LocalDate)transactionDate, (BigDecimal)amount, (BigDecimal)interest, (BigDecimal)fee, (BigDecimal)penalty, (ExternalId)this.externalIdFactory.create()) : LoanTransaction.accrueTransaction((Loan)loan, (Office)loan.getOffice(), (LocalDate)transactionDate, (BigDecimal)amount, (BigDecimal)interest, (BigDecimal)fee, (BigDecimal)penalty, (ExternalId)this.externalIdFactory.create());
        this.addTransactionMappings(transaction, accrualPeriod, adjustment);
        LoanTransaction savedTransaction = (LoanTransaction)this.loanTransactionRepository.save((Object)transaction);
        loan.addLoanTransaction(savedTransaction);
        return savedTransaction;
    }

    private void mergeAccrualTransaction(@NonNull LoanTransaction transaction, AccrualPeriodData accrualPeriod, Money interestPortion, Money feePortion, Money penaltyPortion, boolean adjustment) {
        interestPortion = MathUtil.negativeToZero((Money)interestPortion);
        feePortion = MathUtil.negativeToZero((Money)feePortion);
        penaltyPortion = MathUtil.negativeToZero((Money)penaltyPortion);
        if (MathUtil.isEmpty((Money)interestPortion) && MathUtil.isEmpty((Money)feePortion) && MathUtil.isEmpty((Money)penaltyPortion)) {
            return;
        }
        transaction.updateComponentsAndTotal(null, interestPortion, feePortion, penaltyPortion);
        this.addTransactionMappings(transaction, accrualPeriod, adjustment);
    }

    private void addTransactionMappings(@NonNull LoanTransaction transaction, AccrualPeriodData accrualPeriod, boolean adjustment) {
        if (accrualPeriod == null) {
            return;
        }
        Loan loan = transaction.getLoan();
        Integer installmentNumber = accrualPeriod.getInstallmentNumber();
        LoanRepaymentScheduleInstallment installment = loan.fetchRepaymentScheduleInstallment(installmentNumber);
        this.addPaidByMappings(transaction, installment, accrualPeriod, adjustment);
    }

    private void addPaidByMappings(@NonNull LoanTransaction transaction, LoanRepaymentScheduleInstallment installment, AccrualPeriodData accrualPeriod, boolean adjustment) {
        Loan loan = installment.getLoan();
        MonetaryCurrency currency = loan.getCurrency();
        for (AccrualChargeData accrualCharge : accrualPeriod.getCharges()) {
            Money chargeAccruable = MathUtil.nullToZero((Money)accrualCharge.getChargeAccruable(), (MonetaryCurrency)currency);
            Money chargePortion = MathUtil.minus((Money)chargeAccruable, (Money)accrualCharge.getChargeAccrued());
            chargePortion = MathUtil.negativeToZero((Money)(adjustment ? MathUtil.negate((Money)chargePortion) : chargePortion));
            if (MathUtil.isEmpty((Money)chargePortion)) continue;
            BigDecimal chargeAmount = MathUtil.toBigDecimal((Money)chargePortion);
            LoanCharge loanCharge = this.loanChargeService.fetchLoanChargesById(loan, accrualCharge.getLoanChargeId());
            LoanChargePaidBy paidBy = new LoanChargePaidBy(transaction, loanCharge, chargeAmount, installment.getInstallmentNumber());
            loanCharge.getLoanChargePaidBySet().add(paidBy);
            transaction.getLoanChargesPaid().add(paidBy);
            Long installmentChargeId = accrualCharge.getLoanInstallmentChargeId();
            if (installmentChargeId == null) continue;
            LoanInstallmentCharge installmentCharge = new LoanInstallmentCharge(chargeAmount, loanCharge, installment);
            loanCharge.getLoanInstallmentCharge().add(installmentCharge);
            installment.getInstallmentCharges().add(installmentCharge);
        }
    }

    private boolean isFullPeriod(@NonNull LocalDate tillDate, @NonNull LoanRepaymentScheduleInstallment installment) {
        return LoanRepaymentScheduleProcessingWrapper.isAfterPeriod((LocalDate)tillDate, (LoanRepaymentScheduleInstallment)installment) || DateUtils.isEqual((LocalDate)tillDate, (LocalDate)installment.getDueDate());
    }

    private void reprocessPeriodicAccruals(Loan loan, List<LoanTransaction> accrualTransactions, boolean addEvent) {
        if (loan.isChargedOff()) {
            return;
        }
        boolean isChargeOnDueDate = this.isChargeOnDueDate();
        this.ensureAccrualTransactionMappings(loan, isChargeOnDueDate);
        LoanRepaymentScheduleInstallment lastInstallment = loan.getLastLoanRepaymentScheduleInstallment();
        LocalDate lastDueDate = lastInstallment.getDueDate();
        if (this.isProgressiveAccrual(loan)) {
            AccrualBalances accrualBalances = new AccrualBalances();
            accrualTransactions.forEach(lt -> {
                switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanTransactionType[lt.getTypeOf().ordinal()]) {
                    case 1: {
                        accrualBalances.setFeePortion(MathUtil.add((BigDecimal)accrualBalances.getFeePortion(), (BigDecimal)lt.getFeeChargesPortion()));
                        accrualBalances.setPenaltyPortion(MathUtil.add((BigDecimal)accrualBalances.getPenaltyPortion(), (BigDecimal)lt.getPenaltyChargesPortion()));
                        accrualBalances.setInterestPortion(MathUtil.add((BigDecimal)accrualBalances.getInterestPortion(), (BigDecimal)lt.getInterestPortion()));
                        break;
                    }
                    case 2: {
                        accrualBalances.setFeePortion(MathUtil.subtract((BigDecimal)accrualBalances.getFeePortion(), (BigDecimal[])new BigDecimal[]{lt.getFeeChargesPortion()}));
                        accrualBalances.setPenaltyPortion(MathUtil.subtract((BigDecimal)accrualBalances.getPenaltyPortion(), (BigDecimal[])new BigDecimal[]{lt.getPenaltyChargesPortion()}));
                        accrualBalances.setInterestPortion(MathUtil.subtract((BigDecimal)accrualBalances.getInterestPortion(), (BigDecimal[])new BigDecimal[]{lt.getInterestPortion()}));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + String.valueOf(lt.getTypeOf()));
                    }
                }
            });
            for (LoanRepaymentScheduleInstallment installment : loan.getRepaymentScheduleInstallments()) {
                BigDecimal maximumAccruableInterest = MathUtil.nullToZero((BigDecimal)installment.getInterestCharged());
                BigDecimal maximumAccruableFee = MathUtil.nullToZero((BigDecimal)installment.getFeeChargesCharged());
                BigDecimal maximumAccruablePenalty = MathUtil.nullToZero((BigDecimal)installment.getPenaltyCharges());
                if (MathUtil.isLessThanOrEqualTo((BigDecimal)maximumAccruableInterest, (BigDecimal)accrualBalances.getInterestPortion())) {
                    installment.setInterestAccrued(maximumAccruableInterest);
                    accrualBalances.setInterestPortion(accrualBalances.getInterestPortion().subtract(maximumAccruableInterest));
                } else {
                    installment.setInterestAccrued(accrualBalances.getInterestPortion());
                    accrualBalances.setInterestPortion(BigDecimal.ZERO);
                }
                if (MathUtil.isLessThanOrEqualTo((BigDecimal)maximumAccruableFee, (BigDecimal)accrualBalances.getFeePortion())) {
                    installment.setFeeAccrued(maximumAccruableFee);
                    accrualBalances.setFeePortion(accrualBalances.getFeePortion().subtract(maximumAccruableFee));
                } else {
                    installment.setFeeAccrued(accrualBalances.getFeePortion());
                    accrualBalances.setFeePortion(BigDecimal.ZERO);
                }
                if (MathUtil.isLessThanOrEqualTo((BigDecimal)maximumAccruablePenalty, (BigDecimal)accrualBalances.getPenaltyPortion())) {
                    installment.setPenaltyAccrued(maximumAccruablePenalty);
                    accrualBalances.setPenaltyPortion(accrualBalances.getPenaltyPortion().subtract(maximumAccruablePenalty));
                    continue;
                }
                installment.setPenaltyAccrued(accrualBalances.getPenaltyPortion());
                accrualBalances.setPenaltyPortion(BigDecimal.ZERO);
            }
        } else {
            List installments = loan.getRepaymentScheduleInstallments();
            boolean isBasedOnSubmittedOnDate = !isChargeOnDueDate;
            for (LoanRepaymentScheduleInstallment installment : installments) {
                this.checkAndUpdateAccrualsForInstallment(loan, accrualTransactions, installments, isBasedOnSubmittedOnDate, installment, addEvent);
            }
        }
        this.reverseTransactionsAfter(loan, ACCRUAL_TYPES, lastDueDate, addEvent);
    }

    private void reprocessNonPeriodicAccruals(Loan loan, List<LoanTransaction> accrualTransactions, boolean addEvent) {
        if (this.isProgressiveAccrual(loan)) {
            return;
        }
        Money interestApplied = Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)loan.getSummary().getTotalInterestCharged());
        ExternalId externalId = ExternalId.empty();
        boolean isExternalIdAutoGenerationEnabled = this.configurationDomainService.isExternalIdAutoGenerationEnabled();
        for (LoanTransaction accrualTransaction : accrualTransactions) {
            if (accrualTransaction.getInterestPortion(loan.getCurrency()).isGreaterThanZero()) {
                if (!accrualTransaction.getInterestPortion(loan.getCurrency()).isNotEqualTo(interestApplied)) continue;
                accrualTransaction.reverse();
                if (addEvent) {
                    this.journalEntryPoster.postJournalEntriesForLoanTransaction(accrualTransaction, false, false);
                    LoanAccrualAdjustmentTransactionBusinessEvent businessEvent = new LoanAccrualAdjustmentTransactionBusinessEvent(accrualTransaction);
                    this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
                }
                if (isExternalIdAutoGenerationEnabled) {
                    externalId = ExternalId.generate();
                }
                LoanTransaction interestAccrualTransaction = LoanTransaction.accrueInterest((Office)loan.getOffice(), (Loan)loan, (Money)interestApplied, (LocalDate)loan.getDisbursementDate(), (ExternalId)externalId);
                LoanTransaction savedInterestAccrualTransaction = (LoanTransaction)this.loanTransactionRepository.saveAndFlush((Object)interestAccrualTransaction);
                loan.addLoanTransaction(savedInterestAccrualTransaction);
                if (!addEvent) continue;
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedInterestAccrualTransaction, false, false);
                LoanAccrualTransactionCreatedBusinessEvent businessEvent = new LoanAccrualTransactionCreatedBusinessEvent(savedInterestAccrualTransaction);
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
                continue;
            }
            Set chargePaidBies = accrualTransaction.getLoanChargesPaid();
            for (LoanChargePaidBy chargePaidBy : chargePaidBies) {
                LoanTransaction applyLoanChargeTransaction;
                LoanCharge loanCharge = chargePaidBy.getLoanCharge();
                Money chargeAmount = loanCharge.getAmount(loan.getCurrency());
                if (!chargeAmount.isNotEqualTo(accrualTransaction.getAmount(loan.getCurrency()))) continue;
                accrualTransaction.reverse();
                if (addEvent) {
                    this.journalEntryPoster.postJournalEntriesForLoanTransaction(accrualTransaction, false, false);
                    LoanAccrualAdjustmentTransactionBusinessEvent businessEvent = new LoanAccrualAdjustmentTransactionBusinessEvent(accrualTransaction);
                    this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
                }
                if ((applyLoanChargeTransaction = this.loanChargeService.handleChargeAppliedTransaction(loan, loanCharge, accrualTransaction.getTransactionDate())) == null) continue;
                LoanTransaction savedApplyLoanChargeTransaction = (LoanTransaction)this.loanTransactionRepository.save((Object)applyLoanChargeTransaction);
                if (!addEvent) continue;
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedApplyLoanChargeTransaction, false, false);
                LoanAccrualTransactionCreatedBusinessEvent businessEvent = new LoanAccrualTransactionCreatedBusinessEvent(savedApplyLoanChargeTransaction);
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
            }
        }
    }

    private void checkAndUpdateAccrualsForInstallment(Loan loan, List<LoanTransaction> accrualTransactions, List<LoanRepaymentScheduleInstallment> installments, boolean isBasedOnSubmittedOnDate, LoanRepaymentScheduleInstallment installment, boolean addEvent) {
        Money zero;
        MonetaryCurrency currency = loan.getCurrency();
        Money interest = zero = Money.zero((MonetaryCurrency)currency);
        Money fee = zero;
        Money penalty = zero;
        for (LoanTransaction accrualTransaction : accrualTransactions) {
            LocalDate transactionDateForRange = this.getDateForRangeCalculation(accrualTransaction, isBasedOnSubmittedOnDate);
            boolean isInPeriod = LoanRepaymentScheduleProcessingWrapper.isInPeriod((LocalDate)transactionDateForRange, (LoanRepaymentScheduleInstallment)installment, installments);
            if (!isInPeriod || !this.hasIncomeAmountChangedForInstallment(loan, installment, interest = MathUtil.plus((Money)interest, (Money)accrualTransaction.getInterestPortion(currency)), fee = MathUtil.plus((Money)fee, (Money)accrualTransaction.getFeeChargesPortion(currency)), penalty = MathUtil.plus((Money)penalty, (Money)accrualTransaction.getPenaltyChargesPortion(currency)), accrualTransaction)) continue;
            interest = interest.minus(accrualTransaction.getInterestPortion(currency));
            fee = fee.minus(accrualTransaction.getFeeChargesPortion(currency));
            penalty = penalty.minus(accrualTransaction.getPenaltyChargesPortion(currency));
            accrualTransaction.reverse();
            if (!addEvent) continue;
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(accrualTransaction, false, false);
            LoanAccrualAdjustmentTransactionBusinessEvent businessEvent = new LoanAccrualAdjustmentTransactionBusinessEvent(accrualTransaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
        }
        installment.updateAccrualPortion(interest, fee, penalty);
    }

    private boolean hasIncomeAmountChangedForInstallment(Loan loan, LoanRepaymentScheduleInstallment installment, Money interest, Money fee, Money penalty, LoanTransaction loanTransaction) {
        return installment.getFeeChargesCharged(loan.getCurrency()).isLessThan(fee) || installment.getInterestCharged(loan.getCurrency()).isLessThan(interest) || installment.getPenaltyChargesCharged(loan.getCurrency()).isLessThan(penalty) || loan.isInterestBearing() && DateUtils.isEqual((LocalDate)loan.getAccruedTill(), (LocalDate)loanTransaction.getTransactionDate()) && !DateUtils.isEqual((LocalDate)loan.getAccruedTill(), (LocalDate)installment.getDueDate());
    }

    private LocalDate getDateForRangeCalculation(LoanTransaction loanTransaction, boolean isChargeAccrualBasedOnSubmittedOnDate) {
        return isChargeAccrualBasedOnSubmittedOnDate && !loanTransaction.getLoanChargesPaid().isEmpty() ? ((LoanChargePaidBy)loanTransaction.getLoanChargesPaid().stream().findFirst().get()).getLoanCharge().getEffectiveDueDate() : loanTransaction.getTransactionDate();
    }

    private List<LoanInterestRecalcualtionAdditionalDetails> extractInterestRecalculationAdditionalDetails(Loan loan) {
        ArrayList<LoanInterestRecalcualtionAdditionalDetails> retDetails = new ArrayList<LoanInterestRecalcualtionAdditionalDetails>();
        List repaymentSchedule = loan.getRepaymentScheduleInstallments();
        if (null != repaymentSchedule) {
            for (LoanRepaymentScheduleInstallment installment : repaymentSchedule) {
                if (null == installment.getLoanCompoundingDetails()) continue;
                retDetails.addAll(installment.getLoanCompoundingDetails());
            }
        }
        retDetails.sort(Comparator.comparing(LoanInterestRecalcualtionAdditionalDetails::getEffectiveDate));
        return retDetails;
    }

    private void addUpdateIncomeAndAccrualTransaction(Loan loan, LoanInterestRecalcualtionAdditionalDetails compoundingDetail, LocalDate lastCompoundingDate, boolean addEvent) {
        BigDecimal interest = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal penalties = BigDecimal.ZERO;
        HashMap feeDetails = new HashMap();
        if (loan.getLoanInterestRecalculationDetails().getInterestRecalculationCompoundingMethod().equals((Object)InterestRecalculationCompoundingMethod.INTEREST)) {
            interest = compoundingDetail.getAmount();
        } else if (loan.getLoanInterestRecalculationDetails().getInterestRecalculationCompoundingMethod().equals((Object)InterestRecalculationCompoundingMethod.FEE)) {
            this.determineFeeDetails(loan, lastCompoundingDate, compoundingDetail.getEffectiveDate(), feeDetails);
            fee = (BigDecimal)feeDetails.get("fee");
            penalties = (BigDecimal)feeDetails.get("penalties");
        } else if (loan.getLoanInterestRecalculationDetails().getInterestRecalculationCompoundingMethod().equals((Object)InterestRecalculationCompoundingMethod.INTEREST_AND_FEE)) {
            this.determineFeeDetails(loan, lastCompoundingDate, compoundingDetail.getEffectiveDate(), feeDetails);
            fee = (BigDecimal)feeDetails.get("fee");
            penalties = (BigDecimal)feeDetails.get("penalties");
            interest = compoundingDetail.getAmount().subtract(fee).subtract(penalties);
        }
        ExternalId externalId = ExternalId.empty();
        if (this.configurationDomainService.isExternalIdAutoGenerationEnabled()) {
            externalId = ExternalId.generate();
        }
        this.createUpdateIncomePostingTransaction(loan, compoundingDetail, interest, fee, penalties, externalId);
        this.createUpdateAccrualTransaction(loan, compoundingDetail, interest, fee, penalties, feeDetails, externalId, addEvent);
        this.loanBalanceService.updateLoanOutstandingBalances(loan);
    }

    private void createUpdateIncomePostingTransaction(Loan loan, LoanInterestRecalcualtionAdditionalDetails compoundingDetail, BigDecimal interest, BigDecimal fee, BigDecimal penalties, ExternalId externalId) {
        Optional incomeTransaction = this.loanTransactionRepository.findNonReversedByLoanAndTypesAndDate(loan, Set.of(LoanTransactionType.INCOME_POSTING), compoundingDetail.getEffectiveDate());
        if (incomeTransaction.isEmpty()) {
            LoanTransaction transaction = LoanTransaction.incomePosting((Loan)loan, (Office)loan.getOffice(), (LocalDate)compoundingDetail.getEffectiveDate(), (BigDecimal)compoundingDetail.getAmount(), (BigDecimal)interest, (BigDecimal)fee, (BigDecimal)penalties, (ExternalId)externalId);
            LoanTransaction savedTransaction = (LoanTransaction)this.loanTransactionRepository.save((Object)transaction);
            loan.addLoanTransaction(savedTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedTransaction, false, false);
        } else if (((LoanTransaction)incomeTransaction.get()).getAmount(loan.getCurrency()).getAmount().compareTo(compoundingDetail.getAmount()) != 0) {
            ((LoanTransaction)incomeTransaction.get()).reverse();
            this.journalEntryPoster.postJournalEntriesForLoanTransaction((LoanTransaction)incomeTransaction.get(), false, false);
            LoanTransaction transaction = LoanTransaction.incomePosting((Loan)loan, (Office)loan.getOffice(), (LocalDate)compoundingDetail.getEffectiveDate(), (BigDecimal)compoundingDetail.getAmount(), (BigDecimal)interest, (BigDecimal)fee, (BigDecimal)penalties, (ExternalId)externalId);
            LoanTransaction savedTransaction = (LoanTransaction)this.loanTransactionRepository.save((Object)transaction);
            loan.addLoanTransaction(savedTransaction);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedTransaction, false, false);
        }
    }

    private void createUpdateAccrualTransaction(Loan loan, LoanInterestRecalcualtionAdditionalDetails compoundingDetail, BigDecimal interest, BigDecimal fee, BigDecimal penalties, HashMap<String, Object> feeDetails, ExternalId externalId, boolean addEvent) {
        Optional accrualTransaction;
        if (this.configurationDomainService.isExternalIdAutoGenerationEnabled()) {
            externalId = ExternalId.generate();
        }
        if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue() && ((accrualTransaction = this.loanTransactionRepository.findNonReversedByLoanAndTypesAndDate(loan, Set.of(LoanTransactionType.ACCRUAL, LoanTransactionType.ACCRUAL_ADJUSTMENT), compoundingDetail.getEffectiveDate())).isEmpty() || !MathUtil.isEqualTo((BigDecimal)((LoanTransaction)accrualTransaction.get()).getAmount(), (BigDecimal)compoundingDetail.getAmount()))) {
            accrualTransaction.ifPresent(accrualTrans -> {
                accrualTrans.reverse();
                if (addEvent) {
                    this.journalEntryPoster.postJournalEntriesForLoanTransaction(accrualTrans, false, false);
                    LoanAccrualAdjustmentTransactionBusinessEvent businessEvent = new LoanAccrualAdjustmentTransactionBusinessEvent(accrualTrans);
                    this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
                }
            });
            LoanTransaction accrual = LoanTransaction.accrueTransaction((Loan)loan, (Office)loan.getOffice(), (LocalDate)compoundingDetail.getEffectiveDate(), (BigDecimal)compoundingDetail.getAmount(), (BigDecimal)interest, (BigDecimal)fee, (BigDecimal)penalties, (ExternalId)externalId);
            this.updateLoanChargesPaidBy(loan, accrual, feeDetails, null);
            LoanTransaction savedAccrual = (LoanTransaction)this.loanTransactionRepository.save((Object)accrual);
            loan.addLoanTransaction(savedAccrual);
            if (addEvent) {
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedAccrual, false, false);
                LoanAccrualTransactionCreatedBusinessEvent businessEvent = new LoanAccrualTransactionCreatedBusinessEvent(savedAccrual);
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
            }
        }
    }

    private void processIncomeAndAccrualTransactionOnLoanClosure(Loan loan) {
        if (loan.getLoanInterestRecalculationDetails() != null && loan.getLoanInterestRecalculationDetails().isCompoundingToBePostedAsTransaction() && loan.getStatus().isClosedObligationsMet() && !loan.isNpa() && !loan.isChargedOff()) {
            LocalDate closedDate = loan.getClosedOnDate();
            this.reverseTransactionsOnOrAfter(loan, Set.of(LoanTransactionType.INCOME_POSTING, LoanTransactionType.ACCRUAL, LoanTransactionType.ACCRUAL_ADJUSTMENT), closedDate);
            HashMap cumulativeIncomeFromInstallments = new HashMap();
            this.determineCumulativeIncomeFromInstallments(loan, cumulativeIncomeFromInstallments);
            CumulativeIncomeFromIncomePosting cumulativeIncomeFromIncomePosting = this.loanTransactionRepository.findCumulativeIncomeByLoanAndType(loan);
            BigDecimal interestToPost = ((BigDecimal)cumulativeIncomeFromInstallments.get("interest")).subtract(cumulativeIncomeFromIncomePosting.interestAmount());
            BigDecimal feeToPost = ((BigDecimal)cumulativeIncomeFromInstallments.get("fee")).subtract(cumulativeIncomeFromIncomePosting.feeAmount());
            BigDecimal penaltyToPost = ((BigDecimal)cumulativeIncomeFromInstallments.get("penalty")).subtract(cumulativeIncomeFromIncomePosting.penaltyAmount());
            BigDecimal amountToPost = interestToPost.add(feeToPost).add(penaltyToPost);
            this.createIncomePostingAndAccrualTransactionOnLoanClosure(loan, closedDate, interestToPost, feeToPost, penaltyToPost, amountToPost);
        }
        this.loanBalanceService.updateLoanOutstandingBalances(loan);
    }

    private void determineCumulativeIncomeFromInstallments(Loan loan, Map<String, BigDecimal> cumulativeIncomeFromInstallments) {
        BigDecimal interest = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal penalty = BigDecimal.ZERO;
        List installments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment installment : installments) {
            interest = interest.add(installment.getInterestCharged(loan.getCurrency()).getAmount());
            fee = fee.add(installment.getFeeChargesCharged(loan.getCurrency()).getAmount());
            penalty = penalty.add(installment.getPenaltyChargesCharged(loan.getCurrency()).getAmount());
        }
        cumulativeIncomeFromInstallments.put("interest", interest);
        cumulativeIncomeFromInstallments.put("fee", fee);
        cumulativeIncomeFromInstallments.put("penalty", penalty);
    }

    private void createIncomePostingAndAccrualTransactionOnLoanClosure(Loan loan, LocalDate closedDate, BigDecimal interestToPost, BigDecimal feeToPost, BigDecimal penaltyToPost, BigDecimal amountToPost) {
        ExternalId externalId = ExternalId.empty();
        boolean isExternalIdAutoGenerationEnabled = this.configurationDomainService.isExternalIdAutoGenerationEnabled();
        if (isExternalIdAutoGenerationEnabled) {
            externalId = ExternalId.generate();
        }
        LoanTransaction finalIncomeTransaction = LoanTransaction.incomePosting((Loan)loan, (Office)loan.getOffice(), (LocalDate)closedDate, (BigDecimal)amountToPost, (BigDecimal)interestToPost, (BigDecimal)feeToPost, (BigDecimal)penaltyToPost, (ExternalId)externalId);
        LoanTransaction savedFinalIncomeTransaction = (LoanTransaction)this.loanTransactionRepository.save((Object)finalIncomeTransaction);
        loan.addLoanTransaction(savedFinalIncomeTransaction);
        this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedFinalIncomeTransaction, false, false);
        if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue()) {
            LocalDate lastAccruedDate = this.loanTransactionRepository.findLastNonReversedTransactionDateByLoanAndTypes(loan, ACCRUAL_TYPES).orElse(loan.getDisbursementDate());
            HashMap feeDetails = new HashMap();
            this.determineFeeDetails(loan, lastAccruedDate, closedDate, feeDetails);
            if (isExternalIdAutoGenerationEnabled) {
                externalId = ExternalId.generate();
            }
            LoanTransaction finalAccrual = LoanTransaction.accrueTransaction((Loan)loan, (Office)loan.getOffice(), (LocalDate)closedDate, (BigDecimal)amountToPost, (BigDecimal)interestToPost, (BigDecimal)feeToPost, (BigDecimal)penaltyToPost, (ExternalId)externalId);
            this.updateLoanChargesPaidBy(loan, finalAccrual, feeDetails, null);
            LoanTransaction savedFinalAccrual = (LoanTransaction)this.loanTransactionRepository.save((Object)finalAccrual);
            loan.addLoanTransaction(savedFinalAccrual);
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(savedFinalAccrual, false, false);
        }
    }

    private Map<String, Money> determineReceivableIncomeForeClosure(Loan loan, LocalDate tillDate) {
        MonetaryCurrency currency = loan.getCurrency();
        Money receivableInterest = Money.zero((MonetaryCurrency)currency);
        Money receivableFee = Money.zero((MonetaryCurrency)currency);
        Money receivablePenalty = Money.zero((MonetaryCurrency)currency);
        List transactionPortions = this.loanTransactionRepository.findTransactionDataForForeclosureIncome(loan, tillDate);
        for (TransactionPortionsForForeclosure transactionPortion : transactionPortions) {
            LoanTransactionType transactionType = transactionPortion.getTransactionType();
            BigDecimal interestPortion = transactionPortion.getInterestPortion();
            BigDecimal feePortion = transactionPortion.getFeeChargesPortion();
            BigDecimal penaltyPortion = transactionPortion.getPenaltyChargesPortion();
            if (transactionType.isAccrual()) {
                receivableInterest = receivableInterest.plus(Money.of((MonetaryCurrency)currency, (BigDecimal)interestPortion));
                receivableFee = receivableFee.plus(Money.of((MonetaryCurrency)currency, (BigDecimal)feePortion));
                receivablePenalty = receivablePenalty.plus(Money.of((MonetaryCurrency)currency, (BigDecimal)penaltyPortion));
            } else if (transactionType.isRepayment() || transactionType.isChargePayment() || transactionType.isAccrualAdjustment()) {
                receivableInterest = receivableInterest.minus(Money.of((MonetaryCurrency)currency, (BigDecimal)interestPortion));
                receivableFee = receivableFee.minus(Money.of((MonetaryCurrency)currency, (BigDecimal)feePortion));
                receivablePenalty = receivablePenalty.minus(Money.of((MonetaryCurrency)currency, (BigDecimal)penaltyPortion));
            }
            if (receivableInterest.isLessThanZero()) {
                receivableInterest = receivableInterest.zero();
            }
            if (receivableFee.isLessThanZero()) {
                receivableFee = receivableFee.zero();
            }
            if (!receivablePenalty.isLessThanZero()) continue;
            receivablePenalty = receivablePenalty.zero();
        }
        return Map.of("interest", receivableInterest, "fee", receivableFee, "penalties", receivablePenalty);
    }

    private void createAccrualTransactionAndUpdateChargesPaidBy(Loan loan, LocalDate foreClosureDate, List<LoanTransaction> newAccrualTransactions, MonetaryCurrency currency, Money interestPortion, Money feePortion, Money penaltyPortion, Money total) {
        ExternalId accrualExternalId = this.externalIdFactory.create();
        LoanTransaction accrualTransaction = LoanTransaction.accrueTransaction((Loan)loan, (Office)loan.getOffice(), (LocalDate)foreClosureDate, (BigDecimal)total.getAmount(), (BigDecimal)interestPortion.getAmount(), (BigDecimal)feePortion.getAmount(), (BigDecimal)penaltyPortion.getAmount(), (ExternalId)accrualExternalId);
        LocalDate fromDate = loan.getDisbursementDate();
        if (loan.getAccruedTill() != null) {
            fromDate = loan.getAccruedTill();
        }
        newAccrualTransactions.add(accrualTransaction);
        Set accrualCharges = accrualTransaction.getLoanChargesPaid();
        for (LoanCharge loanCharge : loan.getActiveCharges()) {
            boolean isDue = loanCharge.isDueInPeriod(fromDate, foreClosureDate, DateUtils.isEqual((LocalDate)fromDate, (LocalDate)loan.getDisbursementDate()));
            if (!loanCharge.isActive() || loanCharge.isPaid() || !isDue && !loanCharge.isInstalmentFee()) continue;
            LoanChargePaidBy loanChargePaidBy = new LoanChargePaidBy(accrualTransaction, loanCharge, loanCharge.getAmountOutstanding(currency).getAmount(), null);
            accrualCharges.add(loanChargePaidBy);
            loanCharge.getLoanChargePaidBySet().add(loanChargePaidBy);
        }
    }

    private void ensureAccrualTransactionMappings(Loan loan, boolean chargeOnDueDate) {
        List entriesToProcess = this.loanChargePaidByRepository.findChargePaidByMappingsWithoutInstallmentNumber(loan);
        if (entriesToProcess.isEmpty()) {
            return;
        }
        int firstInstallmentNumber = LoanRepaymentScheduleProcessingWrapper.fetchFirstNormalInstallmentNumber((List)loan.getRepaymentScheduleInstallments());
        for (LoanChargePaidBy paidBy : entriesToProcess) {
            LoanCharge loanCharge = paidBy.getLoanCharge();
            LocalDate chargeDate = chargeOnDueDate || loanCharge.isInstalmentFee() ? paidBy.getLoanTransaction().getTransactionDate() : loanCharge.getDueDate();
            LoanRepaymentScheduleInstallment installment = loan.getRepaymentScheduleInstallment(i -> LoanRepaymentScheduleProcessingWrapper.isInPeriod((LocalDate)chargeDate, (LoanRepaymentScheduleInstallment)i, (boolean)i.getInstallmentNumber().equals(firstInstallmentNumber)));
            if (installment == null) continue;
            paidBy.setInstallmentNumber(installment.getInstallmentNumber());
        }
    }

    private List<LoanTransaction> retrieveListOfAccrualTransactions(Loan loan) {
        return this.loanTransactionRepository.findNonReversedByLoanAndTypes(loan, ACCRUAL_TYPES).stream().sorted(LoanTransactionComparator.INSTANCE).collect(Collectors.toList());
    }

    private boolean isChargeOnDueDate() {
        String chargeAccrualDateType = this.configurationDomainService.getAccrualDateConfigForCharge();
        return !ACCRUAL_ON_CHARGE_SUBMITTED_ON_DATE.equalsIgnoreCase(chargeAccrualDateType);
    }

    private void determineFeeDetails(Loan loan, LocalDate fromDate, LocalDate toDate, Map<String, Object> feeDetails) {
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal penalties = BigDecimal.ZERO;
        ArrayList<Integer> installments = new ArrayList<Integer>();
        List repaymentSchedule = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment : repaymentSchedule) {
            if (!DateUtils.isAfter((LocalDate)loanRepaymentScheduleInstallment.getDueDate(), (LocalDate)fromDate) || DateUtils.isAfter((LocalDate)loanRepaymentScheduleInstallment.getDueDate(), (LocalDate)toDate)) continue;
            installments.add(loanRepaymentScheduleInstallment.getInstallmentNumber());
        }
        ArrayList<LoanCharge> loanCharges = new ArrayList<LoanCharge>();
        ArrayList<LoanInstallmentCharge> loanInstallmentCharges = new ArrayList<LoanInstallmentCharge>();
        for (LoanCharge loanCharge : loan.getActiveCharges()) {
            boolean isDue = loanCharge.isDueInPeriod(fromDate, toDate, DateUtils.isEqual((LocalDate)fromDate, (LocalDate)loan.getDisbursementDate()));
            if (isDue) {
                if (loanCharge.isPenaltyCharge() && !loanCharge.isInstalmentFee()) {
                    penalties = penalties.add(loanCharge.amount());
                    loanCharges.add(loanCharge);
                    continue;
                }
                if (loanCharge.isInstalmentFee()) continue;
                fee = fee.add(loanCharge.amount());
                loanCharges.add(loanCharge);
                continue;
            }
            if (!loanCharge.isInstalmentFee()) continue;
            for (LoanInstallmentCharge installmentCharge : loanCharge.installmentCharges()) {
                if (!installments.contains(installmentCharge.getRepaymentInstallment().getInstallmentNumber())) continue;
                fee = fee.add(installmentCharge.getAmount());
                loanInstallmentCharges.add(installmentCharge);
            }
        }
        feeDetails.put("fee", fee);
        feeDetails.put("penalties", penalties);
        feeDetails.put("loanCharges", loanCharges);
        feeDetails.put("loanInstallmentCharges", loanInstallmentCharges);
    }

    private void updateLoanChargesPaidBy(Loan loan, LoanTransaction accrual, Map<String, Object> feeDetails, LoanRepaymentScheduleInstallment installment) {
        LoanChargePaidBy loanChargePaidBy;
        Integer installmentNumber;
        List loanCharges = (List)feeDetails.get("loanCharges");
        List loanInstallmentCharges = (List)feeDetails.get("loanInstallmentCharges");
        if (loanCharges != null) {
            for (LoanCharge loanCharge : loanCharges) {
                installmentNumber = null == installment ? null : installment.getInstallmentNumber();
                loanChargePaidBy = new LoanChargePaidBy(accrual, loanCharge, loanCharge.getAmount(loan.getCurrency()).getAmount(), installmentNumber);
                accrual.getLoanChargesPaid().add(loanChargePaidBy);
            }
        }
        if (loanInstallmentCharges != null) {
            for (LoanInstallmentCharge loanInstallmentCharge : loanInstallmentCharges) {
                installmentNumber = null == loanInstallmentCharge.getInstallment() ? null : loanInstallmentCharge.getInstallment().getInstallmentNumber();
                loanChargePaidBy = new LoanChargePaidBy(accrual, loanInstallmentCharge.getLoanCharge(), loanInstallmentCharge.getAmount(loan.getCurrency()).getAmount(), installmentNumber);
                accrual.getLoanChargesPaid().add(loanChargePaidBy);
            }
        }
    }

    private void reverseTransactionsAfter(Loan loan, Set<LoanTransactionType> types, LocalDate effectiveDate, boolean addEvent) {
        this.loanTransactionRepository.findNonReversedByLoanAndTypesAndAfterDate(loan, types, effectiveDate).forEach(transaction -> this.reverseAccrual(transaction, addEvent));
    }

    private void reverseTransactionsOnOrAfter(Loan loan, Set<LoanTransactionType> types, LocalDate date) {
        this.loanTransactionRepository.findNonReversedByLoanAndTypesAndOnOrAfterDate(loan, types, date).forEach(transaction -> this.reverseAccrual(transaction, true));
    }

    private void reverseAccrual(LoanTransaction transaction, boolean addEvent) {
        transaction.reverse();
        if (addEvent) {
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(transaction, false, false);
            LoanAccrualAdjustmentTransactionBusinessEvent businessEvent = new LoanAccrualAdjustmentTransactionBusinessEvent(transaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)businessEvent);
        }
    }

    private LocalDate getFinalAccrualTransactionDate(Loan loan) {
        return switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanStatus[loan.getStatus().ordinal()]) {
            case 1 -> loan.getClosedOnDate();
            case 2 -> loan.getOverpaidOnDate();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(loan.getStatus()));
        };
    }

    public boolean isProgressiveAccrual(@NonNull Loan loan) {
        return loan.isProgressiveSchedule();
    }

    @Generated
    public LoanAccrualsProcessingServiceImpl(ExternalIdFactory externalIdFactory, BusinessEventNotifierService businessEventNotifierService, ConfigurationDomainService configurationDomainService, LoanRepositoryWrapper loanRepositoryWrapper, LoanTransactionRepository loanTransactionRepository, LoanScheduleGeneratorFactory loanScheduleFactory, @Qualifier(value="fineractConfigurableThreadPoolTaskExecutor") ThreadPoolTaskExecutor taskExecutor, TransactionTemplate transactionTemplate, LoanChargeService loanChargeService, LoanBalanceService loanBalanceService, LoanChargePaidByRepository loanChargePaidByRepository, LoanJournalEntryPoster journalEntryPoster) {
        this.externalIdFactory = externalIdFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.configurationDomainService = configurationDomainService;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanScheduleFactory = loanScheduleFactory;
        this.taskExecutor = taskExecutor;
        this.transactionTemplate = transactionTemplate;
        this.loanChargeService = loanChargeService;
        this.loanBalanceService = loanBalanceService;
        this.loanChargePaidByRepository = loanChargePaidByRepository;
        this.journalEntryPoster = journalEntryPoster;
    }
}

