/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.domain;

import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.BatchRequestContextHolder;
import org.apache.fineract.infrastructure.core.domain.FineractRequestContextHolder;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionProcessingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoanAccountDomainServiceJpaHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanAccountDomainServiceJpaHelper.class);
    private final LoanAssembler loanAssembler;
    private final LoanTransactionProcessingService loanTransactionProcessingService;

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public LocalDate calculateRecalculateTillDate(Loan loan, LocalDate transactionDate, ScheduleGeneratorDTO scheduleGeneratorDTOForPrepay, Money repaymentAmount) {
        LocalDate recalculateTill = null;
        try {
            Money outstanding;
            if (FineractRequestContextHolder.isBatchRequest() && BatchRequestContextHolder.isEnclosingTransaction()) {
                return null;
            }
            if ((loan = this.loanAssembler.assembleFrom((Long)loan.getId())).isInterestBearingAndInterestRecalculationEnabled() && loan.getLoanProduct().getProductInterestRecalculationDetails().getPreCloseInterestCalculationStrategy().calculateTillPreClosureDateEnabled() && repaymentAmount.isGreaterThanOrEqualTo(outstanding = this.loanTransactionProcessingService.fetchPrepaymentDetail(scheduleGeneratorDTOForPrepay, transactionDate, loan).getTotalOutstanding())) {
                recalculateTill = transactionDate;
            }
        }
        catch (Exception e) {
            log.warn("Unable to calculate prepayment amount", (Throwable)e);
        }
        return recalculateTill;
    }

    @Generated
    public LoanAccountDomainServiceJpaHelper(LoanAssembler loanAssembler, LoanTransactionProcessingService loanTransactionProcessingService) {
        this.loanAssembler = loanAssembler;
        this.loanTransactionProcessingService = loanTransactionProcessingService;
    }
}

