/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.portfolio.client.data.ClientTransactionData;
import org.apache.fineract.portfolio.client.domain.ClientTransaction;
import org.apache.fineract.portfolio.client.domain.ClientTransactionRepository;
import org.apache.fineract.portfolio.client.exception.ClientTransactionNotFoundException;
import org.apache.fineract.portfolio.client.service.ClientTransactionReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientTransactionReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ClientTransactionReadPlatformServiceImpl
implements ClientTransactionReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ClientTransactionMapper clientTransactionMapper = new ClientTransactionMapper();
    private final PaginationHelper paginationHelper;
    private final ClientTransactionRepository clientTransactionRepository;

    public Page<ClientTransactionData> retrieveAllTransactions(Long clientId, SearchParameters searchParameters) {
        Object[] parameters = new Object[1];
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ").append(this.clientTransactionMapper.schema()).append(" where c.id = ? ");
        parameters[0] = clientId;
        sqlBuilder.append(" order by tr.transaction_date DESC, tr.submitted_on_date DESC, tr.id DESC ");
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), parameters, (RowMapper)this.clientTransactionMapper);
    }

    public Collection<ClientTransactionData> retrieveAllTransactions(Long clientId, Long chargeId) {
        Object[] parameters = new Object[1];
        String sql = "select " + this.clientTransactionMapper.schema() + " where c.id = ? ";
        if (chargeId != null) {
            parameters = new Object[2];
            parameters[1] = chargeId;
            sql = sql + " and ccpb.client_charge_id = ?";
        }
        parameters[0] = clientId;
        sql = sql + " order by tr.transaction_date DESC, tr.submitted_on_date DESC, tr.id DESC";
        return this.jdbcTemplate.query(sql, (RowMapper)this.clientTransactionMapper, parameters);
    }

    public ClientTransactionData retrieveTransaction(Long clientId, Long transactionId) {
        try {
            String sql = "select " + this.clientTransactionMapper.schema() + " where c.id = ? and tr.id= ?";
            return (ClientTransactionData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.clientTransactionMapper, new Object[]{clientId, transactionId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new ClientTransactionNotFoundException(clientId, transactionId, e);
        }
    }

    public ClientTransaction retrieveTransactionByExternalId(ExternalId transactionExternalId) {
        return this.clientTransactionRepository.findByExternalId(transactionExternalId);
    }

    @Generated
    public ClientTransactionReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper, ClientTransactionRepository clientTransactionRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.paginationHelper = paginationHelper;
        this.clientTransactionRepository = clientTransactionRepository;
    }
}

