/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.PortfolioAccountDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.exception.AccountTransferNotFoundException;
import org.apache.fineract.portfolio.account.service.PortfolioAccountReadPlatformService;
import org.apache.fineract.portfolio.account.service.PortfolioAccountReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PortfolioAccountReadPlatformServiceImpl
implements PortfolioAccountReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PortfolioSavingsAccountMapper savingsAccountMapper;
    private final PortfolioLoanAccountMapper loanAccountMapper;
    private final PortfolioLoanAccountRefundByTransferMapper accountRefundByTransferMapper;

    public PortfolioAccountReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.jdbcTemplate = jdbcTemplate;
        this.savingsAccountMapper = new PortfolioSavingsAccountMapper();
        this.loanAccountMapper = new PortfolioLoanAccountMapper();
        this.accountRefundByTransferMapper = new PortfolioLoanAccountRefundByTransferMapper(sqlGenerator);
    }

    public PortfolioAccountData retrieveOne(Long accountId, Integer accountTypeId) {
        return this.retrieveOne(accountId, accountTypeId, null);
    }

    public PortfolioAccountData retrieveOne(Long accountId, Integer accountTypeId, String currencyCode) {
        Object[] sqlParams = new Object[]{accountId};
        PortfolioAccountData accountData = null;
        try {
            String sql = null;
            PortfolioAccountType accountType = PortfolioAccountType.fromInt((Integer)accountTypeId);
            switch (1.$SwitchMap$org$apache$fineract$portfolio$account$PortfolioAccountType[accountType.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    sql = "select " + this.loanAccountMapper.schema() + " where la.id = ?";
                    if (currencyCode != null) {
                        sql = sql + " and la.currency_code = ?";
                        sqlParams = new Object[]{accountId, currencyCode};
                    }
                    accountData = (PortfolioAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.loanAccountMapper, sqlParams);
                    break;
                }
                case 3: {
                    sql = "select " + this.savingsAccountMapper.schema() + " where sa.id = ?";
                    if (currencyCode != null) {
                        sql = sql + " and sa.currency_code = ?";
                        sqlParams = new Object[]{accountId, currencyCode};
                    }
                    accountData = (PortfolioAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.savingsAccountMapper, sqlParams);
                }
            }
        }
        catch (EmptyResultDataAccessException e) {
            throw new AccountTransferNotFoundException(accountId, e);
        }
        return accountData;
    }

    public Collection<PortfolioAccountData> retrieveAllForLookup(PortfolioAccountDTO portfolioAccountDTO) {
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        List accounts = null;
        String sql = null;
        long defaultAccountStatus = 300L;
        if (portfolioAccountDTO.getAccountStatus() != null) {
            defaultAccountStatus = portfolioAccountDTO.getFirstAccountStatus();
        }
        PortfolioAccountType accountType = PortfolioAccountType.fromInt((Integer)portfolioAccountDTO.getAccountTypeId());
        switch (1.$SwitchMap$org$apache$fineract$portfolio$account$PortfolioAccountType[accountType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                sql = "select " + this.loanAccountMapper.schema() + " where ";
                if (portfolioAccountDTO.getClientId() != null) {
                    sql = sql + " la.client_id = ? and la.loan_status_id in (?) ";
                    sqlParams.add(portfolioAccountDTO.getClientId());
                    sqlParams.add(defaultAccountStatus);
                } else {
                    sql = sql + " la.loan_status_id in (?) ";
                    sqlParams.add(defaultAccountStatus);
                }
                if (portfolioAccountDTO.getCurrencyCode() != null) {
                    sql = sql + " and la.currency_code = ?";
                    sqlParams.add(portfolioAccountDTO.getCurrencyCode());
                }
                accounts = this.jdbcTemplate.query(sql, (RowMapper)this.loanAccountMapper, sqlParams.toArray());
                break;
            }
            case 3: {
                sql = "select " + this.savingsAccountMapper.schema() + " where ";
                if (portfolioAccountDTO.getClientId() != null) {
                    sql = sql + " sa.client_id = ? and sa.status_enum in (?) ";
                    sqlParams.add(portfolioAccountDTO.getClientId());
                    sqlParams.add(defaultAccountStatus);
                } else {
                    sql = sql + " sa.status_enum in (?) ";
                    sqlParams.add(defaultAccountStatus);
                }
                if (portfolioAccountDTO.getCurrencyCode() != null) {
                    sql = sql + " and sa.currency_code = ?";
                    sqlParams.add(portfolioAccountDTO.getCurrencyCode());
                }
                if (portfolioAccountDTO.getDepositType() != null) {
                    sql = sql + " and sa.deposit_type_enum = ?";
                    sqlParams.add(portfolioAccountDTO.getDepositType().shortValue());
                }
                if (portfolioAccountDTO.isExcludeOverDraftAccounts()) {
                    sql = sql + " and sa.allow_overdraft = false";
                }
                if (portfolioAccountDTO.getClientId() == null && portfolioAccountDTO.getGroupId() != null) {
                    sql = sql + " and sa.group_id = ? ";
                    sqlParams.add(portfolioAccountDTO.getGroupId());
                }
                accounts = this.jdbcTemplate.query(sql, (RowMapper)this.savingsAccountMapper, sqlParams.toArray());
            }
        }
        return accounts;
    }

    public PortfolioAccountData retrieveOneByPaidInAdvance(Long accountId, Integer accountTypeId) {
        Object[] sqlParams = new Object[]{accountId, accountId};
        PortfolioAccountData accountData = null;
        try {
            String sql = null;
            sql = "select " + this.accountRefundByTransferMapper.schema() + " where la.id = ?";
            accountData = (PortfolioAccountData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.accountRefundByTransferMapper, sqlParams);
        }
        catch (EmptyResultDataAccessException e) {
            throw new AccountTransferNotFoundException(accountId, e);
        }
        return accountData;
    }
}

