/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.helper;

import com.google.common.base.Splitter;
import java.net.InetAddress;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class IPv4Helper {
    private static final Logger LOG = LoggerFactory.getLogger(IPv4Helper.class);

    private IPv4Helper() {
    }

    public static long ipAddressToLong(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            throw new IllegalArgumentException("ip address cannot be null or empty");
        }
        List octets = Splitter.onPattern((String)Pattern.quote(".")).splitToList((CharSequence)ipAddress);
        if (octets.size() != 4) {
            throw new IllegalArgumentException("invalid ip address");
        }
        long ip = 0L;
        for (int i = 3; i >= 0; --i) {
            long octet = Long.parseLong((String)octets.get(3 - i));
            if (octet > 255L || octet < 0L) {
                throw new IllegalArgumentException("invalid ip address");
            }
            ip |= octet << i * 8;
        }
        return ip;
    }

    public static String longToIpAddress(long ip) {
        if (ip > 0xFFFFFFFFL || ip < 0L) {
            throw new IllegalArgumentException("invalid ip");
        }
        StringBuilder ipAddress = new StringBuilder();
        for (int i = 3; i >= 0; --i) {
            int shift = i * 8;
            ipAddress.append((ip & (long)(255 << shift)) >> shift);
            if (i <= 0) continue;
            ipAddress.append(".");
        }
        return ipAddress.toString();
    }

    public static boolean ipAddressIsInRange(String ipAddress, String startOfRange, String endOfRange) {
        long ipAddressToLong = IPv4Helper.ipAddressToLong((String)ipAddress);
        long startOfRangeToLong = IPv4Helper.ipAddressToLong((String)startOfRange);
        long endOfRangeToLong = IPv4Helper.ipAddressToLong((String)endOfRange);
        long diff = ipAddressToLong - startOfRangeToLong;
        return diff >= 0L && diff <= endOfRangeToLong - startOfRangeToLong;
    }

    public static boolean applicationIsRunningOnLocalMachine() {
        boolean isRunningOnLocalMachine = false;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost != null) {
                String hostAddress = localHost.getHostAddress();
                String startOfIpAddressRange = "127.0.0.0";
                String endOfIpAddressRange = "127.255.255.255";
                if (StringUtils.isNotEmpty((CharSequence)hostAddress)) {
                    isRunningOnLocalMachine = IPv4Helper.ipAddressIsInRange((String)hostAddress, (String)"127.0.0.0", (String)"127.255.255.255");
                }
            }
        }
        catch (Exception exception) {
            LOG.error("Problem occurred in applicationIsRunningOnLocalMachine function", (Throwable)exception);
        }
        return isRunningOnLocalMachine;
    }

    public static boolean applicationIsNotRunningOnLocalMachine() {
        return !IPv4Helper.applicationIsRunningOnLocalMachine();
    }
}

