/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.hooks.domain.Hook;
import org.apache.fineract.infrastructure.hooks.domain.HookConfiguration;
import org.apache.fineract.infrastructure.hooks.domain.HookRepository;
import org.apache.fineract.infrastructure.hooks.domain.HookResource;
import org.apache.fineract.infrastructure.hooks.domain.HookTemplate;
import org.apache.fineract.infrastructure.hooks.domain.HookTemplateRepository;
import org.apache.fineract.infrastructure.hooks.domain.Schema;
import org.apache.fineract.infrastructure.hooks.exception.HookNotFoundException;
import org.apache.fineract.infrastructure.hooks.exception.HookTemplateNotFoundException;
import org.apache.fineract.infrastructure.hooks.processor.ProcessorHelper;
import org.apache.fineract.infrastructure.hooks.processor.WebHookService;
import org.apache.fineract.infrastructure.hooks.serialization.HookCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.hooks.service.HookWritePlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.template.domain.Template;
import org.apache.fineract.template.domain.TemplateRepository;
import org.apache.fineract.template.exception.TemplateNotFoundException;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HookWritePlatformServiceJpaRepositoryImpl
implements HookWritePlatformService {
    private final PlatformSecurityContext context;
    private final HookRepository hookRepository;
    private final HookTemplateRepository hookTemplateRepository;
    private final TemplateRepository ugdTemplateRepository;
    private final HookCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final FromJsonHelper fromApiJsonHelper;
    private final ProcessorHelper processorHelper;

    @Transactional
    @CacheEvict(value={"hooks"}, allEntries=true)
    public CommandProcessingResult createHook(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            HookTemplate template = this.retrieveHookTemplateBy(command.stringValueOfParameterNamed("name"));
            String configJson = command.jsonFragment("config");
            Set config = this.assembleConfig(command.mapValueOfParameterNamed(configJson), template);
            JsonArray events = command.arrayOfParameterNamed("events");
            Set allEvents = this.assembleSetOfEvents(events);
            Template ugdTemplate = null;
            if (command.hasParameter("templateId")) {
                Long ugdTemplateId = command.longValueOfParameterNamed("templateId");
                ugdTemplate = (Template)this.ugdTemplateRepository.findById((Object)ugdTemplateId).orElseThrow(() -> new TemplateNotFoundException(ugdTemplateId));
            }
            Hook hook = Hook.fromJson((JsonCommand)command, (HookTemplate)template, (Set)config, (Set)allEvents, ugdTemplate);
            this.validateHookRules(template, config, allEvents);
            this.hookRepository.saveAndFlush((Object)hook);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)hook.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleHookDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleHookDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @CacheEvict(value={"hooks"}, allEntries=true)
    public CommandProcessingResult updateHook(Long hookId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            Hook hook = this.retrieveHookBy(hookId);
            HookTemplate template = hook.getTemplate();
            Map changes = hook.update(command);
            if (!changes.isEmpty()) {
                String configJson;
                Set config;
                boolean updated;
                Set events;
                boolean updated2;
                if (changes.containsKey("templateId")) {
                    Long ugdTemplateId = command.longValueOfParameterNamed("templateId");
                    Template ugdTemplate = this.ugdTemplateRepository.findById((Object)ugdTemplateId).orElse(null);
                    if (ugdTemplate == null) {
                        changes.remove("templateId");
                        throw new TemplateNotFoundException(ugdTemplateId);
                    }
                    hook.setUgdTemplate(ugdTemplate);
                }
                if (changes.containsKey("events") && !(updated2 = hook.updateEvents(events = this.assembleSetOfEvents(command.arrayOfParameterNamed("events"))))) {
                    changes.remove("events");
                }
                if (changes.containsKey("config") && !(updated = hook.updateConfig(config = this.assembleConfig(command.mapValueOfParameterNamed(configJson = command.jsonFragment("config")), template)))) {
                    changes.remove("config");
                }
                this.hookRepository.saveAndFlush((Object)hook);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(hookId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleHookDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleHookDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    @CacheEvict(value={"hooks"}, allEntries=true)
    public CommandProcessingResult deleteHook(Long hookId) {
        this.context.authenticatedUser();
        Hook hook = this.retrieveHookBy(hookId);
        try {
            this.hookRepository.delete((Object)hook);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            throw new PlatformDataIntegrityException("error.msg.unknown.data.integrity.issue", "Unknown data integrity issue with resource: " + String.valueOf(e.getMostSpecificCause()), new Object[]{e});
        }
        return new CommandProcessingResultBuilder().withEntityId(hookId).build();
    }

    private Hook retrieveHookBy(Long hookId) {
        return (Hook)this.hookRepository.findById((Object)hookId).orElseThrow(() -> new HookNotFoundException(hookId));
    }

    private HookTemplate retrieveHookTemplateBy(String templateName) {
        HookTemplate template = this.hookTemplateRepository.findOne(templateName);
        if (template == null) {
            throw new HookTemplateNotFoundException(templateName);
        }
        return template;
    }

    private Set<HookConfiguration> assembleConfig(Map<String, String> hookConfig, HookTemplate template) {
        HashSet<HookConfiguration> configuration = new HashSet<HookConfiguration>();
        Set fields = template.getFields();
        block0: for (Map.Entry<String, String> configEntry : hookConfig.entrySet()) {
            for (Schema field : fields) {
                String fieldName = field.getFieldName();
                if (!fieldName.equalsIgnoreCase(configEntry.getKey())) continue;
                HookConfiguration config = HookConfiguration.createNewWithoutHook((String)field.getFieldType(), (String)configEntry.getKey(), (String)configEntry.getValue());
                configuration.add(config);
                continue block0;
            }
        }
        return configuration;
    }

    private Set<HookResource> assembleSetOfEvents(JsonArray eventsArray) {
        HashSet<HookResource> allEvents = new HashSet<HookResource>();
        for (int i = 0; i < eventsArray.size(); ++i) {
            JsonObject eventElement = eventsArray.get(i).getAsJsonObject();
            String entityName = this.fromApiJsonHelper.extractStringNamed("entityName", (JsonElement)eventElement);
            String actionName = this.fromApiJsonHelper.extractStringNamed("actionName", (JsonElement)eventElement);
            HookResource event = HookResource.createNewWithoutHook((String)entityName, (String)actionName);
            allEvents.add(event);
        }
        return allEvents;
    }

    private void validateHookRules(HookTemplate template, Set<HookConfiguration> config, Set<HookResource> events) {
        Object errorMessage;
        Object errorMessage2;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("hook");
        if (!template.getName().equalsIgnoreCase("Web") && this.hookRepository.findOneByTemplateId((Long)template.getId()) != null) {
            errorMessage2 = "multiple.non.web.template.hooks.not.supported";
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("multiple.non.web.template.hooks.not.supported", new Object[0]);
        }
        for (HookConfiguration conf : config) {
            String fieldValue = conf.getFieldValue();
            if (conf.getFieldName().equals("Content Type") && !fieldValue.equalsIgnoreCase("json") && !fieldValue.equalsIgnoreCase("form")) {
                String errorMessage3 = "content.type.must.be.json.or.form";
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("content.type.must.be.json.or.form", new Object[0]);
            }
            if (!conf.getFieldName().equals("Payload URL")) continue;
            try {
                WebHookService service = this.processorHelper.createWebHookService(fieldValue);
                service.sendEmptyRequest().execute();
            }
            catch (IOException re) {
                errorMessage = "url.invalid";
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode((String)errorMessage, new Object[0]);
            }
        }
        if (events == null || events.isEmpty()) {
            errorMessage2 = "registered.events.cannot.be.empty";
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("registered.events.cannot.be.empty", new Object[0]);
        }
        Set fields = template.getFields();
        for (Schema field : fields) {
            if (field.isOptional()) continue;
            boolean found = false;
            for (HookConfiguration conf : config) {
                if (!field.getFieldName().equals(conf.getFieldName())) continue;
                found = true;
            }
            if (found) continue;
            errorMessage = "required.config.field.not.provided";
            baseDataValidator.reset().value((Object)field.getFieldName()).failWithCodeNoParameterAddedToErrorCode("required.config.field.not.provided", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void handleHookDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("hook_name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.hook.duplicate.name", "A hook with name '" + name + "' already exists", "name", new Object[]{name});
        }
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public HookWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, HookRepository hookRepository, HookTemplateRepository hookTemplateRepository, TemplateRepository ugdTemplateRepository, HookCommandFromApiJsonDeserializer fromApiJsonDeserializer, FromJsonHelper fromApiJsonHelper, ProcessorHelper processorHelper) {
        this.context = context;
        this.hookRepository = hookRepository;
        this.hookTemplateRepository = hookTemplateRepository;
        this.ugdTemplateRepository = ugdTemplateRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.processorHelper = processorHelper;
    }
}

