/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.support;

import java.util.StringJoiner;
import lombok.Generated;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingService;

public class SamplingMethodInterceptor
implements MethodInterceptor {
    private final SamplingService samplingService;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object aThis = invocation.getThis();
        if (aThis != null) {
            String samplingKey = invocation.getMethod().getName() + this.getFormattedArguments(invocation);
            return this.samplingService.sample(samplingKey, () -> {
                try {
                    return invocation.proceed();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return invocation.proceed();
    }

    private String getFormattedArguments(MethodInvocation invocation) {
        Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
        if (parameterTypes.length == 0) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Class<?> parameterType : parameterTypes) {
            stringJoiner.add(parameterType.getSimpleName());
        }
        return "(" + String.valueOf(stringJoiner) + ")";
    }

    @Generated
    public SamplingMethodInterceptor(SamplingService samplingService) {
        this.samplingService = samplingService;
    }
}

