/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.service;

import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationProperty;
import org.apache.fineract.infrastructure.configuration.exception.GlobalConfigurationPropertyCannotBeModfied;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.security.exception.ForcePasswordResetException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class GlobalConfigurationPropertyUpdateService {
    private final JdbcTemplate jdbcTemplate;

    public Map<String, Object> update(GlobalConfigurationProperty property, JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(7);
        if (property.isTrapDoor() && this.isAnyProductAlreadyCreated()) {
            throw new GlobalConfigurationPropertyCannotBeModfied((Long)property.getId());
        }
        String enabledParamName = "enabled";
        if (command.isChangeInBooleanParameterNamed("enabled", Boolean.valueOf(property.isEnabled()))) {
            boolean newValue = command.booleanPrimitiveValueOfParameterNamed("enabled");
            actualChanges.put("enabled", newValue);
            property.setEnabled(newValue);
        }
        String valueParamName = "value";
        Long previousValue = property.getValue();
        if (command.isChangeInLongParameterNamed("value", property.getValue())) {
            Long newValue = command.longValueOfParameterNamed("value");
            actualChanges.put("value", newValue);
            property.setValue(newValue);
        }
        String dateValueParamName = "dateValue";
        if (command.isChangeInDateParameterNamed("dateValue", property.getDateValue())) {
            LocalDate newDateValue = command.localDateValueOfParameterNamed("dateValue");
            actualChanges.put("dateValue", newDateValue);
            property.setDateValue(newDateValue);
        }
        String stringValueParamName = "stringValue";
        if (command.isChangeInStringParameterNamed("stringValue", property.getStringValue())) {
            String newStringValue = command.stringValueOfParameterNamed("stringValue");
            actualChanges.put("stringValue", newStringValue);
            property.setStringValue(newStringValue);
        }
        String passwordPropertyName = "force-password-reset-days";
        if (property.getName().equalsIgnoreCase("force-password-reset-days") && (property.isEnabled() && command.hasParameter("value") && property.getValue() == 0L || property.isEnabled() && !command.hasParameter("value") && previousValue == 0L)) {
            throw new ForcePasswordResetException();
        }
        return actualChanges;
    }

    private boolean isAnyProductAlreadyCreated() {
        String productExistenceSql = "SELECT EXISTS (SELECT 1 FROM m_loan) OR EXISTS (SELECT 1 FROM m_savings_account) OR EXISTS (SELECT 1 FROM m_share_account) AS products_exist";
        Boolean productsExist = (Boolean)this.jdbcTemplate.queryForObject(productExistenceSql, Boolean.class);
        return BooleanUtils.isTrue((Boolean)productsExist);
    }

    @Generated
    public GlobalConfigurationPropertyUpdateService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

