/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.sms.data.CampaignPreviewData;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.sms.exception.SmsCampaignMustBeClosedToBeDeletedException;
import org.apache.fineract.infrastructure.campaigns.sms.exception.SmsCampaignMustBeClosedToEditException;
import org.apache.fineract.infrastructure.campaigns.sms.exception.SmsCampaignNotFound;
import org.apache.fineract.infrastructure.campaigns.sms.serialization.SmsCampaignValidator;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportRepository;
import org.apache.fineract.infrastructure.dataqueries.exception.ReportNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.apache.fineract.infrastructure.sms.scheduler.SmsMessageScheduledJobService;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanTypeException;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmsCampaignWritePlatformServiceJpaImpl
implements SmsCampaignWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsCampaignWritePlatformServiceJpaImpl.class);
    private final PlatformSecurityContext context;
    private final SmsCampaignRepository smsCampaignRepository;
    private final SmsCampaignValidator smsCampaignValidator;
    private final ReportRepository reportRepository;
    private final SmsMessageRepository smsMessageRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final GroupRepository groupRepository;
    private final ReadReportingService readReportingService;
    private final GenericDataService genericDataService;
    private final FromJsonHelper fromJsonHelper;
    private final SmsMessageScheduledJobService smsMessageScheduledJobService;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.smsCampaignValidator.validateCreate(command.json());
        Long runReportId = command.longValueOfParameterNamed("runReportId");
        Report report = (Report)this.reportRepository.findById((Object)runReportId).orElseThrow(() -> new ReportNotFoundException(runReportId));
        LocalDateTime tenantDateTime = DateUtils.getLocalDateTimeOfTenant();
        SmsCampaign smsCampaign = SmsCampaign.instance((AppUser)currentUser, (Report)report, (JsonCommand)command);
        LocalDateTime recurrenceStartDate = smsCampaign.getRecurrenceStartDate();
        if (recurrenceStartDate != null && DateUtils.isBefore((LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime)) {
            throw new GeneralPlatformDomainRuleException("error.msg.campaign.recurrenceStartDate.in.the.past", "Recurrence start date cannot be the past date.", new Object[]{recurrenceStartDate});
        }
        this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)smsCampaign.getId()).build();
    }

    @Transactional
    public CommandProcessingResult update(Long resourceId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.smsCampaignValidator.validateForUpdate(command.json());
            SmsCampaign smsCampaign = (SmsCampaign)this.smsCampaignRepository.findById((Object)resourceId).orElseThrow(() -> new SmsCampaignNotFound(resourceId));
            if (smsCampaign.isActive()) {
                throw new SmsCampaignMustBeClosedToEditException((Long)smsCampaign.getId());
            }
            Map changes = smsCampaign.update(command);
            if (changes.containsKey("runReportId")) {
                Long newValue = command.longValueOfParameterNamed("runReportId");
                Report reportId = (Report)this.reportRepository.findById((Object)newValue).orElseThrow(() -> new ReportNotFoundException(newValue));
                smsCampaign.updateBusinessRuleId(reportId);
            }
            if (!changes.isEmpty()) {
                this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(resourceId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(command, throwable);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult delete(Long resourceId) {
        this.context.authenticatedUser();
        SmsCampaign smsCampaign = (SmsCampaign)this.smsCampaignRepository.findById((Object)resourceId).orElseThrow(() -> new SmsCampaignNotFound(resourceId));
        if (smsCampaign.isActive()) {
            throw new SmsCampaignMustBeClosedToBeDeletedException((Long)smsCampaign.getId());
        }
        smsCampaign.delete();
        this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
        return new CommandProcessingResultBuilder().withEntityId((Long)smsCampaign.getId()).build();
    }

    public void insertDirectCampaignIntoSmsOutboundTable(SmsCampaign smsCampaign) {
        try {
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List runReportObject = this.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
            if (runReportObject != null) {
                for (HashMap entry : runReportObject) {
                    String textMessage = this.compileSmsTemplate(smsCampaign.getMessage(), smsCampaign.getCampaignName(), (Map)entry);
                    Integer clientId = (Integer)entry.get("id");
                    Object mobileNo = entry.get("mobileNo");
                    Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(Long.valueOf(clientId.longValue()));
                    if (!this.smsCampaignValidator.isValidNotificationOrSms(client, smsCampaign, mobileNo)) continue;
                    String mobileNumber = null;
                    if (mobileNo != null) {
                        mobileNumber = mobileNo.toString();
                    }
                    SmsMessage smsMessage = SmsMessage.pendingSms(null, null, (Client)client, null, (String)textMessage, (String)mobileNumber, (SmsCampaign)smsCampaign, (boolean)smsCampaign.isNotification());
                    this.smsMessageRepository.save((Object)smsMessage);
                }
            }
        }
        catch (IOException e) {
            log.error("Error occurred.", (Throwable)e);
        }
    }

    public void insertDirectCampaignIntoSmsOutboundTable(Loan loan, SmsCampaign smsCampaign) {
        try {
            if (loan.hasInvalidLoanType()) {
                throw new InvalidLoanTypeException("Loan Type cannot be 0 for the Triggered Sms Campaign", new Object[0]);
            }
            HashSet<Client> clientSet = new HashSet<Client>();
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            campaignParams.put("loanId", ((Long)loan.getId()).toString());
            HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            queryParamForRunReport.put("loanId", ((Long)loan.getId()).toString());
            if (loan.isGroupLoan()) {
                Group group = this.groupRepository.findById((Object)loan.getGroupId()).orElse(null);
                clientSet.addAll(group.getClientMembers());
                queryParamForRunReport.put("groupId", ((Long)group.getId()).toString());
            } else {
                Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(loan.getClientId());
                clientSet.add(client);
            }
            for (Client client : clientSet) {
                campaignParams.put("clientId", ((Long)client.getId()).toString());
                queryParamForRunReport.put("clientId", ((Long)client.getId()).toString());
                List runReportObject = this.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
                if (runReportObject == null || runReportObject.size() <= 0) continue;
                for (HashMap entry : runReportObject) {
                    String textMessage = this.compileSmsTemplate(smsCampaign.getMessage(), smsCampaign.getCampaignName(), (Map)entry);
                    Object mobileNo = entry.get("mobileNo");
                    if (!this.smsCampaignValidator.isValidNotificationOrSms(client, smsCampaign, mobileNo)) continue;
                    String mobileNumber = null;
                    if (mobileNo != null) {
                        mobileNumber = mobileNo.toString();
                    }
                    SmsMessage smsMessage = SmsMessage.pendingSms(null, null, (Client)client, null, (String)textMessage, (String)mobileNumber, (SmsCampaign)smsCampaign, (boolean)smsCampaign.isNotification());
                    smsMessage.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
                    this.smsMessageRepository.save((Object)smsMessage);
                    ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
                    messages.add(smsMessage);
                    HashMap<SmsCampaign, ArrayList<SmsMessage>> smsDataMap = new HashMap<SmsCampaign, ArrayList<SmsMessage>>();
                    smsDataMap.put(smsCampaign, messages);
                    this.smsMessageScheduledJobService.sendTriggeredMessages(smsDataMap);
                }
            }
        }
        catch (IOException | RuntimeException e) {
            log.error("Error occured.", (Throwable)e);
        }
    }

    public void insertDirectCampaignIntoSmsOutboundTable(Client client, SmsCampaign smsCampaign) {
        try {
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            campaignParams.put("clientId", ((Long)client.getId()).toString());
            HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            campaignParams.put("clientId", ((Long)client.getId()).toString());
            queryParamForRunReport.put("clientId", ((Long)client.getId()).toString());
            List runReportObject = this.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
            if (runReportObject != null && runReportObject.size() > 0) {
                for (HashMap entry : runReportObject) {
                    String textMessage = this.compileSmsTemplate(smsCampaign.getMessage(), smsCampaign.getCampaignName(), (Map)entry);
                    Object mobileNo = entry.get("mobileNo");
                    if (!this.smsCampaignValidator.isValidNotificationOrSms(client, smsCampaign, mobileNo)) continue;
                    String mobileNumber = null;
                    if (mobileNo != null) {
                        mobileNumber = mobileNo.toString();
                    }
                    SmsMessage smsMessage = SmsMessage.pendingSms(null, null, (Client)client, null, (String)textMessage, (String)mobileNumber, (SmsCampaign)smsCampaign, (boolean)smsCampaign.isNotification());
                    smsMessage.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
                    this.smsMessageRepository.save((Object)smsMessage);
                    ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
                    messages.add(smsMessage);
                    HashMap<SmsCampaign, ArrayList<SmsMessage>> smsDataMap = new HashMap<SmsCampaign, ArrayList<SmsMessage>>();
                    smsDataMap.put(smsCampaign, messages);
                    this.smsMessageScheduledJobService.sendTriggeredMessages(smsDataMap);
                }
            }
        }
        catch (IOException | RuntimeException e) {
            log.error("Error occured.", (Throwable)e);
        }
    }

    public void insertDirectCampaignIntoSmsOutboundTable(SavingsAccount savingsAccount, SmsCampaign smsCampaign) {
        try {
            HashMap campaignParams = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            campaignParams.put("savingsId", ((Long)savingsAccount.getId()).toString());
            HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            queryParamForRunReport.put("savingsId", ((Long)savingsAccount.getId()).toString());
            Client client = savingsAccount.getClient();
            List runReportObject = this.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
            if (runReportObject != null && runReportObject.size() > 0) {
                for (HashMap entry : runReportObject) {
                    String textMessage = this.compileSmsTemplate(smsCampaign.getMessage(), smsCampaign.getCampaignName(), (Map)entry);
                    Object mobileNo = entry.get("mobileNo");
                    if (!this.smsCampaignValidator.isValidNotificationOrSms(client, smsCampaign, mobileNo)) continue;
                    String mobileNumber = null;
                    if (mobileNo != null) {
                        mobileNumber = mobileNo.toString();
                    }
                    SmsMessage smsMessage = SmsMessage.pendingSms(null, null, (Client)client, null, (String)textMessage, (String)mobileNumber, (SmsCampaign)smsCampaign, (boolean)smsCampaign.isNotification());
                    smsMessage.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
                    this.smsMessageRepository.save((Object)smsMessage);
                    ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
                    messages.add(smsMessage);
                    HashMap<SmsCampaign, ArrayList<SmsMessage>> smsDataMap = new HashMap<SmsCampaign, ArrayList<SmsMessage>>();
                    smsDataMap.put(smsCampaign, messages);
                    this.smsMessageScheduledJobService.sendTriggeredMessages(smsDataMap);
                }
            }
        }
        catch (IOException | RuntimeException e) {
            log.error("Error occured.", (Throwable)e);
        }
    }

    @Transactional
    public CommandProcessingResult activateSmsCampaign(Long campaignId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.smsCampaignValidator.validateActivation(command.json());
        SmsCampaign smsCampaign = (SmsCampaign)this.smsCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new SmsCampaignNotFound(campaignId));
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate activationDate = command.localDateValueOfParameterNamed("activationDate");
        smsCampaign.activate(currentUser, fmt, activationDate);
        this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
        if (smsCampaign.isDirect()) {
            this.insertDirectCampaignIntoSmsOutboundTable(smsCampaign);
        } else if (smsCampaign.isSchedule()) {
            LocalDateTime nextTriggerDate = null;
            LocalDateTime tenantDateTime = DateUtils.getLocalDateTimeOfTenant();
            LocalDateTime recurrenceStartDate = smsCampaign.getRecurrenceStartDate();
            nextTriggerDate = DateUtils.isBefore((LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime) ? CalendarUtils.getNextRecurringDate((String)smsCampaign.getRecurrence(), (LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime) : recurrenceStartDate;
            smsCampaign.setNextTriggerDate(nextTriggerDate);
            this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)smsCampaign.getId()).build();
    }

    @Transactional
    public CommandProcessingResult closeSmsCampaign(Long campaignId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.smsCampaignValidator.validateClosedDate(command.json());
        SmsCampaign smsCampaign = (SmsCampaign)this.smsCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new SmsCampaignNotFound(campaignId));
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate closureDate = command.localDateValueOfParameterNamed("closureDate");
        smsCampaign.close(currentUser, fmt, closureDate);
        this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)smsCampaign.getId()).build();
    }

    public String compileSmsTemplate(String textMessageTemplate, String campaignName, Map<String, Object> smsParams) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader(textMessageTemplate), campaignName);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, smsParams);
        return stringWriter.toString();
    }

    private List<HashMap<String, Object>> getRunReportByServiceImpl(String reportName, Map<String, String> queryParams) throws IOException {
        String reportType = "report";
        List<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        GenericResultsetData results = this.readReportingService.retrieveGenericResultSetForSmsEmailCampaign(reportName, "report", queryParams);
        try {
            String response = this.genericDataService.generateJsonFromGenericResultsetData(results);
            resultList = (List)new ObjectMapper().readValue(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonParseException e) {
            log.warn("Conversion of report query results to JSON failed", (Throwable)e);
            return resultList;
        }
        for (HashMap<String, Object> entry : resultList) {
            for (Map.Entry<String, Object> map : entry.entrySet()) {
                String key = map.getKey();
                Object ob = map.getValue();
                if (!(ob instanceof ArrayList) || ((ArrayList)ob).size() != 3) continue;
                String changeArrayDateToStringDate = ((ArrayList)ob).get(2).toString() + "-" + ((ArrayList)ob).get(1).toString() + "-" + ((ArrayList)ob).get(0).toString();
                entry.put(key, changeArrayDateToStringDate);
            }
        }
        return resultList;
    }

    public CampaignPreviewData previewMessage(JsonQuery query) {
        CampaignPreviewData campaignMessage;
        block4: {
            campaignMessage = null;
            this.context.authenticatedUser();
            this.smsCampaignValidator.validatePreviewMessage(query.json());
            JsonObject smsParamsElement = this.fromJsonHelper.extractJsonObjectNamed("paramValue", query.parsedJson());
            String smsParams = smsParamsElement.toString();
            String textMessageTemplate = this.fromJsonHelper.extractStringNamed("message", query.parsedJson());
            try {
                HashMap campaignParams = (HashMap)new ObjectMapper().readValue(smsParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                HashMap queryParamForRunReport = (HashMap)new ObjectMapper().readValue(smsParams, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                List runReportObject = this.getRunReportByServiceImpl((String)campaignParams.get("reportName"), (Map)queryParamForRunReport);
                if (runReportObject != null && !runReportObject.isEmpty()) {
                    for (HashMap entry : runReportObject) {
                        String textMessage = this.compileSmsTemplate(textMessageTemplate, "SmsCampaign", (Map)entry);
                        if (textMessage.isEmpty()) continue;
                        Integer totalMessage = runReportObject.size();
                        campaignMessage = new CampaignPreviewData(textMessage, totalMessage);
                        break block4;
                    }
                    break block4;
                }
                campaignMessage = new CampaignPreviewData(textMessageTemplate, Integer.valueOf(0));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return campaignMessage;
    }

    @Transactional
    public CommandProcessingResult reactivateSmsCampaign(Long campaignId, JsonCommand command) {
        this.smsCampaignValidator.validateActivation(command.json());
        AppUser currentUser = this.context.authenticatedUser();
        SmsCampaign smsCampaign = (SmsCampaign)this.smsCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new SmsCampaignNotFound(campaignId));
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate reactivationDate = command.localDateValueOfParameterNamed("activationDate");
        smsCampaign.reactivate(currentUser, fmt, reactivationDate);
        if (smsCampaign.isDirect()) {
            this.insertDirectCampaignIntoSmsOutboundTable(smsCampaign);
        } else if (smsCampaign.isSchedule()) {
            LocalDateTime nextTriggerDate = null;
            LocalDateTime tenantDateTime = DateUtils.getLocalDateTimeOfTenant();
            LocalDateTime recurrenceStartDate = smsCampaign.getRecurrenceStartDate();
            nextTriggerDate = DateUtils.isBefore((LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime) ? CalendarUtils.getNextRecurringDate((String)smsCampaign.getRecurrence(), (LocalDateTime)recurrenceStartDate, (LocalDateTime)tenantDateTime) : recurrenceStartDate;
            smsCampaign.setNextTriggerDate(nextTriggerDate);
        }
        this.smsCampaignRepository.saveAndFlush((Object)smsCampaign);
        return new CommandProcessingResultBuilder().withEntityId((Long)smsCampaign.getId()).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause) {
        throw ErrorHandler.getMappable((Throwable)realCause, (String)"error.msg.sms.campaign.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public SmsCampaignWritePlatformServiceJpaImpl(PlatformSecurityContext context, SmsCampaignRepository smsCampaignRepository, SmsCampaignValidator smsCampaignValidator, ReportRepository reportRepository, SmsMessageRepository smsMessageRepository, ClientRepositoryWrapper clientRepositoryWrapper, GroupRepository groupRepository, ReadReportingService readReportingService, GenericDataService genericDataService, FromJsonHelper fromJsonHelper, SmsMessageScheduledJobService smsMessageScheduledJobService) {
        this.context = context;
        this.smsCampaignRepository = smsCampaignRepository;
        this.smsCampaignValidator = smsCampaignValidator;
        this.reportRepository = reportRepository;
        this.smsMessageRepository = smsMessageRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.groupRepository = groupRepository;
        this.readReportingService = readReportingService;
        this.genericDataService = genericDataService;
        this.fromJsonHelper = fromJsonHelper;
        this.smsMessageScheduledJobService = smsMessageScheduledJobService;
    }
}

