/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.servlet.ServletContext;
import org.apache.empire.jsf2.app.FacesConfiguration;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.impl.MojarraImplementation;
import org.apache.empire.jsf2.impl.MyFacesImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppStartupListener
implements SystemEventListener {
    private static final Logger log = LoggerFactory.getLogger(WebAppStartupListener.class);
    private final Class<? extends FacesConfiguration> facesConfigClass;
    private FacesImplementation facesImplementation;

    public WebAppStartupListener() {
        this.facesConfigClass = null;
    }

    public WebAppStartupListener(Class<? extends FacesConfiguration> facesConfigClass) {
        this.facesConfigClass = facesConfigClass;
    }

    public FacesImplementation getFacesImplementation() {
        return this.facesImplementation;
    }

    protected ServletContext getServletContext(FacesContext startupContext) {
        return (ServletContext)startupContext.getExternalContext().getContext();
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof Application;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        log.info("ApplicationStartupListener:processEvent");
        if (event instanceof PostConstructApplicationEvent) {
            FacesContext startupContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = startupContext.getExternalContext();
            this.facesImplementation = this.detectFacesImplementation(externalContext);
            this.initFacesConfiguration(startupContext);
            WebApplication facesApp = this.createWebApplication(startupContext);
            this.initWebApplication(facesApp, startupContext);
            ServletContext servletContext = (ServletContext)externalContext.getContext();
            if (servletContext.getAttribute(WebApplication.APPLICATION_BEAN_NAME) != facesApp) {
                log.warn("WARNING: Ambiguous application definition. An object of name '{}' already exists on application scope!", (Object)WebApplication.APPLICATION_BEAN_NAME);
            }
        } else if (event instanceof PreDestroyApplicationEvent) {
            log.info("Processing PreDestroyApplicationEvent");
        }
    }

    protected FacesImplementation detectFacesImplementation(ExternalContext externalContext) {
        log.debug("Detecting JSF-Implementation...");
        try {
            Class.forName("org.apache.myfaces.application.ApplicationFactoryImpl");
            return new MyFacesImplementation(externalContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.sun.faces.application.ApplicationFactoryImpl");
                return new MojarraImplementation(externalContext);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                log.error("JSF-Implementation missing or unknown. Please make sure either Apache MyFaces or Sun Mojarra implementation is provided");
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void initFacesConfiguration(FacesContext startupContext) {
        if (this.facesConfigClass != null) {
            log.info("Initializing FacesExtentions");
            FacesConfiguration.initialize(this.facesConfigClass, startupContext, this.getFacesImplementation());
        }
    }

    protected WebApplication createWebApplication(FacesContext startupContext) {
        Object app = this.getFacesImplementation().getManagedBean(WebApplication.APPLICATION_BEAN_NAME, startupContext);
        if (!(app instanceof WebApplication)) {
            throw new AbortProcessingException("Error: Application is not a " + WebApplication.class.getName() + " instance. Please create an ApplicationFactory!");
        }
        return (WebApplication)app;
    }

    protected void initWebApplication(WebApplication facesApp, FacesContext startupContext) {
        facesApp.init(this.getFacesImplementation(), startupContext);
    }
}

