/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum CommandType {
    START_PROCESS(0, "start a new workflow"),
    START_CURRENT_TASK_PROCESS(1, "start a new workflow from current nodes"),
    RECOVER_TOLERANCE_FAULT_PROCESS(2, "recover fault tolerance workflow instance"),
    RECOVER_SUSPENDED_PROCESS(3, "Recover suspended workflow instance"),
    START_FAILURE_TASK_PROCESS(4, "Recover workflow instance from failure tasks"),
    COMPLEMENT_DATA(5, "complement data"),
    SCHEDULER(6, "start a new workflow from scheduler"),
    REPEAT_RUNNING(7, "repeat running a workflow"),
    PAUSE(8, "pause a workflow"),
    STOP(9, "stop a workflow"),
    RECOVER_SERIAL_WAIT(11, "recover serial wait"),
    EXECUTE_TASK(12, "start a task node in a workflow instance"),
    DYNAMIC_GENERATION(13, "dynamic generation");

    @EnumValue
    private final int code;
    private final String descp;
    private static final Map<Integer, CommandType> COMMAND_TYPE_MAP;

    private CommandType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static CommandType of(Integer status) {
        if (COMMAND_TYPE_MAP.containsKey(status)) {
            return COMMAND_TYPE_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid status : " + status);
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getDescp() {
        return this.descp;
    }

    static {
        COMMAND_TYPE_MAP = new HashMap<Integer, CommandType>();
        for (CommandType commandType : CommandType.values()) {
            COMMAND_TYPE_MAP.put(commandType.code, commandType);
        }
    }
}

