/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.dolphinscheduler.api.audit.OperatorLog;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="TENANT_TAG")
@RestController
@RequestMapping(value={"/tenants"})
public class TenantController
extends BaseController {
    @Autowired
    private TenantService tenantService;

    @Operation(summary="createTenant", description="CREATE_TENANT_NOTES")
    @Parameters(value={@Parameter(name="tenantCode", description="TENANT_CODE", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="queueId", description="QUEUE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="description", description="TENANT_DESC", schema=@Schema(implementation=String.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_TENANT_ERROR)
    @OperatorLog(auditType=AuditType.TENANT_CREATE)
    public Result<Tenant> createTenant(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="queueId") int queueId, @RequestParam(value="description", required=false) String description) throws Exception {
        Tenant tenant = this.tenantService.createTenant(loginUser, tenantCode, queueId, description);
        return Result.success(tenant);
    }

    @Operation(summary="queryTenantListPaging", description="QUERY_TENANT_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TENANT_LIST_PAGING_ERROR)
    public Result<PageInfo<Tenant>> queryTenantListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        PageInfo<Tenant> tenantPageInfo = this.tenantService.queryTenantList(loginUser, searchVal, pageNo, pageSize);
        return Result.success(tenantPageInfo);
    }

    @Operation(summary="queryTenantList", description="QUERY_TENANT_LIST_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TENANT_LIST_ERROR)
    public Result<List<Tenant>> queryTenantList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<Tenant> tenants = this.tenantService.queryTenantList(loginUser);
        return Result.success(tenants);
    }

    @Operation(summary="updateTenant", description="UPDATE_TENANT_NOTES")
    @Parameters(value={@Parameter(name="id", description="TENANT_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="tenantCode", description="TENANT_CODE", required=true, schema=@Schema(implementation=String.class)), @Parameter(name="queueId", description="QUEUE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="description", description="TENANT_DESC", schema=@Schema(implementation=String.class))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_TENANT_ERROR)
    @OperatorLog(auditType=AuditType.TENANT_UPDATE)
    public Result<Boolean> updateTenant(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="queueId") int queueId, @RequestParam(value="description", required=false) String description) throws Exception {
        this.tenantService.updateTenant(loginUser, id, tenantCode, queueId, description);
        return Result.success(true);
    }

    @Operation(summary="deleteTenantById", description="DELETE_TENANT_NOTES")
    @Parameters(value={@Parameter(name="id", description="TENANT_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_TENANT_BY_ID_ERROR)
    @OperatorLog(auditType=AuditType.TENANT_DELETE)
    public Result<Boolean> deleteTenantById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) throws Exception {
        this.tenantService.deleteTenantById(loginUser, id);
        return Result.success(true);
    }

    @Operation(summary="verifyTenantCode", description="VERIFY_TENANT_CODE_NOTES")
    @Parameters(value={@Parameter(name="tenantCode", description="TENANT_CODE", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/verify-code"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_OS_TENANT_CODE_ERROR)
    public Result<Boolean> verifyTenantCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="tenantCode") String tenantCode) {
        this.tenantService.verifyTenantCode(tenantCode);
        return Result.success(true);
    }
}

