/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DataType {
    STRING(0, "string"),
    LIST(1, "list"),
    NUMBER(2, "number"),
    LIKE_SQL(3, "sql");

    private final int code;
    private final String description;
    private static final Map<Integer, DataType> DATA_TYPE_MAP;

    private DataType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static DataType of(Integer status) {
        if (DATA_TYPE_MAP.containsKey(status)) {
            return DATA_TYPE_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        DATA_TYPE_MAP = new HashMap<Integer, DataType>();
        for (DataType type : DataType.values()) {
            DATA_TYPE_MAP.put(type.code, type);
        }
    }
}

