/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http.clients;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.CallBack;
import com.aliyuncs.http.CompositeX509TrustManager;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.HttpUtil;
import com.aliyuncs.http.IHttpClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.X509TrustAll;
import com.aliyuncs.utils.EnvironmentUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;

public class CompatibleUrlConnClient
extends IHttpClient {
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";

    public CompatibleUrlConnClient(HttpClientConfig clientConfig) throws ClientException {
        super(clientConfig);
    }

    public static HttpResponse compatibleGetResponse(HttpRequest request) throws IOException, ClientException {
        CompatibleUrlConnClient client = new CompatibleUrlConnClient(null);
        HttpResponse response = client.syncInvoke(request);
        client.close();
        return response;
    }

    @Override
    protected void init(HttpClientConfig clientConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse syncInvoke(HttpRequest request) throws IOException, ClientException {
        InputStream content = null;
        HttpResponse response = null;
        HttpURLConnection httpConn = this.buildHttpConnection(request);
        OutputStream out = null;
        try {
            httpConn.connect();
            if (null != request.getHttpContent() && request.getHttpContent().length > 0) {
                out = httpConn.getOutputStream();
                if (request.getSysMethod().hasContent()) {
                    out.write(request.getHttpContent());
                }
                out.flush();
            }
            content = httpConn.getInputStream();
            response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (IOException e) {
            content = httpConn.getErrorStream();
            response = new HttpResponse(httpConn.getURL().toString());
            this.parseHttpConn(response, httpConn, content);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (content != null) {
                content.close();
            }
            httpConn.disconnect();
        }
    }

    @Override
    public Future<HttpResponse> asyncInvoke(HttpRequest apiRequest, CallBack callback) {
        throw new IllegalStateException("not supported");
    }

    private boolean calcIgnoreSSLCert(HttpRequest request) {
        boolean ignoreSSLCert = request.isIgnoreSSLCerts() ? request.isIgnoreSSLCerts() : this.clientConfig.isIgnoreSSLCerts();
        return ignoreSSLCert;
    }

    private CompositeX509TrustManager calcX509TrustManager(HttpRequest request) throws KeyStoreException, NoSuchAlgorithmException {
        X509TrustManager[] trustManagers = null;
        if (this.clientConfig.getX509TrustManagers() != null) {
            trustManagers = this.clientConfig.getX509TrustManagers();
        }
        if (request.getX509TrustManagers() != null) {
            trustManagers = request.getX509TrustManagers();
        }
        ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
        if (null != trustManagers) {
            trustManagerList.addAll(Arrays.asList(trustManagers));
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        trustManagerList.addAll(Arrays.asList(tmf.getTrustManagers()));
        ArrayList<X509TrustManager> finalTrustManagerList = new ArrayList<X509TrustManager>();
        for (TrustManager tm : trustManagerList) {
            if (!(tm instanceof X509TrustManager)) continue;
            finalTrustManagerList.add((X509TrustManager)tm);
        }
        CompositeX509TrustManager compositeX509TrustManager = new CompositeX509TrustManager(finalTrustManagerList);
        compositeX509TrustManager.setIgnoreSSLCert(this.calcIgnoreSSLCert(request));
        return compositeX509TrustManager;
    }

    private KeyManager[] calcKeyManager(HttpRequest request) {
        KeyManager[] keyManagers = null;
        if (this.clientConfig.getKeyManagers() != null) {
            keyManagers = this.clientConfig.getKeyManagers();
        }
        if (request.getKeyManagers() != null) {
            keyManagers = request.getKeyManagers();
        }
        return keyManagers;
    }

    private SSLSocketFactory createSSLSocketFactory(HttpRequest request) throws ClientException {
        try {
            CompositeX509TrustManager compositeX509TrustManager = this.calcX509TrustManager(request);
            KeyManager[] keyManagers = this.calcKeyManager(request);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{compositeX509TrustManager}, this.clientConfig.getSecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new ClientException("SDK.InitFailed", "Init https with SSL socket failed", e);
        }
    }

    private HostnameVerifier createHostnameVerifier(HttpRequest request) {
        boolean ignoreSSLCert;
        boolean bl = ignoreSSLCert = request.isIgnoreSSLCerts() ? request.isIgnoreSSLCerts() : this.clientConfig.isIgnoreSSLCerts();
        if (ignoreSSLCert) {
            return new NoopHostnameVerifier();
        }
        if (this.clientConfig.getHostnameVerifier() != null) {
            return this.clientConfig.getHostnameVerifier();
        }
        return new DefaultHostnameVerifier();
    }

    private void checkHttpRequest(HttpRequest request) {
        String strUrl = request.getSysUrl();
        if (null == strUrl) {
            throw new IllegalArgumentException("URL is null for HttpRequest.");
        }
        if (null == request.getSysMethod()) {
            throw new IllegalArgumentException("Method is not set for HttpRequest.");
        }
    }

    private Proxy calcProxy(URL url, HttpRequest request) throws ClientException {
        Proxy proxy;
        String targetHost = url.getHost();
        boolean needProxy = HttpUtil.needProxy(targetHost, this.clientConfig.getNoProxy(), EnvironmentUtils.getNoProxy());
        if (!needProxy) {
            return Proxy.NO_PROXY;
        }
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            String httpsProxy = EnvironmentUtils.getHttpsProxy();
            proxy = HttpUtil.getJDKProxy(this.clientConfig.getHttpsProxy(), httpsProxy, request);
        } else {
            String httpProxy = EnvironmentUtils.getHttpProxy();
            proxy = HttpUtil.getJDKProxy(this.clientConfig.getHttpProxy(), httpProxy, request);
        }
        return proxy;
    }

    private HttpURLConnection initHttpConnection(URL url, HttpRequest request) throws ClientException, IOException {
        HttpURLConnection httpConn = null;
        Proxy proxy = this.calcProxy(url, request);
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            SSLSocketFactory sslSocketFactory = this.createSSLSocketFactory(request);
            HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection(proxy);
            httpsConn.setSSLSocketFactory(sslSocketFactory);
            HostnameVerifier hostnameVerifier = this.createHostnameVerifier(request);
            httpsConn.setHostnameVerifier(hostnameVerifier);
            httpConn = httpsConn;
        }
        if (httpConn == null) {
            httpConn = (HttpURLConnection)url.openConnection(proxy);
        }
        httpConn.setRequestMethod(request.getSysMethod().toString());
        httpConn.setInstanceFollowRedirects(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        this.setConnectionTimeout(httpConn, request);
        this.setConnectionRequestProperty(httpConn, request);
        return httpConn;
    }

    private void setConnectionTimeout(HttpURLConnection httpConn, HttpRequest request) {
        if (request.getSysConnectTimeout() != null) {
            httpConn.setConnectTimeout(request.getSysConnectTimeout());
        } else {
            httpConn.setConnectTimeout((int)this.clientConfig.getConnectionTimeoutMillis());
        }
        if (request.getSysReadTimeout() != null) {
            httpConn.setReadTimeout(request.getSysReadTimeout());
        } else {
            httpConn.setReadTimeout((int)this.clientConfig.getReadTimeoutMillis());
        }
    }

    private void setConnectionRequestProperty(HttpURLConnection httpConn, HttpRequest request) {
        Map<String, String> mappedHeaders = request.getSysHeaders();
        httpConn.setRequestProperty(ACCEPT_ENCODING, "identity");
        for (Map.Entry<String, String> entry : mappedHeaders.entrySet()) {
            httpConn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (null != request.getHeaderValue(CONTENT_TYPE)) {
            httpConn.setRequestProperty(CONTENT_TYPE, request.getHeaderValue(CONTENT_TYPE));
        } else {
            String contentTypeValue = request.getContentTypeValue(request.getHttpContentType(), request.getSysEncoding());
            if (null != contentTypeValue) {
                httpConn.setRequestProperty(CONTENT_TYPE, contentTypeValue);
            }
        }
    }

    private HttpURLConnection buildHttpConnection(HttpRequest request) throws IOException, ClientException {
        this.checkHttpRequest(request);
        String strUrl = request.getSysUrl();
        URL url = null;
        String[] urlArray = null;
        if (MethodType.POST.equals((Object)request.getSysMethod()) && null == request.getHttpContent()) {
            urlArray = strUrl.split("\\?");
            url = new URL(urlArray[0]);
        } else {
            url = new URL(strUrl);
        }
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        HttpURLConnection httpConn = this.initHttpConnection(url, request);
        if (MethodType.POST.equals((Object)request.getSysMethod()) && null != urlArray && urlArray.length == 2) {
            httpConn.getOutputStream().write(urlArray[1].getBytes());
        }
        return httpConn;
    }

    private void parseHttpConn(HttpResponse response, HttpURLConnection httpConn, InputStream content) throws IOException {
        byte[] buff = this.readContent(content);
        response.setStatus(httpConn.getResponseCode());
        response.setReasonPhrase(httpConn.getResponseMessage());
        Map<String, List<String>> headers = httpConn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            List<String> values = entry.getValue();
            StringBuilder builder = new StringBuilder(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                builder.append(",");
                builder.append(values.get(i));
            }
            response.putHeaderParameter(key, builder.toString());
        }
        String type = response.getHeaderValue(CONTENT_TYPE);
        if (null != buff && null != type) {
            response.setSysEncoding("UTF-8");
            String[] split = type.split(";");
            response.setHttpContentType(FormatType.mapAcceptToFormat(split[0].trim()));
            if (split.length > 1 && split[1].contains("=")) {
                String[] codings = split[1].split("=");
                response.setSysEncoding(codings[1].trim().toUpperCase());
            }
        }
        response.setHttpContent(buff, response.getSysEncoding(), response.getHttpContentType());
    }

    private byte[] readContent(InputStream content) throws IOException {
        int read;
        if (content == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((read = content.read(buff)) != -1) {
            outputStream.write(buff, 0, read);
        }
        return outputStream.toByteArray();
    }

    @Override
    public void ignoreSSLCertificate() {
        throw new IllegalStateException("use HttpClientConfig.setIgnoreSSLCerts(true) instead");
    }

    @Override
    public void restoreSSLCertificate() {
        throw new IllegalStateException("use HttpClientConfig.setIgnoreSSLCerts(false) instead");
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public void close() {
    }

    @Deprecated
    public static final class HttpsCertIgnoreHelper {
        @Deprecated
        public static void restoreSSLCertificate() {
            X509TrustAll.ignoreSSLCerts = false;
        }

        @Deprecated
        public static void ignoreSSLCertificate() {
            X509TrustAll.ignoreSSLCerts = true;
        }
    }
}

