/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Optional;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String DATA_BASEDIR = PropertyUtils.getString("data.basedir.path", "/tmp/dolphinscheduler");
    public static final String APPINFO_PATH = "appInfo.log";
    public static final String KUBE_CONFIG_FILE = "config";
    public static final Set<PosixFilePermission> PERMISSION_755 = PosixFilePermissions.fromString("rwxr-xr-x");
    public static final Set<PosixFilePermission> PERMISSION_775 = PosixFilePermissions.fromString("rwxrwxr-x");

    public static String getDownloadFilename(String filename) {
        return Paths.get(DATA_BASEDIR, "tmp", CodeGenerateUtils.genCode() + "-" + filename).toString();
    }

    public static String getUploadFileLocalTmpAbsolutePath() {
        return Paths.get(DATA_BASEDIR, "tmp", String.valueOf(CodeGenerateUtils.genCode())).toString();
    }

    public static String getTaskInstanceWorkingDirectory(int taskInstanceId) {
        return String.format("%s/exec/process/%d", DATA_BASEDIR, taskInstanceId);
    }

    public static String getKubeConfigPath(String execPath) {
        return String.format("%s/%s", execPath, KUBE_CONFIG_FILE);
    }

    public static String getAppInfoPath(String execPath) {
        return String.format("%s/%s", execPath, APPINFO_PATH);
    }

    public static String getResourceViewSuffixes() {
        return PropertyUtils.getString("resource.view.suffixs", "txt,log,sh,bat,conf,cfg,py,java,sql,xml,hql,properties,json,yml,yaml,ini,js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeContent2File(String content, String filePath) {
        FileOutputStream fos = null;
        try {
            File distFile = new File(filePath);
            if (!distFile.getParentFile().exists() && !distFile.getParentFile().mkdirs()) {
                log.error("mkdir parent failed");
                boolean bl = false;
                IOUtils.closeQuietly((OutputStream)fos);
                return bl;
            }
            fos = new FileOutputStream(filePath);
            IOUtils.write((String)content, (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
        return true;
    }

    public static void deleteFile(String filename) {
        org.apache.commons.io.FileUtils.deleteQuietly((File)new File(filename));
    }

    public static String readFile2Str(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            return output.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean directoryTraversal(String filename) {
        if (filename.contains("/")) {
            return true;
        }
        File file = new File(filename);
        try {
            File canonical = file.getCanonicalFile();
            File absolute = file.getAbsoluteFile();
            return !canonical.equals(absolute);
        }
        catch (IOException e) {
            return true;
        }
    }

    public static String getFileChecksum(String pathName) throws IOException {
        CRC32 crc32 = new CRC32();
        File file = new File(pathName);
        String crcString = "";
        if (file.isDirectory()) {
            String[] subPaths = file.list();
            StringBuilder concatenatedCRC = new StringBuilder();
            for (String subPath : subPaths) {
                concatenatedCRC.append(FileUtils.getFileChecksum(pathName + "/" + subPath));
            }
            crcString = concatenatedCRC.toString();
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(pathName);
                 CheckedInputStream checkedInputStream = new CheckedInputStream(fileInputStream, crc32);){
                while (checkedInputStream.read() != -1) {
                }
            }
            catch (IOException e) {
                throw new IOException("Calculate checksum error.");
            }
            crcString = Long.toHexString(crc32.getValue());
        }
        return crcString;
    }

    public static void createFileWith755(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Path parent = path.getParent();
        if (!parent.toFile().exists()) {
            FileUtils.createDirectoryWithPermission(parent, PERMISSION_755);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Files.createFile(path, new FileAttribute[0]);
        } else {
            Files.createFile(path, new FileAttribute[0]);
            Files.setPosixFilePermissions(path, PERMISSION_755);
        }
    }

    public static void setFileTo755(File file) throws IOException {
        if (OSUtils.isWindows().booleanValue()) {
            return;
        }
        if (file.isFile()) {
            Files.setPosixFilePermissions(file.toPath(), PERMISSION_755);
            return;
        }
        Files.setPosixFilePermissions(file.toPath(), PERMISSION_755);
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                FileUtils.setFileTo755(f);
            }
        }
    }

    public static void createDirectoryWithPermission(@NonNull Path path, @NonNull Set<PosixFilePermission> permissions) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        if (path.toFile().exists()) {
            return;
        }
        if (OSUtils.isWindows().booleanValue()) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            Path parent = path.getParent();
            if (parent != null && !parent.toFile().exists()) {
                FileUtils.createDirectoryWithPermission(parent, permissions);
            }
            try {
                Files.createDirectory(path, new FileAttribute[0]);
                Files.setPosixFilePermissions(path, permissions);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                log.error("The directory: {} already exists", (Object)path);
            }
        }
    }

    public static String concatFilePath(String ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException("At least one path should be provided");
        }
        StringBuilder finalPath = new StringBuilder(paths[0]);
        if (StringUtils.isEmpty((CharSequence)finalPath)) {
            throw new IllegalArgumentException("The path should not be empty");
        }
        String separator = File.separator;
        for (int i = 1; i < paths.length; ++i) {
            String path = paths[i];
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("The path should not be empty");
            }
            if (finalPath.toString().endsWith(separator) && path.startsWith(separator)) {
                finalPath.append(path.substring(separator.length()));
                continue;
            }
            if (!finalPath.toString().endsWith(separator) && !path.startsWith(separator)) {
                finalPath.append(separator).append(path);
                continue;
            }
            finalPath.append(path);
        }
        return finalPath.toString();
    }

    public static String getClassPathAbsolutePath(Class clazz) {
        Preconditions.checkNotNull((Object)clazz, (Object)"class is null");
        return Optional.ofNullable(clazz.getResource("/")).map(URL::getPath).orElseThrow(() -> new IllegalArgumentException("class path: " + clazz + " is null"));
    }

    public static void copyInputStreamToFile(InputStream inputStream, String destFilename) {
        org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(destFilename));
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

