/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor;

import lombok.Generated;
import org.apache.dolphinscheduler.task.executor.ITaskEngine;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.ITaskExecutorRepository;
import org.apache.dolphinscheduler.task.executor.TaskEngineBuilder;
import org.apache.dolphinscheduler.task.executor.container.ITaskExecutorContainer;
import org.apache.dolphinscheduler.task.executor.container.ITaskExecutorContainerProvider;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorEventBusCoordinator;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorKillLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorPauseLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.exceptions.TaskExecutorNotFoundException;
import org.apache.dolphinscheduler.task.executor.exceptions.TaskExecutorRuntimeException;
import org.apache.dolphinscheduler.task.executor.log.TaskExecutorMDCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEngine
implements ITaskEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskEngine.class);
    private final String engineName;
    private final ITaskExecutorRepository taskExecutorRepository;
    private final ITaskExecutorContainerProvider taskExecutorContainerDelegator;
    private final ITaskExecutorEventBusCoordinator taskExecutorEventBusCoordinator;

    public TaskEngine(TaskEngineBuilder taskEngineBuilder) {
        this.engineName = taskEngineBuilder.getEngineName();
        this.taskExecutorContainerDelegator = taskEngineBuilder.getTaskExecutorContainerDelegator();
        this.taskExecutorRepository = taskEngineBuilder.getTaskExecutorRepository();
        this.taskExecutorEventBusCoordinator = taskEngineBuilder.getTaskExecutorEventBusCoordinator();
    }

    @Override
    public void start() {
        this.taskExecutorEventBusCoordinator.start();
        log.info("{} started", (Object)this.engineName);
    }

    @Override
    public void submitTask(ITaskExecutor taskExecutor) throws TaskExecutorRuntimeException {
        try (TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC(taskExecutor);){
            ITaskExecutorContainer executorContainer = this.taskExecutorContainerDelegator.getExecutorContainer();
            executorContainer.dispatch(taskExecutor);
            this.taskExecutorRepository.put(taskExecutor);
            taskExecutor.getTaskExecutorEventBus().publish(TaskExecutorDispatchedLifecycleEvent.of(taskExecutor));
            executorContainer.start(taskExecutor);
        }
    }

    @Override
    public void pauseTask(int taskExecutorId) throws TaskExecutorNotFoundException {
        ITaskExecutor taskExecutor = this.getTaskExecutor(taskExecutorId);
        try (TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC(taskExecutor);){
            taskExecutor.getTaskExecutorEventBus().publish(TaskExecutorPauseLifecycleEvent.of(taskExecutor));
        }
    }

    @Override
    public void killTask(int taskExecutorId) throws TaskExecutorNotFoundException {
        ITaskExecutor taskExecutor = this.getTaskExecutor(taskExecutorId);
        try (TaskExecutorMDCUtils.MDCAutoClosable ignore = TaskExecutorMDCUtils.logWithMDC(taskExecutor);){
            taskExecutor.getTaskExecutorEventBus().publish(TaskExecutorKillLifecycleEvent.of(taskExecutor));
        }
    }

    @Override
    public void close() {
        try (ITaskExecutorEventBusCoordinator ignore1 = this.taskExecutorEventBusCoordinator;){
            log.info("{} closed", (Object)this.engineName);
        }
    }

    private ITaskExecutor getTaskExecutor(int taskId) throws TaskExecutorNotFoundException {
        return this.taskExecutorRepository.get(taskId).orElseThrow(() -> new TaskExecutorNotFoundException(taskId));
    }
}

