/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageContextIssuerFunction;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Response;
import org.slf4j.Logger;

public class ResolveArtifacts
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ResolveArtifacts.class);
    @Nonnull
    private Function<ProfileRequestContext, Request> requestLookupStrategy = new MessageLookup(Request.class).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = new MessageLookup(Response.class).compose((Function)new OutboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new SAMLMessageContextIssuerFunction().compose((Function)new InboundMessageContextLookup());
    @NonnullAfterInit
    private SAMLArtifactMap artifactMap;
    @NonnullBeforeExec
    private Request request;
    @NonnullBeforeExec
    private Response response;
    @NonnullBeforeExec
    private String issuerId;
    @NonnullBeforeExec
    private String requesterId;

    public synchronized void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, Request> strategy) {
        this.checkSetterPreconditions();
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public synchronized void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        this.checkSetterPreconditions();
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public synchronized void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public synchronized void setRequesterLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.requesterLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requester lookup strategy cannot be null");
    }

    public synchronized void setArtifactMap(@Nonnull SAMLArtifactMap map) {
        this.checkSetterPreconditions();
        this.artifactMap = (SAMLArtifactMap)Constraint.isNotNull((Object)map, (String)"SAMLArtifactMap cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAMLArtifactMap cannot be null");
        }
        if (this.issuerLookupStrategy == null) {
            throw new ComponentInitializationException("Issuer lookup strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.request = this.requestLookupStrategy.apply(profileRequestContext);
        if (this.request == null) {
            this.log.debug("{} No request located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (this.request.getAssertionArtifacts().isEmpty()) {
            this.log.debug("{} No AssertionArtifact elements found in request, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No response located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No issuer identity located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.requesterId = this.requesterLookupStrategy.apply(profileRequestContext);
        if (this.requesterId == null) {
            this.log.debug("{} No requester identity located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String aval;
        boolean success = true;
        try {
            for (AssertionArtifact artifact : this.request.getAssertionArtifacts()) {
                aval = artifact.getValue();
                if (aval == null) continue;
                SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(aval);
                if (entry == null) {
                    this.log.warn("{} Unresolvable AssertionArtifact '{}' from relying party '{}'", new Object[]{this.getLogPrefix(), artifact.getValue(), this.requesterId});
                    success = false;
                    break;
                }
                this.artifactMap.remove(aval);
                if (!entry.getIssuerId().equals(this.issuerId)) {
                    this.log.warn("{} Artifact issuer mismatch, issued by '{}' but IdP has entityID of '{}'", new Object[]{this.getLogPrefix(), entry.getIssuerId(), this.issuerId});
                    success = false;
                    break;
                }
                if (!entry.getRelyingPartyId().equals(this.requesterId)) {
                    this.log.warn("{} Artifact relying party mismatch, issued to '{}' but requested by '{}'", new Object[]{this.getLogPrefix(), entry.getRelyingPartyId(), this.requesterId});
                    success = false;
                    break;
                }
                if (!(entry.getSamlMessage() instanceof Assertion)) {
                    this.log.warn("{} Artifact '{}' resolved to a non-Assertion object", (Object)this.getLogPrefix(), (Object)artifact.getValue());
                    success = false;
                    break;
                }
                this.response.getAssertions().add((Assertion)entry.getSamlMessage());
            }
        }
        catch (IOException e) {
            this.log.error("{} Error resolving artifact", (Object)this.getLogPrefix(), (Object)e);
            success = false;
        }
        if (!success) {
            this.response.getAssertions().clear();
            for (AssertionArtifact artifact : this.request.getAssertionArtifacts()) {
                aval = artifact.getValue();
                if (aval == null) continue;
                try {
                    this.artifactMap.remove(aval);
                }
                catch (IOException e) {
                    this.log.error("{} Error removing mapping for artifact '{}'", (Object)this.getLogPrefix(), (Object)artifact.getValue());
                }
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToResolveArtifact");
        }
    }
}

