/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.function.ByteConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ByteConsumerTest
extends AbstractLangTest {
    private static final byte B0 = 0;
    private static final byte B1 = 1;

    ByteConsumerTest() {
    }

    private ByteConsumer accept(ByteConsumer consumer, byte expected) {
        consumer.accept(expected);
        return consumer;
    }

    @Test
    void testAccept() {
        AtomicInteger ref = new AtomicInteger();
        this.accept(v -> ref.lazySet(v), (byte)1);
        Assertions.assertEquals((int)1, (int)ref.get());
        this.accept(v -> ref.lazySet(v), (byte)0);
        Assertions.assertEquals((int)0, (int)ref.get());
    }

    @Test
    void testAndThen() throws Throwable {
        ByteConsumer nop = ByteConsumer.nop();
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> nop.andThen(null));
        AtomicInteger ref1 = new AtomicInteger();
        AtomicInteger ref2 = new AtomicInteger();
        ByteConsumer bc = ref1::lazySet;
        ByteConsumer composite = bc.andThen(ref2::lazySet);
        composite.accept((byte)1);
        Assertions.assertEquals((int)1, (int)ref1.get());
        Assertions.assertEquals((int)1, (int)ref2.get());
        composite.accept((byte)0);
        Assertions.assertEquals((int)0, (int)ref1.get());
        Assertions.assertEquals((int)0, (int)ref2.get());
        ByteConsumer bad = value -> {
            throw new IllegalStateException();
        };
        ByteConsumer badComposite = bad.andThen(ref2::lazySet);
        Assertions.assertThrows(IllegalStateException.class, () -> badComposite.accept((byte)1));
        Assertions.assertEquals((int)0, (int)ref2.get(), (String)"Second consumer should not be invoked");
    }
}

