/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableBiFunction;
import org.apache.commons.lang3.function.FailableBiPredicate;
import org.apache.commons.lang3.function.FailableBooleanSupplier;
import org.apache.commons.lang3.function.FailableByteConsumer;
import org.apache.commons.lang3.function.FailableByteSupplier;
import org.apache.commons.lang3.function.FailableCallable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableDoubleBinaryOperator;
import org.apache.commons.lang3.function.FailableDoubleConsumer;
import org.apache.commons.lang3.function.FailableDoubleFunction;
import org.apache.commons.lang3.function.FailableDoublePredicate;
import org.apache.commons.lang3.function.FailableDoubleSupplier;
import org.apache.commons.lang3.function.FailableDoubleToIntFunction;
import org.apache.commons.lang3.function.FailableDoubleToLongFunction;
import org.apache.commons.lang3.function.FailableDoubleUnaryOperator;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableIntBinaryOperator;
import org.apache.commons.lang3.function.FailableIntConsumer;
import org.apache.commons.lang3.function.FailableIntFunction;
import org.apache.commons.lang3.function.FailableIntPredicate;
import org.apache.commons.lang3.function.FailableIntSupplier;
import org.apache.commons.lang3.function.FailableIntToDoubleFunction;
import org.apache.commons.lang3.function.FailableIntToFloatFunction;
import org.apache.commons.lang3.function.FailableIntToLongFunction;
import org.apache.commons.lang3.function.FailableIntUnaryOperator;
import org.apache.commons.lang3.function.FailableLongBinaryOperator;
import org.apache.commons.lang3.function.FailableLongConsumer;
import org.apache.commons.lang3.function.FailableLongFunction;
import org.apache.commons.lang3.function.FailableLongPredicate;
import org.apache.commons.lang3.function.FailableLongSupplier;
import org.apache.commons.lang3.function.FailableLongToDoubleFunction;
import org.apache.commons.lang3.function.FailableLongToIntFunction;
import org.apache.commons.lang3.function.FailableLongUnaryOperator;
import org.apache.commons.lang3.function.FailableObjDoubleConsumer;
import org.apache.commons.lang3.function.FailableObjIntConsumer;
import org.apache.commons.lang3.function.FailableObjLongConsumer;
import org.apache.commons.lang3.function.FailablePredicate;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableShortSupplier;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.lang3.function.FailableToBooleanFunction;
import org.apache.commons.lang3.function.FailableToDoubleBiFunction;
import org.apache.commons.lang3.function.FailableToDoubleFunction;
import org.apache.commons.lang3.function.FailableToIntBiFunction;
import org.apache.commons.lang3.function.FailableToIntFunction;
import org.apache.commons.lang3.function.FailableToLongBiFunction;
import org.apache.commons.lang3.function.FailableToLongFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class FailableTest
extends AbstractLangTest {
    private static final OutOfMemoryError ERROR = new OutOfMemoryError();
    private static final IllegalStateException ILLEGAL_STATE_EXCEPTION = new IllegalStateException();

    FailableTest() {
    }

    @BeforeEach
    void beforeEach() {
        FailureOnOddInvocations.reset();
    }

    @Test
    void testAcceptBiConsumer() {
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(Testable::test, (Object)testable, (Object)ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(Testable::test, (Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(Testable::test, (Object)testable, (Object)ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Failable.accept(Testable::test, testable, (Object)null);
    }

    @Test
    void testAcceptConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(Testable::test, (Object)testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Failable.accept(Testable::test, testable);
    }

    @Test
    void testAcceptDoubleConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testDouble, (double)1.0));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testDouble, (double)1.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testDouble, (double)1.0));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testDouble, (double)1.0);
        Assertions.assertEquals((double)1.0, (Double)((Double)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    void testAcceptIntConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testInt, (int)1));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testInt, (int)1));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testInt, (int)1));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testInt, (int)1);
        Assertions.assertEquals((int)1, (Integer)((Integer)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    void testAcceptLongConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testLong, (long)1L));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testLong, (long)1L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testLong, (long)1L));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testLong, (long)1L);
        Assertions.assertEquals((long)1L, (Long)((Long)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    void testAcceptObjDoubleConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testObjDouble, (Object)"X", (Object)1.0);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((double)1.0, (Double)((Double)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    void testAcceptObjIntConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testObjInt, (Object)"X", (Object)1));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testObjInt, (Object)"X", (Object)1));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testObjInt, (Object)"X", (Object)1));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testObjInt, (Object)"X", (Object)1);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((int)1, (Integer)((Integer)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    void testAcceptObjLongConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Failable.accept(testable::testObjLong, (Object)"X", (Object)1L);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((long)1L, (Long)((Long)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    void testApplyBiFunction() {
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable, (Object)ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable, (Object)ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Integer i = (Integer)Failable.apply(Testable::testAsInteger, testable, (Object)null);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    void testApplyDoubleBinaryOperator() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.applyAsDouble(testable::testDoubleDouble, (double)1.0, (double)2.0));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Testable testable2 = new Testable(null);
        double i = Failable.applyAsDouble(testable2::testDoubleDouble, (double)1.0, (double)2.0);
        Assertions.assertEquals((double)3.0, (double)i);
    }

    @Test
    void testApplyFunction() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.apply(Testable::testAsInteger, (Object)testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Integer i = (Integer)Failable.apply(Testable::testAsInteger, testable);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    void testApplyNonNull() throws SomeException {
        Assertions.assertEquals((Object)"A", (Object)Failable.applyNonNull((Object)"a", String::toUpperCase));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)null, String::toUpperCase));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)"a", s -> null));
        Assertions.assertThrows(NullPointerException.class, () -> Failable.applyNonNull((Object)"a", null));
        FailureOnInvocationCount obj1 = new FailureOnInvocationCount(1);
        Assertions.assertEquals((int)1, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull$2(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj1))).value);
        Assertions.assertEquals((int)2, (Integer)((Integer)Failable.applyNonNull((Object)1, obj1::inc)));
    }

    @Test
    void testApplyNonNull2() throws SomeException, IOException {
        Assertions.assertEquals((Object)"A", (Object)Failable.applyNonNull((Object)" a ", String::toUpperCase, String::trim));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)null, String::toUpperCase, String::trim));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)" a ", s -> null, String::trim));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)" a ", String::toUpperCase, s -> null));
        Assertions.assertThrows(NullPointerException.class, () -> Failable.applyNonNull((Object)" a ", null, String::trim));
        Assertions.assertThrows(NullPointerException.class, () -> Failable.applyNonNull((Object)" a ", String::toUpperCase, null));
        FailureOnInvocationCount obj1 = new FailureOnInvocationCount(1);
        FailureOnInvocationCount obj2 = new FailureOnInvocationCount(2);
        Assertions.assertEquals((int)1, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull2$4(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj1))).value);
        Assertions.assertEquals((int)2, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull2$5(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj2))).value);
        Assertions.assertEquals((int)3, (Integer)((Integer)Failable.applyNonNull((Object)1, obj1::inc, obj1::inc)));
        Assertions.assertEquals((int)3, (Integer)((Integer)Failable.applyNonNull((Object)1, obj2::inc, obj2::inc)));
        obj1.reset();
        obj2.reset();
        Assertions.assertEquals((int)1, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull2$6(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj1))).value);
        Assertions.assertEquals((int)2, (int)((SomeException)((IOException)Assertions.assertThrows(IOException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull2$7(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj2))).getCause()).value);
        Assertions.assertEquals((int)3, (Integer)((Integer)Failable.applyNonNull((Object)1, obj1::inc, obj1::incIo)));
        Assertions.assertEquals((int)3, (Integer)((Integer)Failable.applyNonNull((Object)1, obj2::inc, obj2::incIo)));
    }

    @Test
    void testApplyNonNull3() throws SomeException, IOException, ClassNotFoundException {
        Assertions.assertEquals((Object)"CBA", (Object)Failable.applyNonNull((Object)" abc ", String::toUpperCase, String::trim, StringUtils::reverse));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)null, String::toUpperCase, String::trim, StringUtils::reverse));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)" abc ", s -> null, String::trim, StringUtils::reverse));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)" abc ", String::toUpperCase, s -> null, StringUtils::reverse));
        Assertions.assertNull((Object)Failable.applyNonNull((Object)" abc ", String::toUpperCase, String::trim, s -> null));
        Assertions.assertThrows(NullPointerException.class, () -> Failable.applyNonNull((Object)" abc ", null, String::trim, StringUtils::reverse));
        Assertions.assertThrows(NullPointerException.class, () -> Failable.applyNonNull((Object)" abc ", String::toUpperCase, null, StringUtils::reverse));
        Assertions.assertThrows(NullPointerException.class, () -> Failable.applyNonNull((Object)" abc ", String::toUpperCase, String::trim, null));
        FailureOnInvocationCount obj1 = new FailureOnInvocationCount(1);
        FailureOnInvocationCount obj2 = new FailureOnInvocationCount(2);
        FailureOnInvocationCount obj3 = new FailureOnInvocationCount(3);
        Assertions.assertEquals((int)1, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull3$6(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj1))).value);
        Assertions.assertEquals((int)2, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull3$7(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj2))).value);
        Assertions.assertEquals((int)3, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull3$8(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj3))).value);
        Assertions.assertEquals((int)4, (Integer)((Integer)Failable.applyNonNull((Object)1, obj1::inc, obj1::inc, obj1::inc)));
        Assertions.assertEquals((int)4, (Integer)((Integer)Failable.applyNonNull((Object)1, obj2::inc, obj2::inc, obj2::inc)));
        Assertions.assertEquals((int)4, (Integer)((Integer)Failable.applyNonNull((Object)1, obj3::inc, obj3::inc, obj3::inc)));
        obj1.reset();
        obj2.reset();
        obj3.reset();
        Assertions.assertEquals((int)1, (int)((SomeException)Assertions.assertThrows(SomeException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull3$9(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj1))).value);
        Assertions.assertEquals((int)2, (int)((SomeException)((IOException)Assertions.assertThrows(IOException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull3$10(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj2))).getCause()).value);
        Assertions.assertEquals((int)3, (int)((SomeException)((IOException)Assertions.assertThrows(IOException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testApplyNonNull3$11(org.apache.commons.lang3.function.FailableTest$FailureOnInvocationCount ), ()V)((FailureOnInvocationCount)obj3))).getCause()).value);
        Assertions.assertEquals((int)4, (Integer)((Integer)Failable.applyNonNull((Object)1, obj1::inc, obj1::incIo, obj1::incIo)));
        Assertions.assertEquals((int)4, (Integer)((Integer)Failable.applyNonNull((Object)1, obj2::inc, obj2::incIo, obj2::incIo)));
        Assertions.assertEquals((int)4, (Integer)((Integer)Failable.applyNonNull((Object)1, obj3::inc, obj3::incIo, obj3::incIo)));
    }

    @Test
    void testAsCallable() {
        FailureOnOddInvocations instance;
        FailureOnOddInvocations.invocations = 0;
        FailableCallable failableCallable = FailureOnOddInvocations::new;
        Callable callable = Failable.asCallable((FailableCallable)failableCallable);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, callable::call);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        try {
            instance = (FailureOnOddInvocations)callable.call();
        }
        catch (Exception ex) {
            throw Failable.rethrow((Throwable)ex);
        }
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    void testAsConsumer() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Consumer consumer = Failable.asConsumer(Testable::test);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> consumer.accept(testable));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> consumer.accept(testable));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> consumer.accept(testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Failable.accept(Testable::test, testable);
    }

    @Test
    void testAsRunnable() {
        FailureOnOddInvocations.invocations = 0;
        Runnable runnable = Failable.asRunnable(FailureOnOddInvocations::new);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, runnable::run);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        runnable.run();
    }

    @Test
    void testAsSupplier() {
        FailureOnOddInvocations.invocations = 0;
        FailableSupplier failableSupplier = FailureOnOddInvocations::new;
        Supplier supplier = Failable.asSupplier((FailableSupplier)failableSupplier);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, ((Supplier)supplier)::get);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Assertions.assertNotNull(supplier.get());
    }

    @Test
    void testBiConsumer() throws Throwable {
        Testable testable = new Testable(null);
        FailableBiConsumer failableBiConsumer = (t, th) -> {
            t.setThrowable((Throwable)th);
            t.test();
        };
        BiConsumer consumer = Failable.asBiConsumer((FailableBiConsumer)failableBiConsumer);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> consumer.accept(testable, ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> consumer.accept(testable, ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failableBiConsumer.accept((Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> consumer.accept(testable, ioe));
        Throwable t2 = e.getCause();
        Assertions.assertNotNull((Object)t2);
        Assertions.assertSame((Object)ioe, (Object)t2);
        consumer.accept(testable, null);
    }

    @Test
    void testBiConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableBiConsumer failing = (t, th) -> {
            t.setThrowable((Throwable)th);
            t.test();
        };
        FailableBiConsumer nop = FailableBiConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept((Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept((Object)testable, (Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testBiFunction() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        FailableBiFunction failableBiFunction = (t, th) -> {
            t.setThrowable((Throwable)th);
            return t.testAsInteger();
        };
        BiFunction biFunction = Failable.asBiFunction((FailableBiFunction)failableBiFunction);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> biFunction.apply(testable, ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> biFunction.apply(testable, ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> biFunction.apply(testable, ioe));
        Throwable t2 = e.getCause();
        Assertions.assertNotNull((Object)t2);
        Assertions.assertSame((Object)ioe, (Object)t2);
        Assertions.assertEquals((int)0, (int)((Integer)biFunction.apply(testable, null)));
    }

    @Test
    void testBiFunctionAndThen() throws IOException {
        BiFunction<Object, Integer, Integer> nopBiFunction = (t, u) -> null;
        Function<Object, Integer> nopFunction = t -> null;
        nopBiFunction.andThen(nopFunction);
        FailableBiFunction failingBiFunctionTest = (t, u) -> {
            throw new IOException();
        };
        FailableFunction failingFunction = t -> {
            throw new IOException();
        };
        FailableBiFunction nopFailableBiFunction = FailableBiFunction.nop();
        FailableFunction nopFailableFunction = FailableFunction.nop();
        Assertions.assertThrows(IOException.class, () -> failingBiFunctionTest.andThen(failingFunction).apply(null, null));
        Assertions.assertThrows(IOException.class, () -> failingBiFunctionTest.andThen(nopFailableFunction).apply(null, null));
        Assertions.assertThrows(IOException.class, () -> nopFailableBiFunction.andThen(failingFunction).apply(null, null));
        nopFailableBiFunction.andThen(nopFailableFunction).apply(null, null);
        LangAssertions.assertNullPointerException(() -> failingBiFunctionTest.andThen(null));
    }

    @Test
    @DisplayName(value="Test that asPredicate(FailableBiPredicate) is converted to -> BiPredicate ")
    void testBiPredicate() {
        FailureOnOddInvocations.invocations = 0;
        FailableBiPredicate failableBiPredicate = (t1, t2) -> FailureOnOddInvocations.testGetBool();
        BiPredicate predicate = Failable.asBiPredicate((FailableBiPredicate)failableBiPredicate);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> predicate.test(null, null));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Assertions.assertTrue((boolean)predicate.test(null, null));
    }

    @Test
    void testBiPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableBiPredicate.TRUE.and(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.TRUE.and(FailableBiPredicate.FALSE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.FALSE.and(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.FALSE.and(FailableBiPredicate.FALSE).test(null, null));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableBiPredicate.falsePredicate().and(null).test(null, null)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableBiPredicate.truePredicate().and(null).test(null, null)));
    }

    @Test
    void testBiPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableBiPredicate.TRUE.negate().test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.truePredicate().negate().test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.FALSE.negate().test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.falsePredicate().negate().test(null, null));
    }

    @Test
    void testBiPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableBiPredicate.TRUE.or(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.TRUE.or(FailableBiPredicate.FALSE).test(null, null));
        Assertions.assertTrue((boolean)FailableBiPredicate.FALSE.or(FailableBiPredicate.TRUE).test(null, null));
        Assertions.assertFalse((boolean)FailableBiPredicate.FALSE.or(FailableBiPredicate.FALSE).test(null, null));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableBiPredicate.falsePredicate().or(null).test(null, null)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableBiPredicate.truePredicate().or(null).test(null, null)));
    }

    @Test
    void testByteConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableByteConsumer failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
        };
        FailableByteConsumer nop = FailableByteConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept((byte)0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept((byte)0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testCallable() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Failable.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        FailureOnOddInvocations instance = (FailureOnOddInvocations)Failable.call(FailureOnOddInvocations::new);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    void testConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableConsumer failableConsumer = th -> {
            testable.setThrowable((Throwable)th);
            testable.test();
        };
        FailableConsumer nop = FailableConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failableConsumer).accept((Object)ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failableConsumer.andThen(null));
    }

    @Test
    void testDoubleConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableDoubleConsumer failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
        };
        FailableDoubleConsumer nop = FailableDoubleConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testDoublePredicate() throws Throwable {
        FailureOnOddInvocations.invocations = 0;
        FailableDoublePredicate failablePredicate = FailureOnOddInvocations::testDouble;
        Assertions.assertThrows(SomeException.class, () -> failablePredicate.test(1.0));
        failablePredicate.test(1.0);
    }

    @Test
    void testDoublePredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableDoublePredicate.TRUE.and(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.TRUE.and(FailableDoublePredicate.FALSE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.FALSE.and(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.FALSE.and(FailableDoublePredicate.FALSE).test(0.0));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableDoublePredicate.falsePredicate().and(null).test(0.0)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableDoublePredicate.truePredicate().and(null).test(0.0)));
    }

    @Test
    void testDoublePredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableDoublePredicate.TRUE.negate().test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.truePredicate().negate().test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.FALSE.negate().test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.falsePredicate().negate().test(0.0));
    }

    @Test
    void testDoublePredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableDoublePredicate.TRUE.or(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.TRUE.or(FailableDoublePredicate.FALSE).test(0.0));
        Assertions.assertTrue((boolean)FailableDoublePredicate.FALSE.or(FailableDoublePredicate.TRUE).test(0.0));
        Assertions.assertFalse((boolean)FailableDoublePredicate.FALSE.or(FailableDoublePredicate.FALSE).test(0.0));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableDoublePredicate.falsePredicate().or(null).test(0.0)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableDoublePredicate.truePredicate().or(null).test(0.0)));
    }

    @Test
    void testDoubleUnaryOperatorAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableDoubleUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0.0;
        };
        FailableDoubleUnaryOperator nop = FailableDoubleUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testDoubleUnaryOperatorCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableDoubleUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0.0;
        };
        FailableDoubleUnaryOperator nop = FailableDoubleUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).applyAsDouble(0.0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> failing.compose(null));
    }

    @Test
    void testDoubleUnaryOperatorIdentity() throws Throwable {
        FailableDoubleUnaryOperator nop = FailableDoubleUnaryOperator.identity();
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> nop.compose(null));
    }

    @Test
    void testFailableBiFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableBiFunction.nop().apply((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return null");
    }

    @Test
    void testFailableConsumerNop() throws Throwable {
        FailableConsumer.nop().accept((Object)"Foo");
    }

    @Test
    void testFailableDoubleFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableDoubleFunction.nop().apply(Double.MAX_VALUE), (String)"Expect NOP to return null");
    }

    @Test
    void testFailableDoubleToIntFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableDoubleToIntFunction.nop().applyAsInt(Double.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableDoubleToLongFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableDoubleToLongFunction.nop().applyAsLong(Double.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableIntFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableIntFunction.nop().apply(Integer.MAX_VALUE), (String)"Expect NOP to return null");
    }

    @Test
    void testFailableIntToDoubleFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableIntToDoubleFunction.nop().applyAsDouble(Integer.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableIntToFloatFunctionNop() throws Throwable {
        Assertions.assertEquals((float)0.0f, (float)FailableIntToFloatFunction.nop().applyAsFloat(Integer.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableIntToLongFunctionNop() throws Throwable {
        Assertions.assertEquals((long)0L, (long)FailableIntToLongFunction.nop().applyAsLong(Integer.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableLongFunctionNop() throws Throwable {
        Assertions.assertNull((Object)FailableLongFunction.nop().apply(Long.MAX_VALUE), (String)"Expect NOP to return null");
    }

    @Test
    void testFailableLongToDoubleFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableLongToDoubleFunction.nop().applyAsDouble(Long.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableLongToIntFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableLongToIntFunction.nop().applyAsInt(Long.MAX_VALUE), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableObjDoubleConsumerNop() throws Throwable {
        FailableObjDoubleConsumer.nop().accept((Object)"Foo", Double.MAX_VALUE);
    }

    @Test
    void testFailableObjIntConsumerNop() throws Throwable {
        FailableObjIntConsumer.nop().accept((Object)"Foo", Integer.MAX_VALUE);
    }

    @Test
    void testFailableObjLongConsumerNop() throws Throwable {
        FailableObjLongConsumer.nop().accept((Object)"Foo", Long.MAX_VALUE);
    }

    @Test
    void testFailableToBooleanFunctionNop() throws Throwable {
        Assertions.assertEquals((Object)false, (Object)FailableToBooleanFunction.nop().applyAsBoolean((Object)"Foo"), (String)"Expect NOP to return false");
    }

    @Test
    void testFailableToDoubleBiFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableToDoubleBiFunction.nop().applyAsDouble((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableToDoubleFunctionNop() throws Throwable {
        Assertions.assertEquals((double)0.0, (double)FailableToDoubleFunction.nop().applyAsDouble((Object)"Foo"), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableToIntBiFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableToIntBiFunction.nop().applyAsInt((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableToIntFunctionNop() throws Throwable {
        Assertions.assertEquals((int)0, (int)FailableToIntFunction.nop().applyAsInt((Object)"Foo"), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableToLongBiFunctionNop() throws Throwable {
        Assertions.assertEquals((long)0L, (long)FailableToLongBiFunction.nop().applyAsLong((Object)"Foo", (Object)"Bar"), (String)"Expect NOP to return 0");
    }

    @Test
    void testFailableToLongFunctionNop() throws Throwable {
        Assertions.assertEquals((long)0L, (long)FailableToLongFunction.nop().applyAsLong((Object)"Foo"), (String)"Expect NOP to return 0");
    }

    @Test
    void testFunction() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        FailableFunction failableFunction = th -> {
            testable.setThrowable((Throwable)th);
            return testable.testAsInteger();
        };
        Function function = Failable.asFunction((FailableFunction)failableFunction);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> function.apply(ILLEGAL_STATE_EXCEPTION));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> function.apply(ERROR));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> function.apply(ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertEquals((int)0, (int)((Integer)function.apply(null)));
    }

    @Test
    void testFunctionAndThen() throws IOException {
        Function<Object, Integer> nopFunction = t -> null;
        nopFunction.andThen(nopFunction);
        FailableFunction failingFunction = t -> {
            throw new IOException();
        };
        FailableFunction nopFailableFunction = FailableFunction.nop();
        Assertions.assertThrows(IOException.class, () -> failingFunction.andThen(failingFunction).apply(null));
        Assertions.assertThrows(IOException.class, () -> failingFunction.andThen(nopFailableFunction).apply(null));
        Assertions.assertThrows(IOException.class, () -> nopFailableFunction.andThen(failingFunction).apply(null));
        nopFailableFunction.andThen(nopFailableFunction).apply(null);
        LangAssertions.assertNullPointerException(() -> failingFunction.andThen(null));
    }

    @Test
    void testFunctionCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableFunction failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0;
        };
        FailableFunction nop = FailableFunction.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).apply((Object)0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).apply((Object)0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> failing.compose(null));
    }

    @Test
    void testFunctionFunction() throws Exception {
        Assertions.assertEquals((Object)"foo", (Object)FailableFunction.function(this::throwingFunction).andThen(this::throwingFunction).apply((Object)"foo"));
    }

    @Test
    void testFunctionIdentity() throws Throwable {
        FailableFunction nop = FailableFunction.identity();
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> nop.compose(null));
    }

    @Test
    void testGetAsBooleanSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsBoolean(testable::testAsBooleanPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsBoolean(testable::testAsBooleanPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsBoolean(testable::testAsBooleanPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Assertions.assertFalse((boolean)Failable.getAsBoolean(testable::testAsBooleanPrimitive));
    }

    @Test
    void testGetAsDoubleSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsDouble(testable::testAsDoublePrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsDouble(testable::testAsDoublePrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsDouble(testable::testAsDoublePrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Assertions.assertEquals((double)0.0, (double)Failable.getAsDouble(testable::testAsDoublePrimitive));
    }

    @Test
    void testGetAsIntSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsInt(testable::testAsIntPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsInt(testable::testAsIntPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsInt(testable::testAsIntPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        int i = Failable.getAsInt(testable::testAsInteger);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    void testGetAsLongSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsLong(testable::testAsLongPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsLong(testable::testAsLongPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsLong(testable::testAsLongPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        long i = Failable.getAsLong(testable::testAsLongPrimitive);
        Assertions.assertEquals((long)0L, (long)i);
    }

    @Test
    void testGetAsShortSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.getAsShort(testable::testAsShortPrimitive));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.getAsShort(testable::testAsShortPrimitive));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.getAsShort(testable::testAsShortPrimitive));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        short i = Failable.getAsShort(testable::testAsShortPrimitive);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    void testGetFromSupplier() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Failable.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        FailureOnOddInvocations instance = (FailureOnOddInvocations)Failable.call(FailureOnOddInvocations::new);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    void testGetSupplier() {
        Testable testable = new Testable(ILLEGAL_STATE_EXCEPTION);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Failable.get(testable::testAsInteger));
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        testable.setThrowable(ERROR);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Failable.get(testable::testAsInteger));
        Assertions.assertSame((Object)ERROR, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Failable.get(testable::testAsInteger));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Integer i = (Integer)Failable.apply(Testable::testAsInteger, testable);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    void testIntConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableIntConsumer failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
        };
        FailableIntConsumer nop = FailableIntConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testIntPredicate() throws Throwable {
        FailureOnOddInvocations.invocations = 0;
        FailableIntPredicate failablePredicate = FailureOnOddInvocations::testInt;
        Assertions.assertThrows(SomeException.class, () -> failablePredicate.test(1));
        failablePredicate.test(1);
    }

    @Test
    void testIntPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableIntPredicate.TRUE.and(FailableIntPredicate.TRUE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.TRUE.and(FailableIntPredicate.FALSE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.FALSE.and(FailableIntPredicate.TRUE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.FALSE.and(FailableIntPredicate.FALSE).test(0));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableIntPredicate.falsePredicate().and(null).test(0)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableIntPredicate.truePredicate().and(null).test(0)));
    }

    @Test
    void testIntPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableIntPredicate.TRUE.negate().test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.truePredicate().negate().test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.FALSE.negate().test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.falsePredicate().negate().test(0));
    }

    @Test
    void testIntPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableIntPredicate.TRUE.or(FailableIntPredicate.TRUE).test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.TRUE.or(FailableIntPredicate.FALSE).test(0));
        Assertions.assertTrue((boolean)FailableIntPredicate.FALSE.or(FailableIntPredicate.TRUE).test(0));
        Assertions.assertFalse((boolean)FailableIntPredicate.FALSE.or(FailableIntPredicate.FALSE).test(0));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableIntPredicate.falsePredicate().or(null).test(0)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableIntPredicate.truePredicate().or(null).test(0)));
    }

    @Test
    void testIntUnaryOperatorAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableIntUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0;
        };
        FailableIntUnaryOperator nop = FailableIntUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testIntUnaryOperatorCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableIntUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0;
        };
        FailableIntUnaryOperator nop = FailableIntUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).applyAsInt(0));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> failing.compose(null));
    }

    @Test
    void testIntUnaryOperatorIdentity() throws Throwable {
        FailableIntUnaryOperator nop = FailableIntUnaryOperator.identity();
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> nop.compose(null));
    }

    @Test
    void testLongConsumerAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableLongConsumer failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
        };
        FailableLongConsumer nop = FailableLongConsumer.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).accept(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).accept(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testLongPredicate() throws Throwable {
        FailureOnOddInvocations.invocations = 0;
        FailableLongPredicate failablePredicate = FailureOnOddInvocations::testLong;
        Assertions.assertThrows(SomeException.class, () -> failablePredicate.test(1L));
        failablePredicate.test(1L);
    }

    @Test
    void testLongPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailableLongPredicate.TRUE.and(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.TRUE.and(FailableLongPredicate.FALSE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.FALSE.and(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.FALSE.and(FailableLongPredicate.FALSE).test(0L));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableLongPredicate.falsePredicate().and(null).test(0L)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableLongPredicate.truePredicate().and(null).test(0L)));
    }

    @Test
    void testLongPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailableLongPredicate.TRUE.negate().test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.truePredicate().negate().test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.FALSE.negate().test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.falsePredicate().negate().test(0L));
    }

    @Test
    void testLongPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailableLongPredicate.TRUE.or(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.TRUE.or(FailableLongPredicate.FALSE).test(0L));
        Assertions.assertTrue((boolean)FailableLongPredicate.FALSE.or(FailableLongPredicate.TRUE).test(0L));
        Assertions.assertFalse((boolean)FailableLongPredicate.FALSE.or(FailableLongPredicate.FALSE).test(0L));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailableLongPredicate.falsePredicate().or(null).test(0L)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailableLongPredicate.truePredicate().or(null).test(0L)));
    }

    @Test
    void testLongUnaryOperatorAndThen() throws Throwable {
        Testable testable = new Testable(null);
        FailableLongUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0L;
        };
        FailableLongUnaryOperator nop = FailableLongUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.andThen(failing).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.andThen(nop).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.andThen(nop);
        LangAssertions.assertNullPointerException(() -> failing.andThen(null));
    }

    @Test
    void testLongUnaryOperatorCompose() throws Throwable {
        Testable testable = new Testable(null);
        FailableLongUnaryOperator failing = t -> {
            testable.setThrowable(ERROR);
            testable.test();
            return 0L;
        };
        FailableLongUnaryOperator nop = FailableLongUnaryOperator.nop();
        Throwable e = Assertions.assertThrows(OutOfMemoryError.class, () -> nop.compose(failing).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> failing.compose(nop).applyAsLong(0L));
        Assertions.assertSame((Object)ERROR, (Object)e);
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> failing.compose(null));
    }

    @Test
    void testLongUnaryOperatorIdentity() throws Throwable {
        FailableLongUnaryOperator nop = FailableLongUnaryOperator.identity();
        nop.compose(nop);
        LangAssertions.assertNullPointerException(() -> nop.compose(null));
    }

    @Test
    @DisplayName(value="Test that asPredicate(FailablePredicate) is converted to -> Predicate ")
    void testPredicate() {
        FailureOnOddInvocations.invocations = 0;
        FailablePredicate failablePredicate = t -> FailureOnOddInvocations.testGetBool();
        Predicate predicate = Failable.asPredicate((FailablePredicate)failablePredicate);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> predicate.test(null));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        boolean instance = predicate.test(null);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    void testPredicateAnd() throws Throwable {
        Assertions.assertTrue((boolean)FailablePredicate.TRUE.and(FailablePredicate.TRUE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.TRUE.and(FailablePredicate.FALSE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.FALSE.and(FailablePredicate.TRUE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.FALSE.and(FailablePredicate.FALSE).test(null));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailablePredicate.FALSE.and(null).test(null)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailablePredicate.TRUE.and(null).test(null)));
    }

    @Test
    void testPredicateNegate() throws Throwable {
        Assertions.assertFalse((boolean)FailablePredicate.TRUE.negate().test(null));
        Assertions.assertFalse((boolean)FailablePredicate.truePredicate().negate().test(null));
        Assertions.assertTrue((boolean)FailablePredicate.FALSE.negate().test(null));
        Assertions.assertTrue((boolean)FailablePredicate.falsePredicate().negate().test(null));
    }

    @Test
    void testPredicateOr() throws Throwable {
        Assertions.assertTrue((boolean)FailablePredicate.TRUE.or(FailablePredicate.TRUE).test(null));
        Assertions.assertTrue((boolean)FailablePredicate.TRUE.or(FailablePredicate.FALSE).test(null));
        Assertions.assertTrue((boolean)FailablePredicate.FALSE.or(FailablePredicate.TRUE).test(null));
        Assertions.assertFalse((boolean)FailablePredicate.FALSE.or(FailablePredicate.FALSE).test(null));
        LangAssertions.assertNullPointerException(() -> Assertions.assertFalse((boolean)FailablePredicate.FALSE.or(null).test(null)));
        LangAssertions.assertNullPointerException(() -> Assertions.assertTrue((boolean)FailablePredicate.TRUE.or(null).test(null)));
    }

    @Test
    void testRunnable() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Failable.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertInstanceOf(SomeException.class, (Object)cause);
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Failable.run(FailureOnOddInvocations::new);
        Failable.run(null);
    }

    @Test
    void testThrows_FailableBiConsumer_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableBiConsumer<Object, Object, Throwable>(){

            public void accept(Object object1, Object object2) throws Throwable {
                throw new IOException("test");
            }
        }.accept(new Object(), new Object()));
    }

    @Test
    void testThrows_FailableBiConsumer_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableBiConsumer<String, String, IOException>(){

            public void accept(String object1, String object2) throws IOException {
                throw new IOException("test");
            }
        }.accept("", ""));
    }

    @Test
    void testThrows_FailableBiFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableBiFunction<Object, Object, Object, Throwable>(){

            public Object apply(Object input1, Object input2) throws Throwable {
                throw new IOException("test");
            }
        }.apply(new Object(), new Object()));
    }

    @Test
    void testThrows_FailableBiFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableBiFunction<String, String, String, IOException>(){

            public String apply(String input1, String input2) throws IOException {
                throw new IOException("test");
            }
        }.apply("", ""));
    }

    @Test
    void testThrows_FailableBiPredicate_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableBiPredicate<Object, Object, Throwable>(){

            public boolean test(Object object1, Object object2) throws Throwable {
                throw new IOException("test");
            }
        }.test(new Object(), new Object()));
    }

    @Test
    void testThrows_FailableBiPredicate_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableBiPredicate<String, String, IOException>(){

            public boolean test(String object1, String object2) throws IOException {
                throw new IOException("test");
            }
        }.test("", ""));
    }

    @Test
    void testThrows_FailableBooleanSupplier_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableBooleanSupplier<IOException>(){

            public boolean getAsBoolean() throws IOException {
                throw new IOException("test");
            }
        }.getAsBoolean());
    }

    @Test
    void testThrows_FailableBooleanSupplier_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableBooleanSupplier<Throwable>(){

            public boolean getAsBoolean() throws Throwable {
                throw new IOException("test");
            }
        }.getAsBoolean());
    }

    @Test
    void testThrows_FailableByteConsumer_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableByteConsumer<IOException>(){

            public void accept(byte value) throws IOException {
                throw new IOException("test");
            }
        }.accept((byte)0));
    }

    @Test
    void testThrows_FailableByteConsumer_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableByteConsumer<Throwable>(){

            public void accept(byte value) throws Throwable {
                throw new IOException("test");
            }
        }.accept((byte)0));
    }

    @Test
    void testThrows_FailableByteSupplier_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableByteSupplier<IOException>(){

            public byte getAsByte() throws IOException {
                throw new IOException("test");
            }
        }.getAsByte());
    }

    @Test
    void testThrows_FailableByteSupplier_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableByteSupplier<Throwable>(){

            public byte getAsByte() throws Throwable {
                throw new IOException("test");
            }
        }.getAsByte());
    }

    @Test
    void testThrows_FailableCallable_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableCallable<Object, Throwable>(){

            public Object call() throws Throwable {
                throw new IOException("test");
            }
        }.call());
    }

    @Test
    void testThrows_FailableCallable_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableCallable<String, IOException>(){

            public String call() throws IOException {
                throw new IOException("test");
            }
        }.call());
    }

    @Test
    void testThrows_FailableConsumer_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableConsumer<Object, Throwable>(){

            public void accept(Object object) throws Throwable {
                throw new IOException("test");
            }
        }.accept(new Object()));
    }

    @Test
    void testThrows_FailableConsumer_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableConsumer<String, IOException>(){

            public void accept(String object) throws IOException {
                throw new IOException("test");
            }
        }.accept(""));
    }

    @Test
    void testThrows_FailableDoubleBinaryOperator_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleBinaryOperator<IOException>(){

            public double applyAsDouble(double left, double right) throws IOException {
                throw new IOException("test");
            }
        }.applyAsDouble(0.0, 0.0));
    }

    @Test
    void testThrows_FailableDoubleBinaryOperator_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleBinaryOperator<Throwable>(){

            public double applyAsDouble(double left, double right) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsDouble(0.0, 0.0));
    }

    @Test
    void testThrows_FailableDoubleConsumer_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleConsumer<IOException>(){

            public void accept(double value) throws IOException {
                throw new IOException("test");
            }
        }.accept(0.0));
    }

    @Test
    void testThrows_FailableDoubleConsumer_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleConsumer<Throwable>(){

            public void accept(double value) throws Throwable {
                throw new IOException("test");
            }
        }.accept(0.0));
    }

    @Test
    void testThrows_FailableDoubleFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleFunction<String, IOException>(){

            public String apply(double input) throws IOException {
                throw new IOException("test");
            }
        }.apply(0.0));
    }

    @Test
    void testThrows_FailableDoubleFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleFunction<Object, Throwable>(){

            public Object apply(double input) throws Throwable {
                throw new IOException("test");
            }
        }.apply(0.0));
    }

    @Test
    void testThrows_FailableDoubleSupplier_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleSupplier<IOException>(){

            public double getAsDouble() throws IOException {
                throw new IOException("test");
            }
        }.getAsDouble());
    }

    @Test
    void testThrows_FailableDoubleSupplier_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleSupplier<Throwable>(){

            public double getAsDouble() throws Throwable {
                throw new IOException("test");
            }
        }.getAsDouble());
    }

    @Test
    void testThrows_FailableDoubleToIntFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleToIntFunction<IOException>(){

            public int applyAsInt(double value) throws IOException {
                throw new IOException("test");
            }
        }.applyAsInt(0.0));
    }

    @Test
    void testThrows_FailableDoubleToIntFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleToIntFunction<Throwable>(){

            public int applyAsInt(double value) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsInt(0.0));
    }

    @Test
    void testThrows_FailableDoubleToLongFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleToLongFunction<IOException>(){

            public int applyAsLong(double value) throws IOException {
                throw new IOException("test");
            }
        }.applyAsLong(0.0));
    }

    @Test
    void testThrows_FailableDoubleToLongFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableDoubleToLongFunction<Throwable>(){

            public int applyAsLong(double value) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsLong(0.0));
    }

    @Test
    void testThrows_FailableFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableFunction<Object, Object, Throwable>(){

            public Object apply(Object input) throws Throwable {
                throw new IOException("test");
            }
        }.apply(new Object()));
    }

    @Test
    void testThrows_FailableFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableFunction<String, String, IOException>(){

            public String apply(String input) throws IOException {
                throw new IOException("test");
            }
        }.apply(""));
    }

    @Test
    void testThrows_FailableIntBinaryOperator_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntBinaryOperator<IOException>(){

            public int applyAsInt(int left, int right) throws IOException {
                throw new IOException("test");
            }
        }.applyAsInt(0, 0));
    }

    @Test
    void testThrows_FailableIntBinaryOperator_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntBinaryOperator<Throwable>(){

            public int applyAsInt(int left, int right) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsInt(0, 0));
    }

    @Test
    void testThrows_FailableIntConsumer_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntConsumer<IOException>(){

            public void accept(int value) throws IOException {
                throw new IOException("test");
            }
        }.accept(0));
    }

    @Test
    void testThrows_FailableIntConsumer_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntConsumer<Throwable>(){

            public void accept(int value) throws Throwable {
                throw new IOException("test");
            }
        }.accept(0));
    }

    @Test
    void testThrows_FailableIntFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntFunction<Object, Throwable>(){

            public Object apply(int input) throws Throwable {
                throw new IOException("test");
            }
        }.apply(0));
    }

    @Test
    void testThrows_FailableIntFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntFunction<String, IOException>(){

            public String apply(int input) throws IOException {
                throw new IOException("test");
            }
        }.apply(0));
    }

    @Test
    void testThrows_FailableIntSupplier_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntSupplier<IOException>(){

            public int getAsInt() throws IOException {
                throw new IOException("test");
            }
        }.getAsInt());
    }

    @Test
    void testThrows_FailableIntSupplier_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntSupplier<Throwable>(){

            public int getAsInt() throws Throwable {
                throw new IOException("test");
            }
        }.getAsInt());
    }

    @Test
    void testThrows_FailableIntToDoubleFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntToDoubleFunction<IOException>(){

            public double applyAsDouble(int value) throws IOException {
                throw new IOException("test");
            }
        }.applyAsDouble(0));
    }

    @Test
    void testThrows_FailableIntToDoubleFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntToDoubleFunction<Throwable>(){

            public double applyAsDouble(int value) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsDouble(0));
    }

    @Test
    void testThrows_FailableIntToFloatFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntToFloatFunction<IOException>(){

            public float applyAsFloat(int value) throws IOException {
                throw new IOException("test");
            }
        }.applyAsFloat(0));
    }

    @Test
    void testThrows_FailableIntToFloatFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntToFloatFunction<Throwable>(){

            public float applyAsFloat(int value) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsFloat(0));
    }

    @Test
    void testThrows_FailableIntToLongFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntToLongFunction<IOException>(){

            public long applyAsLong(int value) throws IOException {
                throw new IOException("test");
            }
        }.applyAsLong(0));
    }

    @Test
    void testThrows_FailableIntToLongFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableIntToLongFunction<Throwable>(){

            public long applyAsLong(int value) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsLong(0));
    }

    @Test
    void testThrows_FailableLongBinaryOperator_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongBinaryOperator<IOException>(){

            public long applyAsLong(long left, long right) throws IOException {
                throw new IOException("test");
            }
        }.applyAsLong(0L, 0L));
    }

    @Test
    void testThrows_FailableLongBinaryOperator_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongBinaryOperator<Throwable>(){

            public long applyAsLong(long left, long right) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsLong(0L, 0L));
    }

    @Test
    void testThrows_FailableLongConsumer_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongConsumer<IOException>(){

            public void accept(long object) throws IOException {
                throw new IOException("test");
            }
        }.accept(0L));
    }

    @Test
    void testThrows_FailableLongConsumer_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongConsumer<Throwable>(){

            public void accept(long object) throws Throwable {
                throw new IOException("test");
            }
        }.accept(0L));
    }

    @Test
    void testThrows_FailableLongFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongFunction<String, IOException>(){

            public String apply(long input) throws IOException {
                throw new IOException("test");
            }
        }.apply(0L));
    }

    @Test
    void testThrows_FailableLongFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongFunction<Object, Throwable>(){

            public Object apply(long input) throws Throwable {
                throw new IOException("test");
            }
        }.apply(0L));
    }

    @Test
    void testThrows_FailableLongSupplier_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongSupplier<IOException>(){

            public long getAsLong() throws IOException {
                throw new IOException("test");
            }
        }.getAsLong());
    }

    @Test
    void testThrows_FailableLongSupplier_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongSupplier<Throwable>(){

            public long getAsLong() throws Throwable {
                throw new IOException("test");
            }
        }.getAsLong());
    }

    @Test
    void testThrows_FailableLongToDoubleFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongToDoubleFunction<IOException>(){

            public double applyAsDouble(long value) throws IOException {
                throw new IOException("test");
            }
        }.applyAsDouble(0L));
    }

    @Test
    void testThrows_FailableLongToDoubleFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongToDoubleFunction<Throwable>(){

            public double applyAsDouble(long value) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsDouble(0L));
    }

    @Test
    void testThrows_FailableLongToIntFunction_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongToIntFunction<IOException>(){

            public int applyAsInt(long value) throws IOException {
                throw new IOException("test");
            }
        }.applyAsInt(0L));
    }

    @Test
    void testThrows_FailableLongToIntFunction_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableLongToIntFunction<Throwable>(){

            public int applyAsInt(long value) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsInt(0L));
    }

    @Test
    void testThrows_FailableObjDoubleConsumer_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableObjDoubleConsumer<Object, Throwable>(){

            public void accept(Object object, double value) throws Throwable {
                throw new IOException("test");
            }
        }.accept(new Object(), 0.0));
    }

    @Test
    void testThrows_FailableObjDoubleConsumer_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableObjDoubleConsumer<String, IOException>(){

            public void accept(String object, double value) throws IOException {
                throw new IOException("test");
            }
        }.accept("", 0.0));
    }

    @Test
    void testThrows_FailableObjIntConsumer_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableObjIntConsumer<Object, Throwable>(){

            public void accept(Object object, int value) throws Throwable {
                throw new IOException("test");
            }
        }.accept(new Object(), 0));
    }

    @Test
    void testThrows_FailableObjIntConsumer_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableObjIntConsumer<String, IOException>(){

            public void accept(String object, int value) throws IOException {
                throw new IOException("test");
            }
        }.accept("", 0));
    }

    @Test
    void testThrows_FailableObjLongConsumer_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableObjLongConsumer<Object, Throwable>(){

            public void accept(Object object, long value) throws Throwable {
                throw new IOException("test");
            }
        }.accept(new Object(), 0L));
    }

    @Test
    void testThrows_FailableObjLongConsumer_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableObjLongConsumer<String, IOException>(){

            public void accept(String object, long value) throws IOException {
                throw new IOException("test");
            }
        }.accept("", 0L));
        FailableObjLongConsumer f = (o, l) -> {
            throw new IOException("test");
        };
        Assertions.assertThrows(IOException.class, () -> f.accept((Object)"", 0L));
    }

    @Test
    void testThrows_FailablePredicate_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailablePredicate<Object, Throwable>(){

            public boolean test(Object object) throws Throwable {
                throw new IOException("test");
            }
        }.test(new Object()));
    }

    @Test
    void testThrows_FailablePredicate_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailablePredicate<String, IOException>(){

            public boolean test(String object) throws IOException {
                throw new IOException("test");
            }
        }.test(""));
    }

    @Test
    void testThrows_FailableRunnable_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableRunnable<IOException>(){

            public void run() throws IOException {
                throw new IOException("test");
            }
        }.run());
    }

    @Test
    void testThrows_FailableRunnable_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableRunnable<Throwable>(){

            public void run() throws Throwable {
                throw new IOException("test");
            }
        }.run());
    }

    @Test
    void testThrows_FailableShortSupplier_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableShortSupplier<IOException>(){

            public short getAsShort() throws IOException {
                throw new IOException("test");
            }
        }.getAsShort());
    }

    @Test
    void testThrows_FailableShortSupplier_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableShortSupplier<Throwable>(){

            public short getAsShort() throws Throwable {
                throw new IOException("test");
            }
        }.getAsShort());
    }

    @Test
    void testThrows_FailableSupplier_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableSupplier<Object, Throwable>(){

            public Object get() throws Throwable {
                throw new IOException("test");
            }
        }.get());
    }

    @Test
    void testThrows_FailableSupplier_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableSupplier<String, IOException>(){

            public String get() throws IOException {
                throw new IOException("test");
            }
        }.get());
    }

    @Test
    void testThrows_FailableToBooleanFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableToBooleanFunction<Object, Throwable>(){

            public boolean applyAsBoolean(Object t) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsBoolean(new Object()));
    }

    @Test
    void testThrows_FailableToBooleanFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableToBooleanFunction<String, IOException>(){

            public boolean applyAsBoolean(String t) throws IOException {
                throw new IOException("test");
            }
        }.applyAsBoolean(""));
    }

    @Test
    void testThrows_FailableToDoubleBiFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableToDoubleBiFunction<Object, Object, Throwable>(){

            public double applyAsDouble(Object t, Object u) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsDouble(new Object(), new Object()));
    }

    @Test
    void testThrows_FailableToDoubleBiFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableToDoubleBiFunction<String, String, IOException>(){

            public double applyAsDouble(String t, String u) throws IOException {
                throw new IOException("test");
            }
        }.applyAsDouble("", ""));
    }

    @Test
    void testThrows_FailableToDoubleFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableToDoubleFunction<Object, Throwable>(){

            public double applyAsDouble(Object t) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsDouble(new Object()));
    }

    @Test
    void testThrows_FailableToDoubleFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableToDoubleFunction<String, IOException>(){

            public double applyAsDouble(String t) throws IOException {
                throw new IOException("test");
            }
        }.applyAsDouble(""));
    }

    @Test
    void testThrows_FailableToIntBiFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableToIntBiFunction<Object, Object, Throwable>(){

            public int applyAsInt(Object t, Object u) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsInt(new Object(), new Object()));
    }

    @Test
    void testThrows_FailableToIntBiFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableToIntBiFunction<String, String, IOException>(){

            public int applyAsInt(String t, String u) throws IOException {
                throw new IOException("test");
            }
        }.applyAsInt("", ""));
    }

    @Test
    void testThrows_FailableToIntFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableToIntFunction<Object, Throwable>(){

            public int applyAsInt(Object t) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsInt(new Object()));
    }

    @Test
    void testThrows_FailableToIntFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableToIntFunction<String, IOException>(){

            public int applyAsInt(String t) throws IOException {
                throw new IOException("test");
            }
        }.applyAsInt(""));
    }

    @Test
    void testThrows_FailableToLongBiFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableToLongBiFunction<Object, Object, Throwable>(){

            public long applyAsLong(Object t, Object u) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsLong(new Object(), new Object()));
    }

    @Test
    void testThrows_FailableToLongBiFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableToLongBiFunction<String, String, IOException>(){

            public long applyAsLong(String t, String u) throws IOException {
                throw new IOException("test");
            }
        }.applyAsLong("", ""));
    }

    @Test
    void testThrows_FailableToLongFunction_Object_Throwable() {
        Assertions.assertThrows(IOException.class, () -> new FailableToLongFunction<Object, Throwable>(){

            public long applyAsLong(Object t) throws Throwable {
                throw new IOException("test");
            }
        }.applyAsLong(new Object()));
    }

    @Test
    void testThrows_FailableToLongFunction_String_IOException() {
        Assertions.assertThrows(IOException.class, () -> new FailableToLongFunction<String, IOException>(){

            public long applyAsLong(String t) throws IOException {
                throw new IOException("test");
            }
        }.applyAsLong(""));
    }

    @Test
    void testTryWithResources() {
        CloseableObject closeable = new CloseableObject();
        FailableConsumer consumer = closeable::run;
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
            failableRunnableArray[0] = closeable::close;
            Failable.tryWithResources(() -> consumer.accept((Object)ILLEGAL_STATE_EXCEPTION), (FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)ILLEGAL_STATE_EXCEPTION, (Object)e);
        Assertions.assertTrue((boolean)closeable.isClosed());
        closeable.reset();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
            failableRunnableArray[0] = closeable::close;
            Failable.tryWithResources(() -> consumer.accept((Object)ERROR), (FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)ERROR, (Object)e);
        Assertions.assertTrue((boolean)closeable.isClosed());
        closeable.reset();
        IOException ioe = new IOException("Unknown I/O error");
        UncheckedIOException uioe = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> {
            FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
            failableRunnableArray[0] = closeable::close;
            Failable.tryWithResources(() -> consumer.accept((Object)ioe), (FailableRunnable[])failableRunnableArray);
        });
        IOException cause = uioe.getCause();
        Assertions.assertSame((Object)ioe, (Object)cause);
        Assertions.assertTrue((boolean)closeable.isClosed());
        closeable.reset();
        FailableRunnable[] failableRunnableArray = new FailableRunnable[1];
        failableRunnableArray[0] = closeable::close;
        Failable.tryWithResources(() -> consumer.accept(null), (FailableRunnable[])failableRunnableArray);
        Assertions.assertTrue((boolean)closeable.isClosed());
    }

    private String throwingFunction(String input) throws Exception {
        return input;
    }

    private static /* synthetic */ void lambda$testApplyNonNull3$11(FailureOnInvocationCount obj3) throws Throwable {
        Failable.applyNonNull((Object)1, obj3::inc, obj3::incIo, obj3::incIo);
    }

    private static /* synthetic */ void lambda$testApplyNonNull3$10(FailureOnInvocationCount obj2) throws Throwable {
        Failable.applyNonNull((Object)1, obj2::inc, obj2::incIo, obj2::incIo);
    }

    private static /* synthetic */ void lambda$testApplyNonNull3$9(FailureOnInvocationCount obj1) throws Throwable {
        Failable.applyNonNull((Object)1, obj1::inc, obj1::incIo, obj1::incIo);
    }

    private static /* synthetic */ void lambda$testApplyNonNull3$8(FailureOnInvocationCount obj3) throws Throwable {
        Failable.applyNonNull((Object)1, obj3::inc, obj3::inc, obj3::inc);
    }

    private static /* synthetic */ void lambda$testApplyNonNull3$7(FailureOnInvocationCount obj2) throws Throwable {
        Failable.applyNonNull((Object)1, obj2::inc, obj2::inc, obj2::inc);
    }

    private static /* synthetic */ void lambda$testApplyNonNull3$6(FailureOnInvocationCount obj1) throws Throwable {
        Failable.applyNonNull((Object)1, obj1::inc, obj1::inc, obj1::inc);
    }

    private static /* synthetic */ void lambda$testApplyNonNull2$7(FailureOnInvocationCount obj2) throws Throwable {
        Failable.applyNonNull((Object)1, obj2::inc, obj2::incIo);
    }

    private static /* synthetic */ void lambda$testApplyNonNull2$6(FailureOnInvocationCount obj1) throws Throwable {
        Failable.applyNonNull((Object)1, obj1::inc, obj1::incIo);
    }

    private static /* synthetic */ void lambda$testApplyNonNull2$5(FailureOnInvocationCount obj2) throws Throwable {
        Failable.applyNonNull((Object)1, obj2::inc, obj2::inc);
    }

    private static /* synthetic */ void lambda$testApplyNonNull2$4(FailureOnInvocationCount obj1) throws Throwable {
        Failable.applyNonNull((Object)1, obj1::inc, obj1::inc);
    }

    private static /* synthetic */ void lambda$testApplyNonNull$2(FailureOnInvocationCount obj1) throws Throwable {
        Failable.applyNonNull((Object)1, obj1::inc);
    }

    public static class FailureOnOddInvocations {
        private static int invocations;

        static void reset() {
            invocations = 0;
        }

        static boolean testDouble(double value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testGetBool() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static int testInc(int value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return value + 1;
        }

        static boolean testInt(int value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testLong(long value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        private static void throwOnOdd() throws SomeException {
            int i;
            if ((i = ++invocations) % 2 == 1) {
                throw new SomeException("Odd Invocation: " + i, i);
            }
        }

        FailureOnOddInvocations() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
        }

        boolean getAsBoolean() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }
    }

    public static class Testable<T, P> {
        private T acceptedObject;
        private P acceptedPrimitiveObject1;
        private P acceptedPrimitiveObject2;
        private Throwable throwable;

        Testable(Throwable throwable) {
            this.throwable = throwable;
        }

        public T getAcceptedObject() {
            return this.acceptedObject;
        }

        public P getAcceptedPrimitiveObject1() {
            return this.acceptedPrimitiveObject1;
        }

        public P getAcceptedPrimitiveObject2() {
            return this.acceptedPrimitiveObject2;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        void test() throws Throwable {
            this.test(this.throwable);
        }

        public Object test(Object input1, Object input2) throws Throwable {
            this.test(this.throwable);
            return this.acceptedObject;
        }

        void test(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
        }

        public boolean testAsBooleanPrimitive() throws Throwable {
            return this.testAsBooleanPrimitive(this.throwable);
        }

        public boolean testAsBooleanPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return false;
        }

        public double testAsDoublePrimitive() throws Throwable {
            return this.testAsDoublePrimitive(this.throwable);
        }

        public double testAsDoublePrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0.0;
        }

        public Integer testAsInteger() throws Throwable {
            return this.testAsInteger(this.throwable);
        }

        public Integer testAsInteger(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        public int testAsIntPrimitive() throws Throwable {
            return this.testAsIntPrimitive(this.throwable);
        }

        public int testAsIntPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        public long testAsLongPrimitive() throws Throwable {
            return this.testAsLongPrimitive(this.throwable);
        }

        public long testAsLongPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0L;
        }

        public short testAsShortPrimitive() throws Throwable {
            return this.testAsShortPrimitive(this.throwable);
        }

        public short testAsShortPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        void testDouble(double i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        public double testDoubleDouble(double i, double j) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
            this.acceptedPrimitiveObject2 = j;
            return 3.0;
        }

        void testInt(int i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        void testLong(long i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        void testObjDouble(T object, double i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }

        void testObjInt(T object, int i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }

        void testObjLong(T object, long i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }
    }

    public static class FailureOnInvocationCount {
        private int current;
        private final int throwOn;

        FailureOnInvocationCount(int throwOn) throws SomeException {
            this.throwOn = throwOn;
        }

        int inc(int value) throws SomeException {
            this.throwSeOn();
            return value + 1;
        }

        int incCnfe(int value) throws ClassNotFoundException {
            this.throwCnfeOn();
            return value + 1;
        }

        int incIo(int value) throws IOException {
            this.throwIoOn();
            return value + 1;
        }

        void reset() {
            this.current = 0;
        }

        private void throwCnfeOn() throws ClassNotFoundException {
            if (++this.current == this.throwOn) {
                String message = "Count: " + this.current;
                throw new ClassNotFoundException(message, new SomeException(message, this.current));
            }
        }

        private void throwIoOn() throws IOException {
            if (++this.current == this.throwOn) {
                throw new IOException(new SomeException("Count: " + this.current, this.current));
            }
        }

        private void throwSeOn() throws SomeException {
            if (++this.current == this.throwOn) {
                throw new SomeException("Count: " + this.current, this.current);
            }
        }
    }

    public static class SomeException
    extends Exception {
        private static final long serialVersionUID = -4965704778119283411L;
        private Throwable t;
        final int value;

        SomeException(String message) {
            this(message, 0);
        }

        SomeException(String message, int value) {
            super(message);
            this.value = value;
        }

        public void setThrowable(Throwable throwable) {
            this.t = throwable;
        }

        void test() throws Throwable {
            if (this.t != null) {
                throw this.t;
            }
        }
    }

    public static class CloseableObject {
        private boolean closed;

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void reset() {
            this.closed = false;
        }

        public void run(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
        }
    }
}

