/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.celeborn.client.compress.Decompressor;
import org.apache.celeborn.client.compress.Lz4Trait;
import org.apache.celeborn.shaded.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class Lz4Decompressor
extends Lz4Trait
implements Decompressor {
    private static final Logger logger = LoggerFactory.getLogger(Lz4Decompressor.class);
    private final LZ4FastDecompressor decompressor;
    private final Checksum checksum;
    private final Map<String, Supplier<XXHashFactory>> xxHashFactories = ImmutableMap.of("JNI", XXHashFactory::nativeInstance, "JAVASAFE", XXHashFactory::safeInstance, "JAVAUNSAFE", XXHashFactory::unsafeInstance);

    public Lz4Decompressor(Option<String> xxHashInstance) {
        this.decompressor = LZ4Factory.fastestInstance().fastDecompressor();
        this.checksum = this.getXXHashFactory(xxHashInstance).newStreamingHash32(-1756908916).asChecksum();
    }

    @Override
    public int getOriginalLen(byte[] src) {
        return this.readIntLE(src, MAGIC_LENGTH + 5);
    }

    @Override
    public int decompress(byte[] src, byte[] dst, int dstOff) throws IOException {
        int compressionMethod = src[MAGIC_LENGTH] & 0xFF;
        int compressedLen = this.readIntLE(src, MAGIC_LENGTH + 1);
        int originalLen = this.readIntLE(src, MAGIC_LENGTH + 5);
        int check = this.readIntLE(src, MAGIC_LENGTH + 9);
        switch (compressionMethod) {
            case 16: {
                System.arraycopy(src, HEADER_LENGTH, dst, dstOff, originalLen);
                break;
            }
            case 32: {
                int compressedLen2 = this.decompressor.decompress(src, HEADER_LENGTH, dst, dstOff, originalLen);
                if (compressedLen == compressedLen2) break;
                throw new IOException("Compressed length corrupted! expected: " + compressedLen + ", actual: " + compressedLen2 + ".");
            }
        }
        this.checksum.reset();
        this.checksum.update(dst, dstOff, originalLen);
        if ((int)this.checksum.getValue() != check) {
            throw new IOException("Checksum not equal! expected: " + check + ", actual: " + this.checksum.getValue() + ".");
        }
        return originalLen;
    }

    private XXHashFactory getXXHashFactory(Option<String> xxHashInstance) {
        return xxHashInstance.isDefined() && this.xxHashFactories.containsKey(xxHashInstance.get()) ? this.xxHashFactories.get(xxHashInstance.get()).get() : XXHashFactory.fastestInstance();
    }
}

