/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.cli.master;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.celeborn.cli.CelebornCli;
import org.apache.celeborn.cli.common.BaseCommand;
import org.apache.celeborn.cli.common.CommonOptions;
import org.apache.celeborn.cli.config.CliConfigManager;
import org.apache.celeborn.cli.config.CliConfigManager$;
import org.apache.celeborn.cli.master.MasterOptions;
import org.apache.celeborn.cli.master.MasterSubcommand;
import org.apache.celeborn.cli.master.ReviseLostShuffleOptions;
import org.apache.celeborn.rest.v1.master.ApplicationApi;
import org.apache.celeborn.rest.v1.master.ConfApi;
import org.apache.celeborn.rest.v1.master.DefaultApi;
import org.apache.celeborn.rest.v1.master.MasterApi;
import org.apache.celeborn.rest.v1.master.ShuffleApi;
import org.apache.celeborn.rest.v1.master.WorkerApi;
import org.apache.celeborn.rest.v1.model.ApplicationInfoResponse;
import org.apache.celeborn.rest.v1.model.ApplicationsHeartbeatResponse;
import org.apache.celeborn.rest.v1.model.ConfResponse;
import org.apache.celeborn.rest.v1.model.ContainerInfo;
import org.apache.celeborn.rest.v1.model.DeleteAppsRequest;
import org.apache.celeborn.rest.v1.model.DeleteDynamicConfigRequest;
import org.apache.celeborn.rest.v1.model.DynamicConfigResponse;
import org.apache.celeborn.rest.v1.model.ExcludeWorkerRequest;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.HostnamesResponse;
import org.apache.celeborn.rest.v1.model.MasterInfoResponse;
import org.apache.celeborn.rest.v1.model.RemoveWorkersUnavailableInfoRequest;
import org.apache.celeborn.rest.v1.model.ReviseLostShufflesRequest;
import org.apache.celeborn.rest.v1.model.SendWorkerEventRequest;
import org.apache.celeborn.rest.v1.model.ShufflesResponse;
import org.apache.celeborn.rest.v1.model.ThreadStackResponse;
import org.apache.celeborn.rest.v1.model.TopologyResponse;
import org.apache.celeborn.rest.v1.model.UpsertDynamicConfigRequest;
import org.apache.celeborn.rest.v1.model.WorkerData;
import org.apache.celeborn.rest.v1.model.WorkerEventsResponse;
import org.apache.celeborn.rest.v1.model.WorkerId;
import org.apache.celeborn.rest.v1.model.WorkerTimestampData;
import org.apache.celeborn.rest.v1.model.WorkersResponse;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@CommandLine.Command(name="master")
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0010!\u0001-BQA\u000e\u0001\u0005\u0002]BQ!\u000f\u0001\u0005BiBa!\u0011\u0001\u0005\u0002\u0001\u0012\u0005BB'\u0001\t\u0003\u0001c\n\u0003\u0004S\u0001\u0011\u0005\u0001e\u0015\u0005\u0007/\u0002!\t\u0001\t-\t\rq\u0003A\u0011\u0001\u0011^\u0011\u0019\t\u0007\u0001\"\u0001!;\"1!\r\u0001C\u0001AuCaa\u0019\u0001\u0005\u0002\u0001j\u0006B\u00023\u0001\t\u0003\u0001S\r\u0003\u0004j\u0001\u0011\u0005\u0001E\u001b\u0005\u0007u\u0002!\t\u0001I>\t\u000f\u0005\u0005\u0001\u0001\"\u0001!w\"9\u00111\u0001\u0001\u0005\u0002\u0001Z\bbBA\u0003\u0001\u0011\u0005\u0001e\u001f\u0005\t\u0003\u000f\u0001A\u0011\u0001\u0011\u0002\n!A\u0011\u0011\u0003\u0001\u0005\u0002\u0001\n\u0019\u0002\u0003\u0005\u0002\u001c\u0001!\t\u0001IA\u000f\u0011!\t)\u0003\u0001C\u0001A\u0005\u001d\u0002\u0002CA \u0001\u0011\u0005\u0001%!\u0011\t\u0011\u0005%\u0003\u0001\"\u0001!\u0003\u0017Bq!a\u0015\u0001\t\u0003\u0001S\fC\u0004\u0002V\u0001!\t\u0001I/\t\u0011\u0005]\u0003\u0001\"\u0001!\u00033B\u0001\"!\u0019\u0001\t\u0003\u0001\u00131\r\u0005\t\u0003K\u0002A\u0011\u0001\u0011\u0002d!A\u0011q\r\u0001\u0005\u0002\u0001\nI\u0007C\u0004\u0002r\u0001!\t\u0005I/\t\u000f\u0005M\u0004\u0001\"\u0011!;\n!R*Y:uKJ\u001cVOY2p[6\fg\u000eZ%na2T!!\t\u0012\u0002\r5\f7\u000f^3s\u0015\t\u0019C%A\u0002dY&T!!\n\u0014\u0002\u0011\r,G.\u001a2pe:T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011c\u0001\u0001-eA\u0011Q\u0006M\u0007\u0002])\u0011qFI\u0001\u0007G>lWn\u001c8\n\u0005Er#a\u0003\"bg\u0016\u001cu.\\7b]\u0012\u0004\"a\r\u001b\u000e\u0003\u0001J!!\u000e\u0011\u0003!5\u000b7\u000f^3s'V\u00147m\\7nC:$\u0017A\u0002\u001fj]&$h\bF\u00019!\t\u0019\u0004!A\u0002sk:$\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0005+:LG/\u0001\nsk:\u001c\u0006n\\<NCN$XM]:J]\u001a|W#A\"\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015!B7pI\u0016d'B\u0001%J\u0003\t1\u0018G\u0003\u0002KI\u0005!!/Z:u\u0013\taUI\u0001\nNCN$XM]%oM>\u0014Vm\u001d9p]N,\u0017A\u0005:v]NCwn^\"mkN$XM]!qaN,\u0012a\u0014\t\u0003\tBK!!U#\u0003;\u0005\u0003\b\u000f\\5dCRLwN\\:IK\u0006\u0014HOY3biJ+7\u000f]8og\u0016\faC];o'\"|wo\u00117vgR,'/\u00119qg&sgm\\\u000b\u0002)B\u0011A)V\u0005\u0003-\u0016\u0013q#\u00119qY&\u001c\u0017\r^5p]&sgm\u001c*fgB|gn]3\u0002-I,hn\u00155po\u000ecWo\u001d;feNCWO\u001a4mKN,\u0012!\u0017\t\u0003\tjK!aW#\u0003!MCWO\u001a4mKN\u0014Vm\u001d9p]N,\u0017!\u0005:v]\u0016C8\r\\;eK^{'o[3sgV\ta\f\u0005\u0002E?&\u0011\u0001-\u0012\u0002\u000f\u0011\u0006tG\r\\3SKN\u0004xN\\:f\u0003a\u0011XO\u001c*f[>4X-\u0012=dYV$W\rZ,pe.,'o]\u0001 eVt'+Z7pm\u0016<vN]6feN,f.\u0019<bS2\f'\r\\3J]\u001a|\u0017A\u0005:v]N+g\u000eZ,pe.,'/\u0012<f]R\faC];o'\"|woV8sW\u0016\u0014XI^3oi&sgm\\\u000b\u0002MB\u0011AiZ\u0005\u0003Q\u0016\u0013AcV8sW\u0016\u0014XI^3oiN\u0014Vm\u001d9p]N,\u0017A\u0005:v]NCwn\u001e'pgR<vN]6feN,\u0012a\u001b\t\u0004YR<hBA7s\u001d\tq\u0017/D\u0001p\u0015\t\u0001(&\u0001\u0004=e>|GOP\u0005\u0002}%\u00111/P\u0001\ba\u0006\u001c7.Y4f\u0013\t)hOA\u0002TKFT!a]\u001f\u0011\u0005\u0011C\u0018BA=F\u0005M9vN]6feRKW.Z:uC6\u0004H)\u0019;b\u0003Y\u0011XO\\*i_^,\u0005p\u00197vI\u0016$wk\u001c:lKJ\u001cX#\u0001?\u0011\u00071$X\u0010\u0005\u0002E}&\u0011q0\u0012\u0002\u000b/>\u00148.\u001a:ECR\f\u0017\u0001\b:v]NCwn^'b]V\fG.\u0012=dYV$W\rZ,pe.,'o]\u0001\u0017eVt7\u000b[8x'\",H\u000fZ8x]^{'o[3sg\u0006i\"/\u001e8TQ><H)Z2p[6L7o]5p]&twmV8sW\u0016\u00148/\u0001\rsk:\u001c\u0006n\\<MS\u001a,7-_2mK6\u000bg.Y4feN,\"!a\u0003\u0011\u0007\u0011\u000bi!C\u0002\u0002\u0010\u0015\u0013\u0011\u0003S8ti:\fW.Z:SKN\u0004xN\\:f\u00039\u0011XO\\*i_^<vN]6feN,\"!!\u0006\u0011\u0007\u0011\u000b9\"C\u0002\u0002\u001a\u0015\u0013qbV8sW\u0016\u00148OU3ta>t7/Z\u0001\u0017eVt7\u000b[8x/>\u00148.\u001a:t)>\u0004x\u000e\\8hsV\u0011\u0011q\u0004\t\u0004\t\u0006\u0005\u0012bAA\u0012\u000b\n\u0001Bk\u001c9pY><\u0017PU3ta>t7/Z\u0001\rO\u0016$xk\u001c:lKJLEm]\u000b\u0003\u0003S\u0001b!a\u000b\u00026\u0005eRBAA\u0017\u0015\u0011\ty#!\r\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003g\tAA[1wC&!\u0011qGA\u0017\u0005\u0011a\u0015n\u001d;\u0011\u0007\u0011\u000bY$C\u0002\u0002>\u0015\u0013\u0001bV8sW\u0016\u0014\u0018\nZ\u0001\feVt7\u000b[8x\u0007>tg-\u0006\u0002\u0002DA\u0019A)!\u0012\n\u0007\u0005\u001dSI\u0001\u0007D_:4'+Z:q_:\u001cX-\u0001\nsk:\u001c\u0006n\\<Es:\fW.[2D_:4WCAA'!\r!\u0015qJ\u0005\u0004\u0003#*%!\u0006#z]\u0006l\u0017nY\"p]\u001aLwMU3ta>t7/Z\u0001\u0015eVtW\u000b]:feR$\u0015P\\1nS\u000e\u001cuN\u001c4\u0002)I,h\u000eR3mKR,G)\u001f8b[&\u001c7i\u001c8g\u0003E\u0011XO\\*i_^$\u0006N]3bI\u0012+X\u000e]\u000b\u0003\u00037\u00022\u0001RA/\u0013\r\ty&\u0012\u0002\u0014)\"\u0014X-\u00193Ti\u0006\u001c7NU3ta>t7/Z\u0001\u0013eVt\u0017\t\u001a3DYV\u001cH/\u001a:BY&\f7/F\u0001<\u0003U\u0011XO\u001c*f[>4Xm\u00117vgR,'/\u00117jCN\fAC];o'\"|woQ8oi\u0006Lg.\u001a:J]\u001a|WCAA6!\r!\u0015QN\u0005\u0004\u0003_*%!D\"p]R\f\u0017N\\3s\u0013:4w.\u0001\nsKZL7/\u001a'pgR\u001c\u0006.\u001e4gY\u0016\u001c\u0018A\u00033fY\u0016$X-\u00119qg\":\u0001!a\u001e\u0002\u000e\u0006=\u0005\u0003BA=\u0003\u000fsA!a\u001f\u0002\u0002:\u0019a.! \n\u0005\u0005}\u0014a\u00029jG>\u001cG.[\u0005\u0005\u0003\u0007\u000b))A\u0006D_6l\u0017M\u001c3MS:,'BAA@\u0013\u0011\tI)a#\u0003\u000f\r{W.\\1oI*!\u00111QAC\u0003\u0011q\u0017-\\3\"\u0003\u0005\u0002")
public class MasterSubcommandImpl
extends BaseCommand
implements MasterSubcommand {
    @CommandLine.ParentCommand
    private CelebornCli org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    private MasterOptions masterOptions;
    @CommandLine.ArgGroup(exclusive=false)
    private ReviseLostShuffleOptions reviseLostShuffleOptions;
    @CommandLine.Mixin
    private CommonOptions commonOptions;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private final CliConfigManager cliConfigManager;

    @Override
    public ApplicationApi applicationApi() {
        return MasterSubcommand.applicationApi$(this);
    }

    @Override
    public ConfApi confApi() {
        return MasterSubcommand.confApi$(this);
    }

    @Override
    public DefaultApi defaultApi() {
        return MasterSubcommand.defaultApi$(this);
    }

    @Override
    public MasterApi masterApi() {
        return MasterSubcommand.masterApi$(this);
    }

    @Override
    public ShuffleApi shuffleApi() {
        return MasterSubcommand.shuffleApi$(this);
    }

    @Override
    public WorkerApi workerApi() {
        return MasterSubcommand.workerApi$(this);
    }

    @Override
    public CelebornCli org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli() {
        return this.org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli;
    }

    @Override
    public void org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli_$eq(CelebornCli x$1) {
        this.org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli = x$1;
    }

    @Override
    public MasterOptions masterOptions() {
        return this.masterOptions;
    }

    @Override
    public void masterOptions_$eq(MasterOptions x$1) {
        this.masterOptions = x$1;
    }

    @Override
    public ReviseLostShuffleOptions reviseLostShuffleOptions() {
        return this.reviseLostShuffleOptions;
    }

    @Override
    public void reviseLostShuffleOptions_$eq(ReviseLostShuffleOptions x$1) {
        this.reviseLostShuffleOptions = x$1;
    }

    @Override
    public CommonOptions commonOptions() {
        return this.commonOptions;
    }

    @Override
    public void commonOptions_$eq(CommonOptions x$1) {
        this.commonOptions = x$1;
    }

    @Override
    public CommandLine.Model.CommandSpec spec() {
        return this.spec;
    }

    @Override
    public void spec_$eq(CommandLine.Model.CommandSpec x$1) {
        this.spec = x$1;
    }

    @Override
    public CliConfigManager cliConfigManager() {
        return this.cliConfigManager;
    }

    @Override
    public void org$apache$celeborn$cli$master$MasterSubcommand$_setter_$cliConfigManager_$eq(CliConfigManager x$1) {
        this.cliConfigManager = x$1;
    }

    @Override
    public void run() {
        if (this.masterOptions().showMastersInfo()) {
            this.log(this.runShowMastersInfo());
        }
        if (this.masterOptions().showClusterApps()) {
            this.log(this.runShowClusterApps());
        }
        if (this.masterOptions().showClusterAppsInfo()) {
            this.log(this.runShowClusterAppsInfo());
        }
        if (this.masterOptions().showClusterShuffles()) {
            this.log(this.runShowClusterShuffles());
        }
        if (this.masterOptions().excludeWorkers()) {
            this.log(this.runExcludeWorkers());
        }
        if (this.masterOptions().removeExcludedWorkers()) {
            this.log(this.runRemoveExcludedWorkers());
        }
        if (this.masterOptions().removeWorkersUnavailableInfo()) {
            this.log(this.runRemoveWorkersUnavailableInfo());
        }
        if (this.masterOptions().sendWorkerEvent() != null && new StringOps(Predef$.MODULE$.augmentString(this.masterOptions().sendWorkerEvent())).nonEmpty()) {
            this.log(this.runSendWorkerEvent());
        }
        if (this.masterOptions().showWorkerEventInfo()) {
            this.log(this.runShowWorkerEventInfo());
        }
        if (this.masterOptions().showLostWorkers()) {
            this.log(this.runShowLostWorkers());
        }
        if (this.masterOptions().showExcludedWorkers()) {
            this.log(this.runShowExcludedWorkers());
        }
        if (this.masterOptions().showManualExcludedWorkers()) {
            this.log(this.runShowManualExcludedWorkers());
        }
        if (this.masterOptions().showShutdownWorkers()) {
            this.log(this.runShowShutdownWorkers());
        }
        if (this.masterOptions().showDecommissioningWorkers()) {
            this.log(this.runShowDecommissioningWorkers());
        }
        if (this.masterOptions().showLifecycleManagers()) {
            this.log(this.runShowLifecycleManagers());
        }
        if (this.masterOptions().showWorkers()) {
            this.log(this.runShowWorkers());
        }
        if (this.masterOptions().showWorkersTopology()) {
            this.log(this.runShowWorkersTopology());
        }
        if (this.masterOptions().showConf()) {
            this.log(this.runShowConf());
        }
        if (this.masterOptions().showContainerInfo()) {
            this.log(this.runShowContainerInfo());
        }
        if (this.masterOptions().showDynamicConf()) {
            this.log(this.runShowDynamicConf());
        }
        if (this.masterOptions().upsertDynamicConf()) {
            this.log(this.runUpsertDynamicConf());
        }
        if (this.masterOptions().deleteDynamicConf()) {
            this.log(this.runDeleteDynamicConf());
        }
        if (this.masterOptions().showThreadDump()) {
            this.log(this.runShowThreadDump());
        }
        if (this.masterOptions().reviseLostShuffles()) {
            this.log(this.reviseLostShuffles());
        }
        if (this.masterOptions().deleteApps()) {
            this.log(this.deleteApps());
        }
        if (this.masterOptions().addClusterAlias() != null && new StringOps(Predef$.MODULE$.augmentString(this.masterOptions().addClusterAlias())).nonEmpty()) {
            this.runAddClusterAlias();
        }
        if (this.masterOptions().removeClusterAlias() != null && new StringOps(Predef$.MODULE$.augmentString(this.masterOptions().removeClusterAlias())).nonEmpty()) {
            this.runRemoveClusterAlias();
            return;
        }
    }

    @Override
    public MasterInfoResponse runShowMastersInfo() {
        return this.masterApi().getMasterGroupInfo(this.commonOptions().getAuthHeader());
    }

    @Override
    public ApplicationsHeartbeatResponse runShowClusterApps() {
        return this.applicationApi().getApplications(this.commonOptions().getAuthHeader());
    }

    public ApplicationInfoResponse runShowClusterAppsInfo() {
        return this.applicationApi().getApplicationsInfo(this.commonOptions().getAuthHeader());
    }

    @Override
    public ShufflesResponse runShowClusterShuffles() {
        return this.shuffleApi().getShuffles(this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runExcludeWorkers() {
        List<WorkerId> workerIds = this.getWorkerIds();
        ExcludeWorkerRequest excludeWorkerRequest = new ExcludeWorkerRequest().add(workerIds);
        this.logInfo(new StringBuilder(69).append("Sending exclude worker requests to master for the following workers: ").append(workerIds).toString());
        return this.workerApi().excludeWorker(excludeWorkerRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runRemoveExcludedWorkers() {
        List<WorkerId> workerIds = this.getWorkerIds();
        ExcludeWorkerRequest removeExcludeWorkerRequest = new ExcludeWorkerRequest().remove(workerIds);
        this.logInfo(new StringBuilder(76).append("Sending remove exclude worker requests to master for the following workers: ").append(workerIds).toString());
        return this.workerApi().excludeWorker(removeExcludeWorkerRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runRemoveWorkersUnavailableInfo() {
        List<WorkerId> workerIds = this.getWorkerIds();
        RemoveWorkersUnavailableInfoRequest removeWorkersUnavailableInfoRequest = new RemoveWorkersUnavailableInfoRequest().workers(workerIds);
        this.logInfo(new StringBuilder(86).append("Sending remove workers unavailable info requests to master for the following workers: ").append(workerIds).toString());
        return this.workerApi().removeWorkersUnavailableInfo(removeWorkersUnavailableInfoRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runSendWorkerEvent() {
        SendWorkerEventRequest.EventTypeEnum eventTypeEnum;
        try {
            eventTypeEnum = SendWorkerEventRequest.EventTypeEnum.valueOf((String)this.masterOptions().sendWorkerEvent().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), new StringBuilder(26).append("Worker event type must be ").append(((Stream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SendWorkerEventRequest.EventTypeEnum.values())).toStream().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Stream$.MODULE$.canBuildFrom())).mkString(",")).toString());
        }
        SendWorkerEventRequest.EventTypeEnum eventType = eventTypeEnum;
        List<WorkerId> workerIds = this.getWorkerIds();
        SendWorkerEventRequest sendWorkerEventRequest = new SendWorkerEventRequest().workers(workerIds).eventType(eventType);
        this.logInfo(new StringBuilder(33).append("Sending workerEvent ").append(eventType).append(" to workers: ").append(workerIds).toString());
        return this.workerApi().sendWorkerEvent(sendWorkerEventRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public WorkerEventsResponse runShowWorkerEventInfo() {
        return this.workerApi().getWorkerEvents(this.commonOptions().getAuthHeader());
    }

    @Override
    public Seq<WorkerTimestampData> runShowLostWorkers() {
        Seq lostWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getLostWorkers()).asScala()).toSeq();
        if (lostWorkers.isEmpty()) {
            this.log("No lost workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)lostWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getWorker().getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowExcludedWorkers() {
        Seq excludedWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getExcludedWorkers()).asScala()).toSeq();
        if (excludedWorkers.isEmpty()) {
            this.log("No excluded workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)excludedWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowManualExcludedWorkers() {
        Seq manualExcludedWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getManualExcludedWorkers()).asScala()).toSeq();
        if (manualExcludedWorkers.isEmpty()) {
            this.log("No manual excluded workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)manualExcludedWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowShutdownWorkers() {
        Seq shutdownWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getShutdownWorkers()).asScala()).toSeq();
        if (shutdownWorkers.isEmpty()) {
            this.log("No shutdown workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)shutdownWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowDecommissioningWorkers() {
        Seq decommissioningWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getDecommissioningWorkers()).asScala()).toSeq();
        if (decommissioningWorkers.isEmpty()) {
            this.log("No decommissioning workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)decommissioningWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public HostnamesResponse runShowLifecycleManagers() {
        return this.applicationApi().getApplicationHostNames(this.commonOptions().getAuthHeader());
    }

    @Override
    public WorkersResponse runShowWorkers() {
        return this.workerApi().getWorkers(this.commonOptions().getAuthHeader());
    }

    public TopologyResponse runShowWorkersTopology() {
        return this.workerApi().getWorkersTopology(this.commonOptions().getAuthHeader());
    }

    @Override
    public List<WorkerId> getWorkerIds() {
        String workerIds = this.commonOptions().workerIds();
        if (workerIds == null || workerIds.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Host list must be provided for this command.");
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])workerIds.trim().split(","))).map((Function1 & Serializable & scala.Serializable)workerId -> {
            String[] splitWorkerId = workerId.split(":");
            String host = splitWorkerId[0];
            int rpcPort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[1])).toInt();
            int pushPort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[2])).toInt();
            int fetchPort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[3])).toInt();
            int replicatePort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[4])).toInt();
            return new WorkerId().host(host).rpcPort(Predef$.MODULE$.int2Integer(rpcPort)).pushPort(Predef$.MODULE$.int2Integer(pushPort)).fetchPort(Predef$.MODULE$.int2Integer(fetchPort)).replicatePort(Predef$.MODULE$.int2Integer(replicatePort));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WorkerId.class))))).toList()).asJava();
    }

    @Override
    public ConfResponse runShowConf() {
        return this.confApi().getConf(this.commonOptions().getAuthHeader());
    }

    @Override
    public DynamicConfigResponse runShowDynamicConf() {
        return this.confApi().getDynamicConf(this.commonOptions().configLevel(), this.commonOptions().configTenant(), this.commonOptions().configName(), this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runUpsertDynamicConf() {
        ConfApi confApi = this.confApi();
        return this.upsertDynamicConf(this.commonOptions(), this.spec(), (Function2<UpsertDynamicConfigRequest, Map<String, String>, HandleResponse>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> confApi.upsertDynamicConf(x$1, x$2));
    }

    @Override
    public HandleResponse runDeleteDynamicConf() {
        ConfApi confApi = this.confApi();
        return this.deleteDynamicConf(this.commonOptions(), this.spec(), (Function2<DeleteDynamicConfigRequest, Map<String, String>, HandleResponse>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> confApi.deleteDynamicConf(x$1, x$2));
    }

    @Override
    public ThreadStackResponse runShowThreadDump() {
        return this.defaultApi().getThreadDump(this.commonOptions().getAuthHeader());
    }

    public void runAddClusterAlias() {
        String aliasToAdd = this.masterOptions().addClusterAlias();
        String hosts = this.commonOptions().hostList();
        if (hosts == null || hosts.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Host list must be supplied via --host-list to add to alias.");
        }
        this.cliConfigManager().add(aliasToAdd, hosts);
        this.logInfo(new StringBuilder(80).append("Cluster alias ").append(aliasToAdd).append(" added to ").append(CliConfigManager$.MODULE$.cliConfigFilePath()).append(". You can now use the --cluster").append(" command with this alias.").toString());
    }

    public void runRemoveClusterAlias() {
        String aliasToRemove = this.masterOptions().removeClusterAlias();
        this.cliConfigManager().remove(aliasToRemove);
        this.logInfo(new StringBuilder(23).append("Cluster alias ").append(aliasToRemove).append(" removed.").toString());
    }

    @Override
    public ContainerInfo runShowContainerInfo() {
        return this.defaultApi().getContainerInfo(this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse reviseLostShuffles() {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.commonOptions().apps(), this.reviseLostShuffleOptions().shuffleIds()})) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Application id and Shuffle ids must be provided for this command.");
        }
        String app = this.commonOptions().apps();
        if (app.contains(",")) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Only one application id can be provided for this command.");
        }
        List<Object> shuffleIds = Arrays.asList((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.reviseLostShuffleOptions().shuffleIds().split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> Integer.valueOf(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))));
        ReviseLostShufflesRequest request = new ReviseLostShufflesRequest().appId(app).shuffleIds(shuffleIds);
        return this.applicationApi().reviseLostShuffles(request, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse deleteApps() {
        if (StringUtils.isBlank((CharSequence)this.commonOptions().apps())) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Applications must be provided for this command.");
        }
        List<Object> appIds = Arrays.asList((Object[])this.commonOptions().apps().split(","));
        DeleteAppsRequest request = new DeleteAppsRequest().apps(appIds);
        return this.applicationApi().deleteApps(request, this.commonOptions().getAuthHeader());
    }

    public MasterSubcommandImpl() {
        MasterSubcommand.$init$(this);
    }
}

