/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.congestcontrol;

import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.quota.UserTrafficQuota;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.congestcontrol.BufferStatusHub;
import org.apache.celeborn.service.deploy.worker.congestcontrol.UserBufferInfo;

public class UserCongestionControlContext {
    private volatile boolean congestionControlFlag = false;
    private final UserBufferInfo userBufferInfo;
    private final BufferStatusHub workerBufferStatusHub;
    private final UserIdentifier userIdentifier;
    private volatile UserTrafficQuota userTrafficQuota;

    public UserCongestionControlContext(UserTrafficQuota userTrafficQuota, BufferStatusHub workerBufferStatusHub, UserBufferInfo userBufferInfo, AbstractSource workerSource, UserIdentifier userIdentifier) {
        this.userBufferInfo = userBufferInfo;
        this.userIdentifier = userIdentifier;
        this.workerBufferStatusHub = workerBufferStatusHub;
        this.userTrafficQuota = userTrafficQuota;
        workerSource.addGauge(WorkerSource.USER_PRODUCE_SPEED(), userIdentifier.toJMap(), () -> userBufferInfo.getBufferStatusHub().avgBytesPerSec());
    }

    public void onCongestionControl() {
        this.congestionControlFlag = true;
    }

    public void offCongestionControl() {
        this.congestionControlFlag = false;
    }

    public boolean inCongestionControl() {
        return this.congestionControlFlag;
    }

    public void updateProduceBytes(long numBytes) {
        long timeNow = System.currentTimeMillis();
        BufferStatusHub.BufferStatusNode node = new BufferStatusHub.BufferStatusNode(numBytes);
        this.userBufferInfo.updateInfo(timeNow, node);
        this.workerBufferStatusHub.add(timeNow, (BufferStatusHub.BufferStatusNode)node.clone());
    }

    public UserBufferInfo getUserBufferInfo() {
        return this.userBufferInfo;
    }

    public UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public UserTrafficQuota getUserTrafficQuota() {
        return this.userTrafficQuota;
    }

    public void updateUserTrafficQuota(UserTrafficQuota userTrafficQuota) {
        this.userTrafficQuota = userTrafficQuota;
    }
}

