/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.ssl;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.internal.core.metadata.SniEndPoint;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class SniSslEngineFactory
implements SslEngineFactory {
    private static final int FAKE_PORT_OFFSET = 49152;
    private final SSLContext sslContext;
    private final CopyOnWriteArrayList<String> fakePorts = new CopyOnWriteArrayList();
    private final boolean allowDnsReverseLookupSan;

    public SniSslEngineFactory(SSLContext sslContext) {
        this(sslContext, true);
    }

    public SniSslEngineFactory(SSLContext sslContext, boolean allowDnsReverseLookupSan) {
        this.sslContext = sslContext;
        this.allowDnsReverseLookupSan = allowDnsReverseLookupSan;
    }

    @Override
    @NonNull
    public SSLEngine newSslEngine(@NonNull EndPoint remoteEndpoint) {
        if (!(remoteEndpoint instanceof SniEndPoint)) {
            throw new IllegalArgumentException(String.format("Configuration error: can only use %s with SNI end points", this.getClass().getSimpleName()));
        }
        SniEndPoint sniEndPoint = (SniEndPoint)remoteEndpoint;
        InetSocketAddress address = sniEndPoint.resolve();
        String sniServerName = sniEndPoint.getServerName();
        String peerHost = this.allowDnsReverseLookupSan ? address.getHostName() : address.getHostString();
        SSLEngine engine = this.sslContext.createSSLEngine(peerHost, this.getFakePort(sniServerName));
        engine.setUseClientMode(true);
        SSLParameters parameters = engine.getSSLParameters();
        parameters.setServerNames((List<SNIServerName>)ImmutableList.of((Object)new SNIHostName(sniServerName)));
        parameters.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(parameters);
        return engine;
    }

    private int getFakePort(String sniServerName) {
        this.fakePorts.addIfAbsent(sniServerName);
        return 49152 + this.fakePorts.indexOf(sniServerName);
    }

    @Override
    public void close() {
    }
}

