/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.file.FileStore;
import java.util.function.Consumer;
import org.apache.cassandra.io.util.PathUtils;

public class FileStoreUtils {
    public static long tryGetSpace(FileStore filestore, PathUtils.IOToLongFunction<FileStore> getSpace) {
        return FileStoreUtils.tryGetSpace(filestore, getSpace, ignore -> {});
    }

    public static long tryGetSpace(FileStore filestore, PathUtils.IOToLongFunction<FileStore> getSpace, Consumer<IOException> orElse) {
        try {
            return FileStoreUtils.handleLargeFileSystem(getSpace.apply(filestore));
        }
        catch (IOException e) {
            orElse.accept(e);
            return 0L;
        }
    }

    private FileStoreUtils() {
    }

    private static long handleLargeFileSystem(long size) {
        return size < 0L ? Long.MAX_VALUE : size;
    }
}

