/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	kedav1alpha1 "github.com/apache/camel-k/v2/pkg/apis/duck/keda/v1alpha1"
	scheme "github.com/apache/camel-k/v2/pkg/client/keda/clientset/internalclientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// TriggerAuthenticationsGetter has a method to return a TriggerAuthenticationInterface.
// A group's client should implement this interface.
type TriggerAuthenticationsGetter interface {
	TriggerAuthentications(namespace string) TriggerAuthenticationInterface
}

// TriggerAuthenticationInterface has methods to work with TriggerAuthentication resources.
type TriggerAuthenticationInterface interface {
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kedav1alpha1.TriggerAuthentication, error)
	List(ctx context.Context, opts v1.ListOptions) (*kedav1alpha1.TriggerAuthenticationList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	TriggerAuthenticationExpansion
}

// triggerAuthentications implements TriggerAuthenticationInterface
type triggerAuthentications struct {
	*gentype.ClientWithList[*kedav1alpha1.TriggerAuthentication, *kedav1alpha1.TriggerAuthenticationList]
}

// newTriggerAuthentications returns a TriggerAuthentications
func newTriggerAuthentications(c *KedaV1alpha1Client, namespace string) *triggerAuthentications {
	return &triggerAuthentications{
		gentype.NewClientWithList[*kedav1alpha1.TriggerAuthentication, *kedav1alpha1.TriggerAuthenticationList](
			"triggerauthentications",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kedav1alpha1.TriggerAuthentication { return &kedav1alpha1.TriggerAuthentication{} },
			func() *kedav1alpha1.TriggerAuthenticationList { return &kedav1alpha1.TriggerAuthenticationList{} },
		),
	}
}
