/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform chat operations using Spring AI.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SpringAiChatEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Spring AI Chat component.
     */
    public interface SpringAiChatEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSpringAiChatEndpointBuilder advanced() {
            return (AdvancedSpringAiChatEndpointBuilder) this;
        }

        /**
         * The ChatClient instance to use for chat operations. ChatClient
         * provides advanced features like memory management and advisors. If
         * not provided, a ChatClient will be created from the ChatModel.
         * 
         * The option is a:
         * <code>org.springframework.ai.chat.client.ChatClient</code> type.
         * 
         * Group: producer
         * 
         * @param chatClient the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder chatClient(org.springframework.ai.chat.client.ChatClient chatClient) {
            doSetProperty("chatClient", chatClient);
            return this;
        }
        /**
         * The ChatClient instance to use for chat operations. ChatClient
         * provides advanced features like memory management and advisors. If
         * not provided, a ChatClient will be created from the ChatModel.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.chat.client.ChatClient</code> type.
         * 
         * Group: producer
         * 
         * @param chatClient the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder chatClient(String chatClient) {
            doSetProperty("chatClient", chatClient);
            return this;
        }
        /**
         * The ChatModel instance to use for chat operations. This is used to
         * create a ChatClient if one is not explicitly provided.
         * 
         * The option is a:
         * <code>org.springframework.ai.chat.model.ChatModel</code> type.
         * 
         * Group: producer
         * 
         * @param chatModel the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder chatModel(org.springframework.ai.chat.model.ChatModel chatModel) {
            doSetProperty("chatModel", chatModel);
            return this;
        }
        /**
         * The ChatModel instance to use for chat operations. This is used to
         * create a ChatClient if one is not explicitly provided.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.chat.model.ChatModel</code> type.
         * 
         * Group: producer
         * 
         * @param chatModel the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder chatModel(String chatModel) {
            doSetProperty("chatModel", chatModel);
            return this;
        }
        /**
         * The chat operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.springai.chat.SpringAiChatOperations</code> type.
         * 
         * Required: true
         * Default: CHAT_SINGLE_MESSAGE
         * Group: producer
         * 
         * @param chatOperation the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder chatOperation(org.apache.camel.component.springai.chat.SpringAiChatOperations chatOperation) {
            doSetProperty("chatOperation", chatOperation);
            return this;
        }
        /**
         * The chat operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.springai.chat.SpringAiChatOperations</code> type.
         * 
         * Required: true
         * Default: CHAT_SINGLE_MESSAGE
         * Group: producer
         * 
         * @param chatOperation the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder chatOperation(String chatOperation) {
            doSetProperty("chatOperation", chatOperation);
            return this;
        }
        /**
         * Default system message to set context for the conversation. Can be
         * overridden by the CamelSpringAiChatSystemMessage header.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param systemMessage the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder systemMessage(String systemMessage) {
            doSetProperty("systemMessage", systemMessage);
            return this;
        }
        /**
         * Tags for discovering and calling Camel route tools.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Default user message text for multimodal requests. Can be combined
         * with media data in the message body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param userMessage the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder userMessage(String userMessage) {
            doSetProperty("userMessage", userMessage);
            return this;
        }
        /**
         * Template for formatting RAG (Retrieval Augmented Generation) prompts
         * when augmented data is provided. The template supports two
         * placeholders: {context} for the retrieved documents and {question}
         * for the user's question. Default template is
         * Context:\n{context}\n\nQuestion: {question}.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: Context:\n\{context}\n\nQuestion: \{question}
         * Group: rag
         * 
         * @param ragTemplate the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder ragTemplate(String ragTemplate) {
            doSetProperty("ragTemplate", ragTemplate);
            return this;
        }
        /**
         * Similarity threshold for RAG retrieval (default: 0.7).
         * 
         * The option is a: <code>double</code> type.
         * 
         * Default: 0.7
         * Group: rag
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder similarityThreshold(double similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * Similarity threshold for RAG retrieval (default: 0.7).
         * 
         * The option will be converted to a <code>double</code> type.
         * 
         * Default: 0.7
         * Group: rag
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder similarityThreshold(String similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * Number of top documents to retrieve for RAG (default: 5).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5
         * Group: rag
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder topK(int topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Number of top documents to retrieve for RAG (default: 5).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 5
         * Group: rag
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder topK(String topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * VectorStore for automatic RAG retrieval.
         * 
         * The option is a:
         * <code>org.springframework.ai.vectorstore.VectorStore</code> type.
         * 
         * Group: rag
         * 
         * @param vectorStore the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder vectorStore(org.springframework.ai.vectorstore.VectorStore vectorStore) {
            doSetProperty("vectorStore", vectorStore);
            return this;
        }
        /**
         * VectorStore for automatic RAG retrieval.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.vectorstore.VectorStore</code> type.
         * 
         * Group: rag
         * 
         * @param vectorStore the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder vectorStore(String vectorStore) {
            doSetProperty("vectorStore", vectorStore);
            return this;
        }
        /**
         * Failure response message for SafeGuard advisor when sensitive content
         * is detected. If not specified, a default message will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param safeguardFailureResponse the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder safeguardFailureResponse(String safeguardFailureResponse) {
            doSetProperty("safeguardFailureResponse", safeguardFailureResponse);
            return this;
        }
        /**
         * Comma-separated list of sensitive words for SafeGuard advisor. When
         * provided, the SafeGuard advisor will be enabled to prevent generation
         * of content containing these words.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param safeguardSensitiveWords the value to set
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder safeguardSensitiveWords(String safeguardSensitiveWords) {
            doSetProperty("safeguardSensitiveWords", safeguardSensitiveWords);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Spring AI Chat component.
     */
    public interface AdvancedSpringAiChatEndpointBuilder
            extends
                EndpointProducerBuilder {
        default SpringAiChatEndpointBuilder basic() {
            return (SpringAiChatEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * List of custom advisors to add to the ChatClient. These advisors will
         * be added after the built-in advisors (SimpleLogger, SafeGuard,
         * ChatMemory, QuestionAnswer) in the order they are provided in the
         * list.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.springframework.ai.chat.client.advisor.api.Advisor&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param advisors the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder advisors(List<org.springframework.ai.chat.client.advisor.api.Advisor> advisors) {
            doSetProperty("advisors", advisors);
            return this;
        }
        /**
         * List of custom advisors to add to the ChatClient. These advisors will
         * be added after the built-in advisors (SimpleLogger, SafeGuard,
         * ChatMemory, QuestionAnswer) in the order they are provided in the
         * list.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.springframework.ai.chat.client.advisor.api.Advisor&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param advisors the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder advisors(String advisors) {
            doSetProperty("advisors", advisors);
            return this;
        }
        /**
         * ChatMemory instance for maintaining conversation history across
         * requests. When provided, conversation context will be automatically
         * managed using MessageChatMemoryAdvisor.
         * 
         * The option is a:
         * <code>org.springframework.ai.chat.memory.ChatMemory</code> type.
         * 
         * Group: advanced
         * 
         * @param chatMemory the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder chatMemory(org.springframework.ai.chat.memory.ChatMemory chatMemory) {
            doSetProperty("chatMemory", chatMemory);
            return this;
        }
        /**
         * ChatMemory instance for maintaining conversation history across
         * requests. When provided, conversation context will be automatically
         * managed using MessageChatMemoryAdvisor.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.chat.memory.ChatMemory</code> type.
         * 
         * Group: advanced
         * 
         * @param chatMemory the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder chatMemory(String chatMemory) {
            doSetProperty("chatMemory", chatMemory);
            return this;
        }
        /**
         * VectorStore instance for maintaining conversation history using
         * semantic search. When provided, conversation context will be
         * automatically managed using VectorStoreChatMemoryAdvisor. This is an
         * alternative to chatMemory that uses vector embeddings for long-term
         * memory with semantic retrieval.
         * 
         * The option is a:
         * <code>org.springframework.ai.vectorstore.VectorStore</code> type.
         * 
         * Group: advanced
         * 
         * @param chatMemoryVectorStore the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder chatMemoryVectorStore(org.springframework.ai.vectorstore.VectorStore chatMemoryVectorStore) {
            doSetProperty("chatMemoryVectorStore", chatMemoryVectorStore);
            return this;
        }
        /**
         * VectorStore instance for maintaining conversation history using
         * semantic search. When provided, conversation context will be
         * automatically managed using VectorStoreChatMemoryAdvisor. This is an
         * alternative to chatMemory that uses vector embeddings for long-term
         * memory with semantic retrieval.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.vectorstore.VectorStore</code> type.
         * 
         * Group: advanced
         * 
         * @param chatMemoryVectorStore the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder chatMemoryVectorStore(String chatMemoryVectorStore) {
            doSetProperty("chatMemoryVectorStore", chatMemoryVectorStore);
            return this;
        }
        /**
         * The Java class to use for entity response conversion using
         * ChatClient.entity(Class). When specified, the response will be
         * automatically converted to this type instead of returning a String.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param entityClass the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder entityClass(Class<java.lang.Object> entityClass) {
            doSetProperty("entityClass", entityClass);
            return this;
        }
        /**
         * The Java class to use for entity response conversion using
         * ChatClient.entity(Class). When specified, the response will be
         * automatically converted to this type instead of returning a String.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param entityClass the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder entityClass(String entityClass) {
            doSetProperty("entityClass", entityClass);
            return this;
        }
        /**
         * Maximum file size in bytes for multimodal content (images, audio,
         * PDFs, etc.). Files exceeding this size will be rejected with an
         * exception. Default is 1048576 bytes (1MB). Set to 0 to disable size
         * checking (not recommended).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder maxFileSize(long maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
        /**
         * Maximum file size in bytes for multimodal content (images, audio,
         * PDFs, etc.). Files exceeding this size will be rejected with an
         * exception. Default is 1048576 bytes (1MB). Set to 0 to disable size
         * checking (not recommended).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1048576
         * Group: advanced
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder maxFileSize(String maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
        /**
         * Maximum tokens in the response.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param maxTokens the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder maxTokens(Integer maxTokens) {
            doSetProperty("maxTokens", maxTokens);
            return this;
        }
        /**
         * Maximum tokens in the response.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param maxTokens the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder maxTokens(String maxTokens) {
            doSetProperty("maxTokens", maxTokens);
            return this;
        }
        /**
         * The Java class to use for BEAN output format conversion. Required
         * when outputFormat is BEAN.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder outputClass(Class<java.lang.Object> outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * The Java class to use for BEAN output format conversion. Required
         * when outputFormat is BEAN.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * The output format for structured output conversion (BEAN, MAP, LIST).
         * Used in conjunction with outputClass for BEAN format.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder outputFormat(String outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
        /**
         * A StructuredOutputConverter for converting the chat response to
         * structured output (e.g., BeanOutputConverter, MapOutputConverter,
         * ListOutputConverter). When provided, the converter will be used to
         * transform the response into the desired format.
         * 
         * The option is a:
         * <code>org.springframework.ai.converter.StructuredOutputConverter&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param structuredOutputConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder structuredOutputConverter(org.springframework.ai.converter.StructuredOutputConverter<java.lang.Object> structuredOutputConverter) {
            doSetProperty("structuredOutputConverter", structuredOutputConverter);
            return this;
        }
        /**
         * A StructuredOutputConverter for converting the chat response to
         * structured output (e.g., BeanOutputConverter, MapOutputConverter,
         * ListOutputConverter). When provided, the converter will be used to
         * transform the response into the desired format.
         * 
         * The option will be converted to a
         * <code>org.springframework.ai.converter.StructuredOutputConverter&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param structuredOutputConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder structuredOutputConverter(String structuredOutputConverter) {
            doSetProperty("structuredOutputConverter", structuredOutputConverter);
            return this;
        }
        /**
         * Metadata to attach to system messages. This metadata can be used for
         * tracking system prompt versions, model configurations, or other
         * application-specific data.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param systemMetadata the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder systemMetadata(Map<java.lang.String, java.lang.Object> systemMetadata) {
            doSetProperty("systemMetadata", systemMetadata);
            return this;
        }
        /**
         * Metadata to attach to system messages. This metadata can be used for
         * tracking system prompt versions, model configurations, or other
         * application-specific data.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param systemMetadata the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder systemMetadata(String systemMetadata) {
            doSetProperty("systemMetadata", systemMetadata);
            return this;
        }
        /**
         * Temperature parameter for response randomness (0.0-2.0).
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: advanced
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder temperature(Double temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Temperature parameter for response randomness (0.0-2.0).
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: advanced
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder temperature(String temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Top K parameter for sampling.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         * 
         * @param topKSampling the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder topKSampling(Integer topKSampling) {
            doSetProperty("topKSampling", topKSampling);
            return this;
        }
        /**
         * Top K parameter for sampling.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param topKSampling the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder topKSampling(String topKSampling) {
            doSetProperty("topKSampling", topKSampling);
            return this;
        }
        /**
         * Top P parameter for nucleus sampling.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: advanced
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder topP(Double topP) {
            doSetProperty("topP", topP);
            return this;
        }
        /**
         * Top P parameter for nucleus sampling.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: advanced
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder topP(String topP) {
            doSetProperty("topP", topP);
            return this;
        }
        /**
         * Metadata to attach to user messages. This metadata can be used for
         * tracking conversation context, message identifiers, or other
         * application-specific data.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         * 
         * @param userMetadata the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder userMetadata(Map<java.lang.String, java.lang.Object> userMetadata) {
            doSetProperty("userMetadata", userMetadata);
            return this;
        }
        /**
         * Metadata to attach to user messages. This metadata can be used for
         * tracking conversation context, message identifiers, or other
         * application-specific data.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param userMetadata the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder userMetadata(String userMetadata) {
            doSetProperty("userMetadata", userMetadata);
            return this;
        }
        /**
         * Order of execution for SafeGuard advisor. Lower numbers execute
         * first. Default is 0.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: security (advanced)
         * 
         * @param safeguardOrder the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder safeguardOrder(Integer safeguardOrder) {
            doSetProperty("safeguardOrder", safeguardOrder);
            return this;
        }
        /**
         * Order of execution for SafeGuard advisor. Lower numbers execute
         * first. Default is 0.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: security (advanced)
         * 
         * @param safeguardOrder the value to set
         * @return the dsl builder
         */
        default AdvancedSpringAiChatEndpointBuilder safeguardOrder(String safeguardOrder) {
            doSetProperty("safeguardOrder", safeguardOrder);
            return this;
        }
    }

    public interface SpringAiChatBuilders {
        /**
         * Spring AI Chat (camel-spring-ai-chat)
         * Perform chat operations using Spring AI.
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-chat
         * 
         * @return the dsl builder for the headers' name.
         */
        default SpringAiChatHeaderNameBuilder springAiChat() {
            return SpringAiChatHeaderNameBuilder.INSTANCE;
        }
        /**
         * Spring AI Chat (camel-spring-ai-chat)
         * Perform chat operations using Spring AI.
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-chat
         * 
         * Syntax: <code>spring-ai-chat:chatId</code>
         * 
         * Path parameter: chatId
         * The ID of the chat endpoint
         * 
         * @param path chatId
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder springAiChat(String path) {
            return SpringAiChatEndpointBuilderFactory.endpointBuilder("spring-ai-chat", path);
        }
        /**
         * Spring AI Chat (camel-spring-ai-chat)
         * Perform chat operations using Spring AI.
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-spring-ai-chat
         * 
         * Syntax: <code>spring-ai-chat:chatId</code>
         * 
         * Path parameter: chatId
         * The ID of the chat endpoint
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path chatId
         * @return the dsl builder
         */
        default SpringAiChatEndpointBuilder springAiChat(String componentName, String path) {
            return SpringAiChatEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Spring AI Chat component.
     */
    public static class SpringAiChatHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SpringAiChatHeaderNameBuilder INSTANCE = new SpringAiChatHeaderNameBuilder();

        /**
         * The response from the chat model.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatResponse}.
         */
        public String springAiChatResponse() {
            return "CamelSpringAiChatResponse";
        }
        /**
         * The number of input tokens used.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiInputTokenCount}.
         */
        public String springAiInputTokenCount() {
            return "CamelSpringAiInputTokenCount";
        }
        /**
         * The number of output tokens used.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiOutputTokenCount}.
         */
        public String springAiOutputTokenCount() {
            return "CamelSpringAiOutputTokenCount";
        }
        /**
         * The total number of tokens used.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiTotalTokenCount}.
         */
        public String springAiTotalTokenCount() {
            return "CamelSpringAiTotalTokenCount";
        }
        /**
         * The prompt template with placeholders for variable substitution.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatPromptTemplate}.
         */
        public String springAiChatPromptTemplate() {
            return "CamelSpringAiChatPromptTemplate";
        }
        /**
         * Augmented data for RAG as List.
         * 
         * The option is a: {@code
         * java.util.List<org.springframework.ai.document.Document>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatAugmentedData}.
         */
        public String springAiChatAugmentedData() {
            return "CamelSpringAiChatAugmentedData";
        }
        /**
         * System message for the conversation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatSystemMessage}.
         */
        public String springAiChatSystemMessage() {
            return "CamelSpringAiChatSystemMessage";
        }
        /**
         * Temperature parameter for response randomness (0.0-2.0).
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatTemperature}.
         */
        public String springAiChatTemperature() {
            return "CamelSpringAiChatTemperature";
        }
        /**
         * Maximum tokens in the response.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatMaxTokens}.
         */
        public String springAiChatMaxTokens() {
            return "CamelSpringAiChatMaxTokens";
        }
        /**
         * Top P parameter for nucleus sampling.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatTopP}.
         */
        public String springAiChatTopP() {
            return "CamelSpringAiChatTopP";
        }
        /**
         * Top K parameter for sampling.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatTopK}.
         */
        public String springAiChatTopK() {
            return "CamelSpringAiChatTopK";
        }
        /**
         * User message text for multimodal requests.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatUserMessage}.
         */
        public String springAiChatUserMessage() {
            return "CamelSpringAiChatUserMessage";
        }
        /**
         * Media data for multimodal requests (image or audio).
         * 
         * The option is a: {@code byte[]} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatMediaData}.
         */
        public String springAiChatMediaData() {
            return "CamelSpringAiChatMediaData";
        }
        /**
         * Media type (MIME type) for multimodal requests (e.g., image/png,
         * audio/wav).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatMediaType}.
         */
        public String springAiChatMediaType() {
            return "CamelSpringAiChatMediaType";
        }
        /**
         * The output format type for structured output conversion (BEAN, MAP,
         * LIST).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatOutputFormat}.
         */
        public String springAiChatOutputFormat() {
            return "CamelSpringAiChatOutputFormat";
        }
        /**
         * The Java class to use for structured output bean conversion.
         * 
         * The option is a: {@code Class<?>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatOutputClass}.
         */
        public String springAiChatOutputClass() {
            return "CamelSpringAiChatOutputClass";
        }
        /**
         * The structured output converted from the chat response.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatStructuredOutput}.
         */
        public String springAiChatStructuredOutput() {
            return "CamelSpringAiChatStructuredOutput";
        }
        /**
         * Comma-separated list of sensitive words for SafeGuard advisor.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiChatSafeguardSensitiveWords}.
         */
        public String springAiChatSafeguardSensitiveWords() {
            return "CamelSpringAiChatSafeguardSensitiveWords";
        }
        /**
         * Failure response message for SafeGuard advisor when sensitive content
         * is detected.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringAiChatSafeguardFailureResponse}.
         */
        public String springAiChatSafeguardFailureResponse() {
            return "CamelSpringAiChatSafeguardFailureResponse";
        }
        /**
         * Order of execution for SafeGuard advisor.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatSafeguardOrder}.
         */
        public String springAiChatSafeguardOrder() {
            return "CamelSpringAiChatSafeguardOrder";
        }
        /**
         * List of custom advisors to add to the request.
         * 
         * The option is a: {@code
         * java.util.List<org.springframework.ai.chat.client.advisor.api.Advisor>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatAdvisors}.
         */
        public String springAiChatAdvisors() {
            return "CamelSpringAiChatAdvisors";
        }
        /**
         * The Java class to use for entity response conversion.
         * 
         * The option is a: {@code Class<?>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatEntityClass}.
         */
        public String springAiChatEntityClass() {
            return "CamelSpringAiChatEntityClass";
        }
        /**
         * Metadata to attach to user messages.
         * 
         * The option is a: {@code java.util.Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatUserMetadata}.
         */
        public String springAiChatUserMetadata() {
            return "CamelSpringAiChatUserMetadata";
        }
        /**
         * Metadata to attach to system messages.
         * 
         * The option is a: {@code java.util.Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatSystemMetadata}.
         */
        public String springAiChatSystemMetadata() {
            return "CamelSpringAiChatSystemMetadata";
        }
        /**
         * Conversation ID for managing separate conversation contexts in chat
         * memory.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatConversationId}.
         */
        public String springAiChatConversationId() {
            return "CamelSpringAiChatConversationId";
        }
        /**
         * Maximum file size in bytes for multimodal content. Overrides endpoint
         * configuration.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatMaxFileSize}.
         */
        public String springAiChatMaxFileSize() {
            return "CamelSpringAiChatMaxFileSize";
        }
        /**
         * The reason why the chat response generation stopped (e.g., STOP,
         * LENGTH, TOOL_CALLS).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatFinishReason}.
         */
        public String springAiChatFinishReason() {
            return "CamelSpringAiChatFinishReason";
        }
        /**
         * The name of the AI model used to generate the response.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatModelName}.
         */
        public String springAiChatModelName() {
            return "CamelSpringAiChatModelName";
        }
        /**
         * The unique ID of the chat response.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatResponseId}.
         */
        public String springAiChatResponseId() {
            return "CamelSpringAiChatResponseId";
        }
        /**
         * Full response metadata as a Map containing all available metadata
         * fields.
         * 
         * The option is a: {@code java.util.Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringAiChatResponseMetadata}.
         */
        public String springAiChatResponseMetadata() {
            return "CamelSpringAiChatResponseMetadata";
        }
    }
    static SpringAiChatEndpointBuilder endpointBuilder(String componentName, String path) {
        class SpringAiChatEndpointBuilderImpl extends AbstractEndpointBuilder implements SpringAiChatEndpointBuilder, AdvancedSpringAiChatEndpointBuilder {
            public SpringAiChatEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SpringAiChatEndpointBuilderImpl(path);
    }
}