/*!
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Box, Heading, HStack } from "@chakra-ui/react";
import { useTranslation } from "react-i18next";

import { usePluginServiceGetPlugins } from "openapi/queries";
import { DataTable } from "src/components/DataTable";
import { ErrorAlert } from "src/components/ErrorAlert";

import { PluginImportErrors } from "./Dashboard/Stats/PluginImportErrors";

export const Plugins = () => {
  const { t: translate } = useTranslation(["admin", "common"]);
  const { data, error } = usePluginServiceGetPlugins();

  const columns = [
    {
      accessorKey: "name",
      enableSorting: false,
      header: translate("columns.name"),
    },
    {
      accessorKey: "source",
      enableSorting: false,
      header: translate("plugins.columns.source"),
    },
  ];

  return (
    <Box p={2}>
      <HStack>
        <Heading>{translate("common:admin.Plugins")}</Heading>
        <PluginImportErrors iconOnly />
      </HStack>
      <DataTable
        columns={columns}
        data={data?.plugins ?? []}
        errorMessage={<ErrorAlert error={error} />}
        modelName="common:admin.Plugins"
        showRowCountHeading={false}
        total={data?.total_entries}
      />
    </Box>
  );
};
