/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="4.9.0", label="dataformat,transformation", title="Fory")
@XmlRootElement(name="fory")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ForyDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute(name="unmarshalType")
    @Metadata(description="Class of the java type to use when unmarshalling")
    private String unmarshalTypeName;
    @XmlAttribute
    @Metadata(label="advanced", description="Whether to require register classes", defaultValue="true", javaType="java.lang.Boolean")
    private String requireClassRegistration;
    @XmlAttribute
    @Metadata(label="advanced", description="Whether to use the threadsafe Fory", defaultValue="true", javaType="java.lang.Boolean")
    private String threadSafe;
    @XmlAttribute
    @Metadata(label="advanced", description="Whether to auto-discover Fory from the registry", defaultValue="true", javaType="java.lang.Boolean")
    private String allowAutoWiredFory;

    public ForyDataFormat() {
        super("fory");
    }

    public ForyDataFormat(ForyDataFormat source) {
        super(source);
        this.unmarshalType = source.unmarshalType;
        this.unmarshalTypeName = source.unmarshalTypeName;
        this.requireClassRegistration = source.requireClassRegistration;
        this.threadSafe = source.threadSafe;
        this.allowAutoWiredFory = source.allowAutoWiredFory;
    }

    private ForyDataFormat(Builder builder) {
        this.unmarshalType = builder.unmarshalType;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.requireClassRegistration = builder.requireClassRegistration;
        this.threadSafe = builder.threadSafe;
        this.allowAutoWiredFory = builder.allowAutoWiredFory;
    }

    @Override
    public ForyDataFormat copyDefinition() {
        return new ForyDataFormat(this);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public String getRequireClassRegistration() {
        return this.requireClassRegistration;
    }

    public void setRequireClassRegistration(String requireClassRegistration) {
        this.requireClassRegistration = requireClassRegistration;
    }

    public String getThreadSafe() {
        return this.threadSafe;
    }

    public void setThreadSafe(String threadSafe) {
        this.threadSafe = threadSafe;
    }

    public String getAllowAutoWiredFory() {
        return this.allowAutoWiredFory;
    }

    public void setAllowAutoWiredFory(String allowAutoWiredFory) {
        this.allowAutoWiredFory = allowAutoWiredFory;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<ForyDataFormat> {
        private Class<?> unmarshalType;
        private String unmarshalTypeName;
        private String requireClassRegistration;
        private String threadSafe;
        private String allowAutoWiredFory;

        public Builder unmarshalType(Class<?> value) {
            this.unmarshalType = value;
            return this;
        }

        public Builder unmarshalTypeName(String value) {
            this.unmarshalTypeName = value;
            return this;
        }

        public Builder requireClassRegistration(String value) {
            this.requireClassRegistration = value;
            return this;
        }

        public Builder threadSafe(String value) {
            this.threadSafe = value;
            return this;
        }

        public Builder allowAutoWiredFory(String value) {
            this.allowAutoWiredFory = value;
            return this;
        }

        @Override
        public ForyDataFormat end() {
            return new ForyDataFormat(this);
        }
    }
}

