/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject.support;

import java.util.Map;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.util.ThreadState;

public class SubjectThreadState
implements ThreadState {
    private Map<Object, Object> originalResources;
    private final Subject subject;
    private transient SecurityManager securityManager;

    public SubjectThreadState(Subject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("Subject argument cannot be null.");
        }
        this.subject = subject;
        SecurityManager securityManager = null;
        if (subject instanceof DelegatingSubject) {
            securityManager = ((DelegatingSubject)subject).getSecurityManager();
        }
        if (securityManager == null) {
            securityManager = ThreadContext.getSecurityManager();
        }
        this.securityManager = securityManager;
    }

    protected Subject getSubject() {
        return this.subject;
    }

    @Override
    public void bind() {
        SecurityManager securityManager = this.securityManager;
        if (securityManager == null) {
            securityManager = ThreadContext.getSecurityManager();
        }
        this.originalResources = ThreadContext.getResources();
        ThreadContext.remove();
        ThreadContext.bind(this.subject);
        if (securityManager != null) {
            ThreadContext.bind(securityManager);
        }
    }

    @Override
    public void restore() {
        ThreadContext.remove();
        if (!CollectionUtils.isEmpty(this.originalResources)) {
            ThreadContext.setResources(this.originalResources);
        }
    }

    @Override
    public void clear() {
        ThreadContext.remove();
    }
}

