#! /bin/sh

# Test modinfo extraction: works for *any* endiannes.
for ENDIAN in -le -be; do
for BITNESS in 32 64; do

# Inputs
MODTEST_OVERRIDE1=/lib/modules/$MODTEST_UNAME
MODTEST_OVERRIDE_WITH1=tests/data/$BITNESS$ENDIAN/modinfo
export MODTEST_OVERRIDE1 MODTEST_OVERRIDE_WITH1

MODTEST_OVERRIDE2=/lib/modules/$MODTEST_UNAME/modinfo-$BITNESS.ko
MODTEST_OVERRIDE_WITH2=tests/data/$BITNESS$ENDIAN/modinfo/modinfo-$BITNESS.ko
export MODTEST_OVERRIDE2 MODTEST_OVERRIDE_WITH2

# Test individual field extraction: by module search and abs. path
for file in modinfo-$BITNESS tests/data/$BITNESS$ENDIAN/modinfo/modinfo-$BITNESS.ko; do
    [ "`modinfo -F randomcrap $file`" = "my random crap which I use to test stuff with" ]
    [ "`modinfo -F vermagic $file`" = "my magic" ]
    [ "`modinfo -F author $file`" = "AUTHOR" ]
    [ "`modinfo -F description $file`" = "DESCRIPTION" ]
    [ "`modinfo -F alias $file`" = "ALIAS1
ALIAS2" ] || [ "`modinfo -F alias $file`" = "ALIAS2
ALIAS1" ]
    [ "`modinfo -F parm $file`" = "foo:The number of foos on the card" ]
    [ "`modinfo -F unknown $file`" = "" ]
done

# Test multiple modules on cmdline.
[ "`modinfo -F parm tests/data/$BITNESS$ENDIAN/modinfo/modinfo-$BITNESS.ko tests/data/$BITNESS$ENDIAN/modinfo/modinfo-$BITNESS.ko`" = "foo:The number of foos on the card
foo:The number of foos on the card" ]

# Test 0-fill
[ "`modinfo -0 -F alias tests/data/$BITNESS$ENDIAN/modinfo/modinfo-$BITNESS.ko | tr '\000' @`" = "ALIAS1@ALIAS2@" ]

done
done
