#! /bin/sh
# Loop detection test.

for BITNESS in 32 64; do

# Inputs
MODTEST_OVERRIDE1=/lib/modules/$MODTEST_UNAME
MODTEST_OVERRIDE_WITH1=tests/data/$BITNESS/loop
export MODTEST_OVERRIDE1 MODTEST_OVERRIDE_WITH1

MODTEST_OVERRIDE2=/lib/modules/$MODTEST_UNAME/loop1-$BITNESS.ko
MODTEST_OVERRIDE_WITH2=tests/data/$BITNESS/loop/loop1-$BITNESS.ko
export MODTEST_OVERRIDE2 MODTEST_OVERRIDE_WITH2

MODTEST_OVERRIDE3=/lib/modules/$MODTEST_UNAME/loop2-$BITNESS.ko
MODTEST_OVERRIDE_WITH3=tests/data/$BITNESS/loop/loop2-$BITNESS.ko
export MODTEST_OVERRIDE3 MODTEST_OVERRIDE_WITH3

MODTEST_OVERRIDE4=/lib/modules/$MODTEST_UNAME/loop_dep-$BITNESS.ko
MODTEST_OVERRIDE_WITH4=tests/data/$BITNESS/loop/loop_dep-$BITNESS.ko
export MODTEST_OVERRIDE4 MODTEST_OVERRIDE_WITH4

MODTEST_OVERRIDE5=UNUSED
MODTEST_OVERRIDE_WITH5=UNUSED
export MODTEST_OVERRIDE5 MODTEST_OVERRIDE_WITH5

MODTEST_OVERRIDE6=UNUSED
MODTEST_OVERRIDE_WITH6=UNUSED
export MODTEST_OVERRIDE6 MODTEST_OVERRIDE_WITH6

# Outputs
MODTEST_OVERRIDE7=/lib/modules/$MODTEST_UNAME/modules.dep
MODTEST_OVERRIDE_WITH7=tests/tmp/modules.dep
export MODTEST_OVERRIDE7 MODTEST_OVERRIDE_WITH7

MODTEST_OVERRIDE8=/lib/modules/$MODTEST_UNAME/modules.pcimap
MODTEST_OVERRIDE_WITH8=tests/tmp/modules.pcimap
export MODTEST_OVERRIDE8 MODTEST_OVERRIDE_WITH8

MODTEST_OVERRIDE9=/lib/modules/$MODTEST_UNAME/modules.usbmap
MODTEST_OVERRIDE_WITH9=tests/tmp/modules.usbmap
export MODTEST_OVERRIDE9 MODTEST_OVERRIDE_WITH9

MODTEST_OVERRIDE10=/lib/modules/$MODTEST_UNAME/modules.ccwmap
MODTEST_OVERRIDE_WITH10=tests/tmp/modules.ccwmap
export MODTEST_OVERRIDE10 MODTEST_OVERRIDE_WITH10

MODTEST_OVERRIDE11=/lib/modules/$MODTEST_UNAME/modules.alias
MODTEST_OVERRIDE_WITH11=tests/tmp/modules.alias
export MODTEST_OVERRIDE11 MODTEST_OVERRIDE_WITH11

MODTEST_OVERRIDE12=/lib/modules/$MODTEST_UNAME/modules.symbols
MODTEST_OVERRIDE_WITH12=tests/tmp/modules.symbols
export MODTEST_OVERRIDE12 MODTEST_OVERRIDE_WITH12

MODTEST_OVERRIDE13=/lib/modules/$MODTEST_UNAME/modules.ieee1394map
MODTEST_OVERRIDE_WITH13=tests/tmp/modules.ieee1394map
export MODTEST_OVERRIDE13 MODTEST_OVERRIDE_WITH13

# Expect no normal output.
[ "`depmod 2>tests/tmp/stderr`" = "" ]

# Check results: expect 0 lines (all have loops).
[ `grep -vc '^#' < tests/tmp/modules.dep` = 0 ]

# Now, we should have only one error report, for loop1, and 3
# warnings.
[ `grep -vc '^#' < tests/tmp/stderr` = 4 ]

[ "`grep -w /lib/modules/$MODTEST_UNAME/loop1-$BITNESS.ko\ ignored tests/tmp/stderr`" = "WARNING: Module /lib/modules/$MODTEST_UNAME/loop1-$BITNESS.ko ignored, due to loop" ]
[ "`grep -w /lib/modules/$MODTEST_UNAME/loop2-$BITNESS.ko tests/tmp/stderr`" = "WARNING: Module /lib/modules/$MODTEST_UNAME/loop2-$BITNESS.ko ignored, due to loop" ]
[ "`grep -w /lib/modules/$MODTEST_UNAME/loop_dep-$BITNESS.ko tests/tmp/stderr`" = "WARNING: Module /lib/modules/$MODTEST_UNAME/loop_dep-$BITNESS.ko ignored, due to loop" ]
[ "`grep -w detected tests/tmp/stderr`" = "WARNING: Loop detected: /lib/modules/$MODTEST_UNAME/loop1-$BITNESS.ko needs loop2-$BITNESS.ko which needs loop1-$BITNESS.ko again!" ]

done
