#! /bin/sh
# Test of generation of 32-bit and 64-bit maps

for BITNESS in 32 64; do

# Inputs
MODTEST_OVERRIDE1=/lib/modules/$MODTEST_UNAME
MODTEST_OVERRIDE_WITH1=tests/data/$BITNESS/map
export MODTEST_OVERRIDE1 MODTEST_OVERRIDE_WITH1

MODTEST_OVERRIDE2=/lib/modules/$MODTEST_UNAME/ccw_map-$BITNESS.ko
MODTEST_OVERRIDE_WITH2=tests/data/$BITNESS/map/ccw_map-$BITNESS.ko
export MODTEST_OVERRIDE2 MODTEST_OVERRIDE_WITH2

MODTEST_OVERRIDE3=/lib/modules/$MODTEST_UNAME/pci_map-$BITNESS.ko
MODTEST_OVERRIDE_WITH3=tests/data/$BITNESS/map/pci_map-$BITNESS.ko
export MODTEST_OVERRIDE3 MODTEST_OVERRIDE_WITH3

MODTEST_OVERRIDE4=/lib/modules/$MODTEST_UNAME/usb_map-$BITNESS.ko
MODTEST_OVERRIDE_WITH4=tests/data/$BITNESS/map/usb_map-$BITNESS.ko
export MODTEST_OVERRIDE4 MODTEST_OVERRIDE_WITH4

MODTEST_OVERRIDE5=UNUSED
MODTEST_OVERRIDE_WITH5=UNUSED
export MODTEST_OVERRIDE5 MODTEST_OVERRIDE_WITH5

MODTEST_OVERRIDE6=UNUSED
MODTEST_OVERRIDE_WITH6=UNUSED
export MODTEST_OVERRIDE6 MODTEST_OVERRIDE_WITH6

# Outputs
MODTEST_OVERRIDE7=/lib/modules/$MODTEST_UNAME/modules.dep
MODTEST_OVERRIDE_WITH7=tests/tmp/modules.dep
export MODTEST_OVERRIDE7 MODTEST_OVERRIDE_WITH7

MODTEST_OVERRIDE8=/lib/modules/$MODTEST_UNAME/modules.pcimap
MODTEST_OVERRIDE_WITH8=tests/tmp/modules.pcimap
export MODTEST_OVERRIDE8 MODTEST_OVERRIDE_WITH8

MODTEST_OVERRIDE9=/lib/modules/$MODTEST_UNAME/modules.usbmap
MODTEST_OVERRIDE_WITH9=tests/tmp/modules.usbmap
export MODTEST_OVERRIDE9 MODTEST_OVERRIDE_WITH9

MODTEST_OVERRIDE10=/lib/modules/$MODTEST_UNAME/modules.ccwmap
MODTEST_OVERRIDE_WITH10=tests/tmp/modules.ccwmap
export MODTEST_OVERRIDE10 MODTEST_OVERRIDE_WITH10

MODTEST_OVERRIDE11=/lib/modules/$MODTEST_UNAME/modules.alias
MODTEST_OVERRIDE_WITH11=tests/tmp/modules.alias
export MODTEST_OVERRIDE11 MODTEST_OVERRIDE_WITH11

MODTEST_OVERRIDE12=/lib/modules/$MODTEST_UNAME/modules.symbols
MODTEST_OVERRIDE_WITH12=tests/tmp/modules.symbols
export MODTEST_OVERRIDE12 MODTEST_OVERRIDE_WITH12

# Expect no output.
[ "`depmod`" = "" ]

# Check PCI: expect 2 lines
[ `grep -vc '^#' < tests/tmp/modules.pcimap` = 2 ]

[ "`grep pci_map tests/tmp/modules.pcimap`" = "pci_map-$BITNESS           0x00000001 0x00000002 0x00000003 0x00000004 0x00000005 0x00000006 0x0
pci_map-$BITNESS           0x0000000b 0x0000000c 0x0000000d 0x0000000e 0x0000000f 0x00000010 0x0" ]

# Check USB: expect 2 lines
[ `grep -vc '^#' < tests/tmp/modules.usbmap` = 2 ]

[ "`grep usb_map tests/tmp/modules.usbmap`" = "usb_map-$BITNESS           0x0001      0x0002   0x0003    0x0004       0x0005       0x06         0x07            0x08            0x09            0x0a               0x0b               0x0
usb_map-$BITNESS           0x000b      0x000c   0x000d    0x000e       0x000f       0x10         0x11            0x12            0x13            0x14               0x15               0x0" ]

# Check CCW: expect 2 lines
[ `grep -vc '^#' < tests/tmp/modules.ccwmap` = 2 ]

[ "`grep ccw_map tests/tmp/modules.ccwmap`" = "ccw_map-$BITNESS           0x000f      0x0001  0x03      0x0002  0x04
ccw_map-$BITNESS           0x000f      0x000b  0x0d      0x000c  0x0e" ]

mv tests/tmp/modules.dep tests/tmp/modules.dep.old
mv tests/tmp/modules.pcimap tests/tmp/modules.pcimap.old
mv tests/tmp/modules.usbmap tests/tmp/modules.usbmap.old
mv tests/tmp/modules.ccwmap tests/tmp/modules.ccwmap.old

# Synonyms
[ "`depmod -a`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep
diff -u tests/tmp/modules.pcimap.old tests/tmp/modules.pcimap
diff -u tests/tmp/modules.usbmap.old tests/tmp/modules.usbmap
diff -u tests/tmp/modules.ccwmap.old tests/tmp/modules.ccwmap
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
mv tests/tmp/modules.pcimap tests/tmp/modules.pcimap.old
mv tests/tmp/modules.usbmap tests/tmp/modules.usbmap.old
mv tests/tmp/modules.ccwmap tests/tmp/modules.ccwmap.old

[ "`depmod -A`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep
diff -u tests/tmp/modules.pcimap.old tests/tmp/modules.pcimap
diff -u tests/tmp/modules.usbmap.old tests/tmp/modules.usbmap
diff -u tests/tmp/modules.ccwmap.old tests/tmp/modules.ccwmap
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
mv tests/tmp/modules.pcimap tests/tmp/modules.pcimap.old
mv tests/tmp/modules.usbmap tests/tmp/modules.usbmap.old
mv tests/tmp/modules.ccwmap tests/tmp/modules.ccwmap.old

[ "`depmod -e -A`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep
diff -u tests/tmp/modules.pcimap.old tests/tmp/modules.pcimap
diff -u tests/tmp/modules.usbmap.old tests/tmp/modules.usbmap
diff -u tests/tmp/modules.ccwmap.old tests/tmp/modules.ccwmap
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
mv tests/tmp/modules.pcimap tests/tmp/modules.pcimap.old
mv tests/tmp/modules.usbmap tests/tmp/modules.usbmap.old
mv tests/tmp/modules.ccwmap tests/tmp/modules.ccwmap.old

[ "`depmod -e -A $MODTEST_VERSION`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep
diff -u tests/tmp/modules.pcimap.old tests/tmp/modules.pcimap
diff -u tests/tmp/modules.usbmap.old tests/tmp/modules.usbmap
diff -u tests/tmp/modules.ccwmap.old tests/tmp/modules.ccwmap
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
mv tests/tmp/modules.pcimap tests/tmp/modules.pcimap.old
mv tests/tmp/modules.usbmap tests/tmp/modules.usbmap.old
mv tests/tmp/modules.ccwmap tests/tmp/modules.ccwmap.old

# We expect the same from -n.
grep -hv '^#' tests/tmp/modules.dep.old tests/tmp/modules.pcimap.old tests/tmp/modules.usbmap.old tests/tmp/modules.ccwmap.old > tests/tmp/out

# Stdout versions.
depmod -n | grep -v '^#' > tests/tmp/stdout
diff -u tests/tmp/out tests/tmp/stdout

depmod -a -n | grep -v '^#' > tests/tmp/modules.dep
diff -u tests/tmp/out tests/tmp/stdout

depmod -n -a $MODTEST_VERSION | grep -v '^#' > tests/tmp/modules.dep
diff -u tests/tmp/out tests/tmp/stdout

depmod -e -n -A $MODTEST_VERSION | grep -v '^#' > tests/tmp/modules.dep
diff -u tests/tmp/out tests/tmp/stdout

done
