#! /bin/sh
# Simple tests of generation of 32-bit and 64-bit modules.dep

for BITNESS in 32 64; do

# Inputs
MODTEST_OVERRIDE1=/lib/modules/$MODTEST_UNAME
MODTEST_OVERRIDE_WITH1=tests/data/$BITNESS/normal
export MODTEST_OVERRIDE1 MODTEST_OVERRIDE_WITH1

MODTEST_OVERRIDE2=/lib/modules/$MODTEST_UNAME/export_dep-$BITNESS.ko
MODTEST_OVERRIDE_WITH2=tests/data/$BITNESS/normal/export_dep-$BITNESS.ko
export MODTEST_OVERRIDE2 MODTEST_OVERRIDE_WITH2

MODTEST_OVERRIDE3=/lib/modules/$MODTEST_UNAME/noexport_dep-$BITNESS.ko
MODTEST_OVERRIDE_WITH3=tests/data/$BITNESS/normal/noexport_dep-$BITNESS.ko
export MODTEST_OVERRIDE3 MODTEST_OVERRIDE_WITH3

MODTEST_OVERRIDE4=/lib/modules/$MODTEST_UNAME/noexport_nodep-$BITNESS.ko
MODTEST_OVERRIDE_WITH4=tests/data/$BITNESS/normal/noexport_nodep-$BITNESS.ko
export MODTEST_OVERRIDE4 MODTEST_OVERRIDE_WITH4

MODTEST_OVERRIDE5=/lib/modules/$MODTEST_UNAME/export_nodep-$BITNESS.ko
MODTEST_OVERRIDE_WITH5=tests/data/$BITNESS/normal/export_nodep-$BITNESS.ko
export MODTEST_OVERRIDE5 MODTEST_OVERRIDE_WITH5

MODTEST_OVERRIDE6=/lib/modules/$MODTEST_UNAME/noexport_doubledep-$BITNESS.ko
MODTEST_OVERRIDE_WITH6=tests/data/$BITNESS/normal/noexport_doubledep-$BITNESS.ko
export MODTEST_OVERRIDE6 MODTEST_OVERRIDE_WITH6

# Outputs
MODTEST_OVERRIDE7=/lib/modules/$MODTEST_UNAME/modules.dep
MODTEST_OVERRIDE_WITH7=tests/tmp/modules.dep
export MODTEST_OVERRIDE7 MODTEST_OVERRIDE_WITH7

MODTEST_OVERRIDE8=/lib/modules/$MODTEST_UNAME/modules.pcimap
MODTEST_OVERRIDE_WITH8=tests/tmp/modules.pcimap
export MODTEST_OVERRIDE8 MODTEST_OVERRIDE_WITH8

MODTEST_OVERRIDE9=/lib/modules/$MODTEST_UNAME/modules.usbmap
MODTEST_OVERRIDE_WITH9=tests/tmp/modules.usbmap
export MODTEST_OVERRIDE9 MODTEST_OVERRIDE_WITH9

MODTEST_OVERRIDE10=/lib/modules/$MODTEST_UNAME/modules.ccwmap
MODTEST_OVERRIDE_WITH10=tests/tmp/modules.ccwmap
export MODTEST_OVERRIDE10 MODTEST_OVERRIDE_WITH10

MODTEST_OVERRIDE11=/lib/modules/$MODTEST_UNAME/modules.alias
MODTEST_OVERRIDE_WITH11=tests/tmp/modules.alias
export MODTEST_OVERRIDE11 MODTEST_OVERRIDE_WITH11

MODTEST_OVERRIDE12=/lib/modules/$MODTEST_UNAME/modules.symbols
MODTEST_OVERRIDE_WITH12=tests/tmp/modules.symbols
export MODTEST_OVERRIDE12 MODTEST_OVERRIDE_WITH12

# Expect no output.
[ "`depmod 2>&1`" = "" ]

# Check modules.dep results: expect 5 lines
[ `grep -vc '^#' < tests/tmp/modules.dep` = 5 ]

[ "`grep -w export_dep-$BITNESS.ko: tests/tmp/modules.dep`" = "/lib/modules/$MODTEST_UNAME/export_dep-$BITNESS.ko: /lib/modules/$MODTEST_UNAME/export_nodep-$BITNESS.ko" ]
[ "`grep -w noexport_dep-$BITNESS.ko: tests/tmp/modules.dep`" = "/lib/modules/$MODTEST_UNAME/noexport_dep-$BITNESS.ko: /lib/modules/$MODTEST_UNAME/export_nodep-$BITNESS.ko" ]
[ "`grep -w export_nodep-$BITNESS.ko: tests/tmp/modules.dep`" = "/lib/modules/$MODTEST_UNAME/export_nodep-$BITNESS.ko:" ]
[ "`grep -w noexport_nodep-$BITNESS.ko: tests/tmp/modules.dep`" = "/lib/modules/$MODTEST_UNAME/noexport_nodep-$BITNESS.ko:" ]
[ "`grep -w noexport_doubledep-$BITNESS.ko: tests/tmp/modules.dep`" = "/lib/modules/$MODTEST_UNAME/noexport_doubledep-$BITNESS.ko: /lib/modules/$MODTEST_UNAME/export_dep-$BITNESS.ko /lib/modules/$MODTEST_UNAME/export_nodep-$BITNESS.ko" ]

# Check modules.symbols results: expect 3 lines
[ `grep -vc '^#' < tests/tmp/modules.symbols` = 3 ]

[ "`grep -w symbol:exported1 tests/tmp/modules.symbols`" = "alias symbol:exported1 export_nodep_$BITNESS" ]
[ "`grep -w symbol:exported2 tests/tmp/modules.symbols`" = "alias symbol:exported2 export_nodep_$BITNESS" ]
[ "`grep -w symbol:exported3 tests/tmp/modules.symbols`" = "alias symbol:exported3 export_dep_$BITNESS" ]

mv tests/tmp/modules.dep tests/tmp/modules.dep.old
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

# Synonyms
[ "`depmod -a`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod -A`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod -e -A`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod -e -A $MODTEST_VERSION`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod --all`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod --quick`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod -e --quick`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod -e --quick $MODTEST_VERSION`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod --errsyms --quick`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

[ "`depmod --errsyms --quick $MODTEST_VERSION`" = "" ]
diff -u tests/tmp/modules.dep.old tests/tmp/modules.dep >/dev/null
mv tests/tmp/modules.dep tests/tmp/modules.dep.old
diff -u tests/tmp/modules.symbols.old tests/tmp/modules.symbols >/dev/null
mv tests/tmp/modules.symbols tests/tmp/modules.symbols.old

# Combined should form stdout versions.
grep -vh '^#' tests/tmp/modules.dep.old tests/tmp/modules.symbols.old > tests/tmp/modules.all.old

# Stdout versions.
depmod -n | grep -v '^#' > tests/tmp/modules.all
diff -u tests/tmp/modules.all.old tests/tmp/modules.all >/dev/null
mv tests/tmp/modules.all tests/tmp/modules.all.old

depmod -a -n | grep -v '^#' > tests/tmp/modules.all
diff -u tests/tmp/modules.all.old tests/tmp/modules.all >/dev/null
mv tests/tmp/modules.all tests/tmp/modules.all.old

depmod -n -a $MODTEST_VERSION | grep -v '^#' > tests/tmp/modules.all
diff -u tests/tmp/modules.all.old tests/tmp/modules.all >/dev/null
mv tests/tmp/modules.all tests/tmp/modules.all.old

depmod -e -n -A $MODTEST_VERSION | grep -v '^#' > tests/tmp/modules.all
diff -u tests/tmp/modules.all.old tests/tmp/modules.all >/dev/null
mv tests/tmp/modules.all tests/tmp/modules.all.old

done
