#include <string.h>
#include <stdio.h>
#include "depmod.h"
#include "tables.h"

/* Turn /lib/modules/2.5.49/kernel/foo.o => foo */
static void make_shortname(char *dest, const char *src)
{
	char *ext;
	const char *slash;

	slash = strrchr(src, '/') ?: src-1;
	strcpy(dest, slash + 1);
	ext = strrchr(dest, '.');
	if (ext)
		*ext = '\0';
}

/* We set driver_data to zero */
static void output_pci_entry(struct pci_device_id *pci, char *name, FILE *out)
{
	fprintf(out,
		"%-20s 0x%08x 0x%08x 0x%08x 0x%08x 0x%08x 0x%08x 0x0\n",
		name,
		pci->vendor,
		pci->device,
		pci->subvendor,
		pci->subdevice,
		pci->class,
		pci->class_mask);
}

void output_pci_table(struct module *modules, FILE *out)
{
	struct module *i;

	fprintf(out, "# pci module         vendor     device     subvendor"
		"  subdevice  class      class_mask driver_data\n");

	for (i = modules; i; i = i->next) {
		struct pci_device_id *e;
		char shortname[strlen(i->pathname) + 1];

		if (!i->pci_table)
			continue;

		make_shortname(shortname, i->pathname);
		for (e = i->pci_table; e->vendor; e = (void *)e + i->pci_size)
			output_pci_entry(e, shortname, out);
	}
}

/* We set driver_info to zero */
static void output_usb_entry(struct usb_device_id *usb, char *name, FILE *out)
{
	fprintf(out, "%-20s 0x%04x      0x%04x   0x%04x    0x%04x"
		"       0x%04x       0x%02x         0x%02x"
		"            0x%02x            0x%02x"
		"            0x%02x               0x%02x"
		"               0x0\n",
		name,
		usb->match_flags,
		usb->idVendor,
		usb->idProduct,
		usb->bcdDevice_lo,
		usb->bcdDevice_hi,
		usb->bDeviceClass,
		usb->bDeviceSubClass,
		usb->bDeviceProtocol,
		usb->bInterfaceClass,
		usb->bInterfaceSubClass,
		usb->bInterfaceProtocol);
}
		
void output_usb_table(struct module *modules, FILE *out)
{
	struct module *i;

	fprintf(out, "# usb module         ");
	/* Requires all users to be on kernel 2.4.0 or later */
	fprintf(out, "match_flags ");
	fprintf(out, "idVendor idProduct bcdDevice_lo bcdDevice_hi"
		" bDeviceClass bDeviceSubClass bDeviceProtocol"
		" bInterfaceClass bInterfaceSubClass"
		" bInterfaceProtocol driver_info\n");

	for (i = modules; i; i = i->next) {
		struct usb_device_id *e;
		char shortname[strlen(i->pathname) + 1];

		if (!i->usb_table)
			continue;

		make_shortname(shortname, i->pathname);
		for (e = i->usb_table; 
		     e->idVendor || e->bDeviceClass || e->bInterfaceClass;
		     e = (void *)e + i->usb_size)
			output_usb_entry(e, shortname, out);
	}
}
		
	
