/* Simple backwards compat code to exec old version */

#ifndef CONFIG_NO_BACKWARDS_COMPAT
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <asm/unistd.h>

_syscall5(int, query_module, const char *, name, int, which,
	  void *, buf, size_t, bufsize, size_t *, ret);

static void exec_old(const char *progname, char *argv[])
{
	char *sep;
	char pathname[strlen(argv[0])+1];
	char oldname[strlen(progname) + strlen(argv[0]) + sizeof(".old")];

	memset(pathname, 0, strlen(argv[0])+1);
	sep = strrchr(argv[0], '/');
	if (sep)
		memcpy(pathname, argv[0], sep - argv[0]+1);
	sprintf(oldname, "%s%s.old", pathname, progname);

	/* Recursion detection: we need an env var since we can't
	   change argv[0] (as older modutils uses it to determine
	   behavior). */
	if (getenv("MODULE_RECURSE"))
		return;
	setenv("MODULE_RECURSE", "y", 0);

	execvp(oldname, argv);
	fprintf(stderr,
		"Kernel requires old %s, but couldn't run %s: %s\n",
		progname, oldname, strerror(errno));
	exit(2);
}

static void try_old_version(const char *progname, char *argv[])
{
	struct stat buf;
	/* 2.2 and 2.4 have a syscall.  2.0 doesn't, but does have
           /proc/ksyms */
	if (query_module(NULL, 0, NULL, 0, NULL) == 0
	    || stat("/proc/ksyms", &buf) == 0)
		exec_old(progname, argv);
}
#else /* CONFIG_NO_BACKWARDS_COMPAT */
static inline void try_old_version(const char *progname, char *argv[])
{
}
#endif /* !CONFIG_NO_BACKWARDS_COMPAT */
