struct kernel_symbol32 {
	char value[4];
	char name[64 - 4];
};

struct kernel_symbol64 {
	char value[8];
	char name[64 - 8];
};

/* All the modules kept in this list */
struct module
{
	struct module *next;

	/* mmaped export symbols area */
	unsigned int num_exports;
	union {
		struct kernel_symbol32 *exports32;
		struct kernel_symbol64 *exports64;
		void *ptr;
	} u;

	/* What order it has to be loaded (0 = never). */
	unsigned int order;

	/* full path name */
	char name[0];
};

struct alias
{
	struct alias *next;
	/* One of these two is set. */
	struct module *module;
	struct alias *alias;
	/* Line in config where this was defined */
	int config_line;
	char name[0];
};

struct mod_ops {
	struct module *(*add_module)(int fd, struct module *new,
				     struct module *last,
				     struct alias **aliases);
	void *(*load_section)(int fd, unsigned long shdroff,
			      unsigned int num_secs,
			      unsigned int secnamesec,
			      const char *secname,
			      unsigned long *size);
	void *(*map_exports)(int fd,
			     unsigned long shdroff,
			     unsigned int num_secs,
			     unsigned int secnamesec,
			     const char *name,
			     unsigned int *num_exports);
	int (*export_name_cmp)(struct module *m, int index, const char *name);
	int (*get_deps)(unsigned int order,
			const char *dirname,
			const char *modname,
			struct module *modules,
			int verbose);
};

#define MODULE_EXTENSION ".o"
