/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import com.google.gwt.dev.js.rhino.CodePosition;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrAttribute;
import org.jetbrains.kotlin.ir.IrAttributeKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.backend.js.lower.PropertyLazyInitLowering;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.InitFunVisitor;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\"\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\"3\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"translateJsCodeIntoStatementList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "code", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "sourceInfo", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "<set-?>", "lazyInitializerExpression", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getLazyInitializerExpression", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "setLazyInitializerExpression", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "lazyInitializerExpression$delegate", "Lorg/jetbrains/kotlin/ir/IrAttribute;", "foldString", "", "expression", "backend.js"})
@SourceDebugExtension(value={"SMAP\njsCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jsCode.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsCodeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IrAttribute.kt\norg/jetbrains/kotlin/ir/IrAttribute\n*L\n1#1,147:1\n1#2:148\n112#3,7:149\n*S KotlinDebug\n*F\n+ 1 jsCode.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsCodeKt\n*L\n66#1:149,7\n*E\n"})
public final class JsCodeKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final IrAttribute lazyInitializerExpression$delegate;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<JsStatement> translateJsCodeIntoStatementList(@NotNull IrExpression code, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(container, "container");
        IrExpression irExpression = code;
        JsLocation jsLocation = JsAstUtilsKt.getStartSourceLocation((IrElement)code, container);
        if (jsLocation == null) {
            IrFileEntry irFileEntry = IrInlineUtilsKt.getSourceFile(container);
            if (irFileEntry != null) {
                void it;
                IrFileEntry irFileEntry2 = irFileEntry;
                IrExpression irExpression2 = irExpression;
                boolean bl = false;
                jsLocation = new JsLocation(it.getName(), 0, 0, null, 8, null);
                irExpression = irExpression2;
            } else {
                jsLocation = null;
            }
        }
        return JsCodeKt.translateJsCodeIntoStatementList(irExpression, jsLocation);
    }

    @Nullable
    public static final List<JsStatement> translateJsCodeIntoStatementList(@NotNull IrExpression code, @NotNull IrFileEntry fileEntry) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(fileEntry, "fileEntry");
        JsLocation jsLocation = JsAstUtilsKt.getStartSourceLocation((IrElement)code, fileEntry);
        if (jsLocation == null) {
            jsLocation = new JsLocation(fileEntry.getName(), 0, 0, null, 8, null);
        }
        return JsCodeKt.translateJsCodeIntoStatementList(code, jsLocation);
    }

    private static final List<JsStatement> translateJsCodeIntoStatementList(IrExpression code, JsLocation sourceInfo) {
        JsLocation jsLocation = sourceInfo;
        if (jsLocation == null) {
            jsLocation = new JsLocation("<js-code>", 0, 0, null, 8, null);
        }
        JsLocation jsLocation2 = jsLocation;
        String fileName = jsLocation2.component1();
        int startLine = jsLocation2.component2();
        int offset = jsLocation2.component3();
        String string = JsCodeKt.foldString(code);
        if (string == null) {
            return null;
        }
        String jsCode = string;
        JsRootScope temporaryRootScope = new JsRootScope(new JsProgram());
        JsFunctionScope currentScope = new JsFunctionScope(temporaryRootScope, "js");
        return ParserUtilsKt.parseExpressionOrStatement(jsCode, ThrowExceptionOnErrorReporter.INSTANCE, currentScope, new CodePosition(startLine, offset), fileName);
    }

    /*
     * WARNING - void declaration
     */
    private static final IrExpression getLazyInitializerExpression(IrField $this$lazyInitializerExpression) {
        void this_$iv;
        void thisRef$iv;
        IrAttribute irAttribute = lazyInitializerExpression$delegate;
        IrElement irElement = $this$lazyInitializerExpression;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (IrExpression)IrAttributeKt.get(thisRef$iv, this_$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final void setLazyInitializerExpression(IrField $this$lazyInitializerExpression, IrExpression irExpression) {
        void this_$iv;
        void thisRef$iv;
        IrAttribute irAttribute = lazyInitializerExpression$delegate;
        IrElement irElement = $this$lazyInitializerExpression;
        Object var4_4 = null;
        IrExpression value$iv = irExpression;
        boolean $i$f$setValue = false;
        IrAttributeKt.set(thisRef$iv, this_$iv, value$iv);
    }

    private static final String foldString(IrExpression expression2) {
        StringBuilder builder = new StringBuilder();
        Ref.BooleanRef foldingFailed = new Ref.BooleanRef();
        IrVisitorsKt.acceptVoid((IrElement)expression2, new IrVisitorVoid(foldingFailed, builder){
            final /* synthetic */ Ref.BooleanRef $foldingFailed;
            final /* synthetic */ StringBuilder $builder;
            {
                this.$foldingFailed = $foldingFailed;
                this.$builder = $builder;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                this.$foldingFailed.element = true;
            }

            public void visitGetValue(IrGetValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrVisitorsKt.acceptVoid((IrElement)expression2.getSymbol().getOwner(), this);
            }

            public void visitVariable(IrVariable declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                IrExpression irExpression = declaration.getInitializer();
                if (irExpression != null) {
                    IrExpression it = irExpression;
                    boolean bl = false;
                    IrVisitorsKt.acceptVoid((IrElement)it, this);
                    return;
                }
                super.visitVariable(declaration);
            }

            public void visitGetField(IrGetField expression2) {
                IrElementBase irElementBase;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrField owner = (IrField)expression2.getSymbol().getOwner();
                IrElementBase irElementBase2 = owner.getInitializer();
                if (irElementBase2 == null || (irElementBase2 = irElementBase2.getExpression()) == null) {
                    irElementBase2 = JsCodeKt.access$getLazyInitializerExpression(owner);
                }
                if ((irElementBase = irElementBase2) != null) {
                    IrVisitorsKt.acceptVoid((IrElement)irElementBase, this);
                }
            }

            public void visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrSimpleFunction owner = (IrSimpleFunction)expression2.getSymbol().getOwner();
                IrPropertySymbol propertySymbol = owner.getCorrespondingPropertySymbol();
                if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.Companion.getPLUS())) {
                    IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
                } else if (Intrinsics.areEqual(expression2.getOrigin(), PropertyLazyInitLowering.Companion.getPROPERTY_INIT_FUN_CALL())) {
                    IrBody irBody = owner.getBody();
                    if (irBody != null) {
                        IrVisitorsKt.acceptChildrenVoid((IrElement)irBody, new InitFunVisitor());
                    }
                    IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
                } else if (propertySymbol != null && Intrinsics.areEqual(owner, ((IrProperty)propertySymbol.getOwner()).getGetter())) {
                    if (((IrProperty)propertySymbol.getOwner()).isConst()) {
                        IrExpressionBody initializer;
                        IrField irField = ((IrProperty)propertySymbol.getOwner()).getBackingField();
                        IrExpressionBody irExpressionBody = initializer = irField != null ? irField.getInitializer() : null;
                        if (initializer != null) {
                            IrVisitorsKt.acceptChildrenVoid((IrElement)initializer, this);
                        } else {
                            this.$foldingFailed.element = true;
                        }
                    } else {
                        IrBody irBody = owner.getBody();
                        if (irBody != null) {
                            IrVisitorsKt.acceptChildrenVoid((IrElement)irBody, this);
                        }
                    }
                    IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
                } else {
                    super.visitCall(expression2);
                }
            }

            public void visitReturn(IrReturn expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
            }

            public void visitConst(IrConst expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.$builder.append(expression2.getValue());
            }

            public void visitStringConcatenation(IrStringConcatenation expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
            }
        });
        if (foldingFailed.element) {
            return null;
        }
        return builder.toString();
    }

    public static final /* synthetic */ void access$setLazyInitializerExpression(IrField $receiver, IrExpression irExpression) {
        JsCodeKt.setLazyInitializerExpression($receiver, irExpression);
    }

    public static final /* synthetic */ IrExpression access$getLazyInitializerExpression(IrField $receiver) {
        return JsCodeKt.getLazyInitializerExpression($receiver);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(JsCodeKt.class, "lazyInitializerExpression", "getLazyInitializerExpression(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", 1))};
        $$delegatedProperties = kPropertyArray;
        lazyInitializerExpression$delegate = IrAttributeKt.irAttribute(false).provideDelegate(null, $$delegatedProperties[0]);
    }
}

