﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/logs/CloudWatchLogs_EXPORTS.h>
#include <aws/logs/model/IntegrationStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchLogs {
namespace Model {
class PutIntegrationResult {
 public:
  AWS_CLOUDWATCHLOGS_API PutIntegrationResult() = default;
  AWS_CLOUDWATCHLOGS_API PutIntegrationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLOUDWATCHLOGS_API PutIntegrationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the integration that you just created.</p>
   */
  inline const Aws::String& GetIntegrationName() const { return m_integrationName; }
  template <typename IntegrationNameT = Aws::String>
  void SetIntegrationName(IntegrationNameT&& value) {
    m_integrationNameHasBeenSet = true;
    m_integrationName = std::forward<IntegrationNameT>(value);
  }
  template <typename IntegrationNameT = Aws::String>
  PutIntegrationResult& WithIntegrationName(IntegrationNameT&& value) {
    SetIntegrationName(std::forward<IntegrationNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the integration that you just created.</p> <p>After you create
   * an integration, it takes a few minutes to complete. During this time, you'll see
   * the status as <code>PROVISIONING</code>.</p>
   */
  inline IntegrationStatus GetIntegrationStatus() const { return m_integrationStatus; }
  inline void SetIntegrationStatus(IntegrationStatus value) {
    m_integrationStatusHasBeenSet = true;
    m_integrationStatus = value;
  }
  inline PutIntegrationResult& WithIntegrationStatus(IntegrationStatus value) {
    SetIntegrationStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutIntegrationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_integrationName;

  IntegrationStatus m_integrationStatus{IntegrationStatus::NOT_SET};

  Aws::String m_requestId;
  bool m_integrationNameHasBeenSet = false;
  bool m_integrationStatusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchLogs
}  // namespace Aws
