/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.preferences.BundleStateScopeServiceFactory;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.OSGiPreferencesServiceManager;
import org.eclipse.core.internal.preferences.PreferenceServiceRegistryHelper;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<Object, Object> {
    public static final String PI_PREFERENCES = "org.eclipse.equinox.preferences";
    private static final String PROP_REGISTER_PERF_SERVICE = "eclipse.service.pref";
    private static final String PROP_CUSTOMIZATION = "eclipse.pluginCustomization";
    private ServiceTracker<?, ?> registryServiceTracker;
    private static BundleContext bundleContext;
    private ServiceRegistration<IPreferencesService> preferencesService;
    private ServiceRegistration<org.osgi.service.prefs.PreferencesService> osgiPreferencesService;
    private ServiceTracker<?, ?> locationTracker;

    public void start(final BundleContext context) throws Exception {
        boolean shouldRegister;
        bundleContext = context;
        PreferencesOSGiUtils.getDefault().openServices();
        this.processCommandLine();
        boolean bl = shouldRegister = !"false".equalsIgnoreCase(context.getProperty(PROP_REGISTER_PERF_SERVICE));
        if (shouldRegister) {
            this.preferencesService = bundleContext.registerService(IPreferencesService.class, (Object)PreferencesService.getDefault(), new Hashtable());
            this.osgiPreferencesService = bundleContext.registerService(org.osgi.service.prefs.PreferencesService.class, (ServiceFactory)new OSGiPreferencesServiceManager(bundleContext), null);
        }
        this.registryServiceTracker = new ServiceTracker(bundleContext, "org.eclipse.core.runtime.IExtensionRegistry", (ServiceTrackerCustomizer)this);
        this.registryServiceTracker.open();
        this.locationTracker = new ServiceTracker(context, context.createFilter("(&" + Location.INSTANCE_FILTER + "(url=*))"), new ServiceTrackerCustomizer<Location, ServiceRegistration<?>>(){

            public ServiceRegistration<?> addingService(ServiceReference<Location> reference) {
                Location location = (Location)context.getService(reference);
                if (location != null) {
                    return context.registerService(IScopeContext.class, (ServiceFactory)new BundleStateScopeServiceFactory(), FrameworkUtil.asDictionary(Map.of("type", "bundle")));
                }
                return null;
            }

            public void modifiedService(ServiceReference<Location> reference, ServiceRegistration<?> service) {
            }

            public void removedService(ServiceReference<Location> reference, ServiceRegistration<?> service) {
                service.unregister();
                context.ungetService(reference);
            }
        });
        this.locationTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        PreferencesOSGiUtils.getDefault().closeServices();
        if (this.registryServiceTracker != null) {
            this.registryServiceTracker.close();
            this.registryServiceTracker = null;
        }
        if (this.preferencesService != null) {
            this.preferencesService.unregister();
            this.preferencesService = null;
        }
        if (this.osgiPreferencesService != null) {
            this.osgiPreferencesService.unregister();
            this.osgiPreferencesService = null;
        }
        if (this.locationTracker != null) {
            this.locationTracker.close();
            this.locationTracker = null;
        }
        bundleContext = null;
    }

    static BundleContext getContext() {
        return bundleContext;
    }

    public synchronized Object addingService(ServiceReference<Object> reference) {
        Object service = bundleContext.getService(reference);
        if (service != null) {
            try {
                PreferenceServiceRegistryHelper helper = new PreferenceServiceRegistryHelper(PreferencesService.getDefault(), service);
                PreferencesService.getDefault().setRegistryHelper(helper);
            }
            catch (Exception e) {
                RuntimeLog.log((IStatus)new Status(4, PI_PREFERENCES, 0, PrefsMessages.noRegistry, (Throwable)e));
            }
            catch (NoClassDefFoundError error) {
                return null;
            }
        }
        return service;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    public synchronized void removedService(ServiceReference<Object> reference, Object service) {
        PreferencesService.getDefault().setRegistryHelper(null);
        bundleContext.ungetService(reference);
    }

    private void processCommandLine() {
        String value = bundleContext.getProperty(PROP_CUSTOMIZATION);
        if (value != null) {
            DefaultPreferences.pluginCustomizationFile = value;
            return;
        }
        ServiceTracker environmentTracker = new ServiceTracker(bundleContext, EnvironmentInfo.class, null);
        environmentTracker.open();
        EnvironmentInfo environmentInfo = (EnvironmentInfo)environmentTracker.getService();
        environmentTracker.close();
        if (environmentInfo == null) {
            return;
        }
        String[] args = environmentInfo.getNonFrameworkArgs();
        if (args == null || args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-plugincustomization")) {
                if (args.length <= i + 1) break;
                DefaultPreferences.pluginCustomizationFile = args[i + 1];
                break;
            }
            ++i;
        }
    }
}

