/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.spelling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.texteditor.spelling.SpellingEngineDescriptor;

public class SpellingEngineRegistry {
    public static final String SPELLING_ENGINE_EXTENSION_POINT = "spellingEngine";
    private Map<String, SpellingEngineDescriptor> fDescriptorsMap;
    private SpellingEngineDescriptor fDefaultDescriptor;
    private SpellingEngineDescriptor[] fDescriptors;
    private boolean fLoaded = false;

    public SpellingEngineDescriptor getDescriptor(String id) {
        this.ensureExtensionsLoaded();
        return this.fDescriptorsMap.get(id);
    }

    public SpellingEngineDescriptor getDefaultDescriptor() {
        this.ensureExtensionsLoaded();
        return this.fDefaultDescriptor;
    }

    public SpellingEngineDescriptor[] getDescriptors() {
        this.ensureExtensionsLoaded();
        return this.fDescriptors;
    }

    public synchronized void reloadExtensions() {
        IConfigurationElement[] elements;
        ArrayList<SpellingEngineDescriptor> descriptors = new ArrayList<SpellingEngineDescriptor>();
        this.fDescriptorsMap = new HashMap<String, SpellingEngineDescriptor>();
        this.fDefaultDescriptor = null;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.workbench.texteditor", SPELLING_ENGINE_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            SpellingEngineDescriptor descriptor = new SpellingEngineDescriptor(element);
            descriptors.add(descriptor);
            this.fDescriptorsMap.put(descriptor.getId(), descriptor);
            if (this.fDefaultDescriptor == null && descriptor.isDefault()) {
                this.fDefaultDescriptor = descriptor;
            }
            ++n2;
        }
        this.fDescriptors = descriptors.toArray(new SpellingEngineDescriptor[descriptors.size()]);
        this.fLoaded = true;
        if (this.fDefaultDescriptor == null && this.fDescriptors.length > 0) {
            this.fDefaultDescriptor = this.fDescriptors[0];
        }
    }

    private void ensureExtensionsLoaded() {
        if (!this.fLoaded) {
            this.reloadExtensions();
        }
    }
}

