import path from 'path';
import fsp from 'fs/promises';
import { ArtixMlg } from './artix-mlg.js';
const fixtureFile = process.env['FIXTURE'] || path.join(process.cwd(), 'mirrors.fixture.json');
async function tryReadFileOrDefault(f, d, verbose = false) {
    try {
        return JSON.parse(await fsp.readFile(f, { encoding: 'utf-8' }));
    }
    catch (err) {
        console.error(`unable to open ${f}`);
        if (verbose) {
            console.error(err);
        }
        return d;
    }
}
async function main() {
    const options = {
        fixture: await tryReadFileOrDefault(fixtureFile, [], !!process.env['VERBOSE'])
    };
    const mlg = new ArtixMlg(options);
    mlg.run();
}
export default main;
export { main };
//# sourceMappingURL=index.js.map