/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkPermuteAxesImageFilter_h
#define sitkPermuteAxesImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class PermuteAxesImageFilter
\brief Permutes the image axes according to a user specified order.

PermuateAxesImageFilter permutes the image axes according to a user specified order. The permutation order is set via method SetOrder( order ) where the input is an array of ImageDimension number of unsigned int. The elements of the array must be a rearrangement of the numbers from 0 to ImageDimension - 1.

The i-th axis of the output image corresponds with the order[i]-th axis of the input image.

The output meta image information (LargestPossibleRegion, spacing, origin) is computed by permuting the corresponding input meta information.
\sa itk::simple::PermuteAxes for the procedural interface
\sa itk::PermuteAxesImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT PermuteAxesImageFilter : public ImageFilter {
    public:
      using Self = PermuteAxesImageFilter;

      /** Destructor */
      virtual ~PermuteAxesImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      PermuteAxesImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
      /** Custom public declarations */
      static const std::vector<unsigned int> DefaultOrder;

\

      /**
       * Set the permutation order. The elements of order must be a rearrangement of the numbers from 0 to ImageDimension - 1.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOrder ( std::vector<unsigned int> Order ) { this->m_Order = std::move(Order); return *this; }

      /**
       * Get the permutation order.
       */
      std::vector<unsigned int> GetOrder() const { return this->m_Order; }

      /** Name of this class */
      std::string GetName() const { return std::string ("PermuteAxesImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_Order{std::vector<unsigned int>(itk::simple::PermuteAxesImageFilter::DefaultOrder)};


    };

    /**\
     * \brief Permutes the image axes according to a user specified order.
     *
     * This function directly calls the execute method of PermuteAxesImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::PermuteAxesImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image PermuteAxes ( const Image& image1, std::vector<unsigned int> order = std::vector<unsigned int>(itk::simple::PermuteAxesImageFilter::DefaultOrder) );

     /** @} */
}
#endif
