/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser.key;

import java.time.DateTimeException;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ext.javatime.deser.key.Jsr310KeyDeserializer;

public class MonthDayKeyDeserializer
extends Jsr310KeyDeserializer {
    public static final MonthDayKeyDeserializer INSTANCE = new MonthDayKeyDeserializer();
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();

    private MonthDayKeyDeserializer() {
    }

    @Override
    protected MonthDay deserialize(String key, DeserializationContext ctxt) throws JacksonException {
        try {
            return MonthDay.parse(key, PARSER);
        }
        catch (DateTimeException e) {
            return (MonthDay)this._handleDateTimeException(ctxt, MonthDay.class, e, key);
        }
    }
}

