/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

@ExportLibrary(value=InteropLibrary.class)
public final class PThreadLocal
extends PythonBuiltinObject {
    private final ThreadLocal<PDict> threadLocalDict = new ThreadLocal();
    private final Object[] args;
    private final PKeyword[] keywords;

    public PThreadLocal(Object cls, Shape instanceShape, Object[] args, PKeyword[] keywords) {
        super(cls, instanceShape);
        this.args = args;
        this.keywords = keywords;
    }

    @CompilerDirectives.TruffleBoundary
    public PDict getThreadLocalDict() {
        return this.threadLocalDict.get();
    }

    @CompilerDirectives.TruffleBoundary
    public void setThreadLocalDict(PDict dict) {
        this.threadLocalDict.set(dict);
    }

    public Object[] getArgs() {
        return this.args;
    }

    public PKeyword[] getKeywords() {
        return this.keywords;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        List<String> keys = this.getLocalAttributes();
        return new PythonAbstractObject.Keys(keys.toArray(PythonUtils.EMPTY_STRING_ARRAY));
    }

    @CompilerDirectives.TruffleBoundary
    private List<String> getLocalAttributes() {
        PDict localDict = this.getThreadLocalDict();
        ArrayList<String> keys = new ArrayList<String>();
        if (localDict != null) {
            HashingStorage storage = localDict.getDictStorage();
            HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(storage);
            while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(storage, it)) {
                Object key = TruffleStringMigrationHelpers.assertNoJavaString(HashingStorageNodes.HashingStorageIteratorKey.executeUncached(storage, it));
                if (!(key instanceof TruffleString)) continue;
                TruffleString strKey = (TruffleString)key;
                keys.add(strKey.toJavaStringUncached());
            }
        }
        return keys;
    }

    @ExportMessage.Ignore
    private Object readMember(Node inliningTarget, String member, HashingStorageNodes.HashingStorageGetItem getItem, TruffleString.FromJavaStringNode fromJavaStringNode) {
        PDict localDict = this.getThreadLocalDict();
        return localDict == null ? null : getItem.execute(inliningTarget, localDict.getDictStorage(), fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING));
    }

    @ExportMessage
    public boolean isMemberReadable(String member, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return this.readMember(inliningTarget, member, getItem, fromJavaStringNode) != null;
    }

    @ExportMessage
    public boolean isMemberModifiable(String member, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return this.readMember(inliningTarget, member, getItem, fromJavaStringNode) != null;
    }

    @ExportMessage
    public boolean isMemberInsertable(String member, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return !this.isMemberReadable(member, inliningTarget, getItem, fromJavaStringNode);
    }

    @ExportMessage
    public boolean isMemberInvocable(String member, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        PDict localDict = this.getThreadLocalDict();
        return localDict != null && PGuards.isCallable(getItem.execute(inliningTarget, localDict.getDictStorage(), fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING)));
    }

    @ExportMessage
    public boolean isMemberRemovable(String member, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return this.isMemberReadable(member, inliningTarget, getItem, fromJavaStringNode);
    }

    @ExportMessage
    public boolean hasMemberReadSideEffects(String member, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared @Cached TpSlots.GetObjectSlotsNode getSlotsNode) {
        Object attr = this.readMember(inliningTarget, member, getItem, fromJavaStringNode);
        return attr != null && getSlotsNode.execute(inliningTarget, attr).tp_descr_get() != null;
    }

    @ExportMessage
    public boolean hasMemberWriteSideEffects(String member, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared @Cached TpSlots.GetObjectSlotsNode getSlotsNode) {
        Object attr = this.readMember(inliningTarget, member, getItem, fromJavaStringNode);
        return attr != null && getSlotsNode.execute(inliningTarget, attr).tp_descr_set() != null;
    }
}

