/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.wire.AbstractWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class V10WireOperations
extends AbstractWireOperations {
    private static final Logger log = LoggerFactory.getLogger(V10WireOperations.class);

    public V10WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        super(connection, defaultWarningMessageCallback);
    }

    @Override
    public void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket, DbCryptCallback dbCryptCallback, FbWireOperations.ProcessAttachCallback processAttachCallback) throws IOException, SQLException {
        assert (acceptPacket == null) : "Should not be called with non-null acceptPacket in V12 or earlier";
        GenericResponse response = this.readGenericResponse(null);
        this.getClientAuthBlock().setAuthComplete(true);
        processAttachCallback.processAttachResponse(response);
        if (this.getAttachProperties().getWireCryptAsEnum() == WireCrypt.REQUIRED) {
            String message = "wireCrypt=REQUIRED, but wire protocol version does not support encryption, encryption requirement dropped";
            log.warn(message);
            this.getDefaultWarningMessageCallback().processWarning(new SQLWarning(message));
        }
    }
}

