\name{RegionalMinimaImageFilter}
\alias{RegionalMinimaImageFilter}
\title{RegionalMinimaImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Produce a binary image where foreground is the regional minima of the
input image.
RegionalMinimaImageFilter}
\details{
Regional minima are flat zones surrounded by pixels of greater value.
If the input image is constant, the entire image can be considered as
a minima or not. The SetFlatIsMinima() method let the user choose which behavior to use.
This class was contributed to the Insight Journal by
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France. https://www.insight-journal.org/browse/publication/65
See:
RegionalMaximaImageFilter
ValuedRegionalMinimaImageFilter
HConcaveImageFilter
RegionalMinima for the procedural interface
itk::RegionalMinimaImageFilter for the Doxygen on the original ITK class.
RegionalMinimaImageFilter}
%C++ includes: sitkRegionalMinimaImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FlatIsMinimaOff():}{}
\item{Self FlatIsMinimaOn():}{
Set the value of FlatIsMinima to true or false respectfully.
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{bool GetFlatIsMinima() const:}{
Set/Get whether a flat image must be considered as a minima or not.
Defaults to true.
}
\item{double GetForegroundValue() const:}{
Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ RegionalMinimaImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetFlatIsMinima(bool FlatIsMinima):}{
Set/Get whether a flat image must be considered as a minima or not.
Defaults to true.
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RegionalMinimaImageFilter():}{
Destructor
}
}
}
