\name{IntensityWindowingImageFilter}
\alias{IntensityWindowingImageFilter}
\title{IntensityWindowingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Applies a linear transformation to the intensity levels of the input Image that are inside a user-defined interval. Values below this interval
are mapped to a constant. Values over the interval are mapped to
another constant.
IntensityWindowingImageFilter}
\details{
IntensityWindowingImageFilter applies pixel-wise a linear transformation to the intensity values of
input image pixels. The linear transformation is defined by the user
in terms of the minimum and maximum values that the output image
should have and the lower and upper limits of the intensity window of
the input image. This operation is very common in visualization, and
can also be applied as a convenient preprocessing operation for image
segmentation.
All computations are performed in the precision of the input pixel's
RealType. Before assigning the computed value to the output pixel.
See:
RescaleIntensityImageFilter
IntensityWindowing for the procedural interface
itk::IntensityWindowingImageFilter for the Doxygen on the original ITK class.
IntensityWindowingImageFilter}
%C++ includes: sitkIntensityWindowingImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOutputMaximum() const:}{
Set/Get the values of the maximum and minimum intensities of the
output image.
}
\item{double GetOutputMinimum() const:}{
Set/Get the values of the maximum and minimum intensities of the
output image.
}
\item{double GetWindowMaximum() const:}{
Set/Get the values of the maximum and minimum intensities of the input
intensity window.
}
\item{double GetWindowMinimum() const:}{
Set/Get the values of the maximum and minimum intensities of the input
intensity window.
}
\item{ IntensityWindowingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetOutputMaximum(double OutputMaximum):}{
Set/Get the values of the maximum and minimum intensities of the
output image.
}
\item{Self SetOutputMinimum(double OutputMinimum):}{
Set/Get the values of the maximum and minimum intensities of the
output image.
}
\item{Self SetWindowMaximum(double WindowMaximum):}{
Set/Get the values of the maximum and minimum intensities of the input
intensity window.
}
\item{Self SetWindowMinimum(double WindowMinimum):}{
Set/Get the values of the maximum and minimum intensities of the input
intensity window.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~IntensityWindowingImageFilter():}{
Destructor
}
}
}
