/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.security.support.ModuleType;

public class ModuleInfo
implements Serializable,
Writeable {
    private static final long serialVersionUID = -1077651823194285138L;
    private ModuleType moduleType;
    private String classname;
    private String classpath = "";
    private String version = "";
    private String buildTime = "";
    private String gitsha1 = "";

    public ModuleInfo(ModuleType moduleType, String classname) {
        assert (moduleType != null);
        this.moduleType = moduleType;
        this.classname = classname;
    }

    public ModuleInfo(StreamInput in) throws IOException {
        this.moduleType = (ModuleType)in.readEnum(ModuleType.class);
        this.classname = in.readString();
        this.classpath = in.readString();
        this.version = in.readString();
        this.buildTime = in.readString();
        this.gitsha1 = in.readString();
        assert (this.moduleType != null);
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public String getGitsha1() {
        return this.gitsha1;
    }

    public void setGitsha1(String gitsha1) {
        this.gitsha1 = gitsha1;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public Map<String, String> getAsMap() {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("type", this.moduleType.name());
        infoMap.put("description", this.moduleType.getDescription());
        infoMap.put("is_advanced_module", this.moduleType.isAdvancedModule().toString());
        infoMap.put("default_implementation", this.moduleType.getDefaultImplClass());
        infoMap.put("actual_implementation", this.classname);
        infoMap.put("version", this.version);
        infoMap.put("buildTime", this.buildTime);
        infoMap.put("gitsha1", this.gitsha1);
        return infoMap;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.moduleType);
        out.writeString(this.classname);
        out.writeString(this.classpath);
        out.writeString(this.version);
        out.writeString(this.buildTime);
        out.writeString(this.gitsha1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buildTime == null ? 0 : this.buildTime.hashCode());
        result = 31 * result + (this.classname == null ? 0 : this.classname.hashCode());
        result = 31 * result + (this.moduleType == null ? 0 : this.moduleType.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.gitsha1 == null ? 0 : this.gitsha1.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo other = (ModuleInfo)obj;
        if (this.buildTime == null ? other.buildTime != null : !this.buildTime.equals(other.buildTime)) {
            return false;
        }
        if (this.classname == null ? other.classname != null : !this.classname.equals(other.classname)) {
            return false;
        }
        if (!this.moduleType.equals(other.moduleType)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.gitsha1 == null ? other.gitsha1 != null : !this.gitsha1.equals(other.gitsha1));
    }

    public String toString() {
        return "Module [type=" + this.moduleType.name() + ", implementing class=" + this.classname + "]";
    }
}

