/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.identity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.function.LongSupplier;
import joptsimple.internal.Strings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.identity.Subject;
import org.opensearch.identity.noop.NoopSubject;
import org.opensearch.identity.tokens.AuthToken;
import org.opensearch.identity.tokens.OnBehalfOfClaims;
import org.opensearch.identity.tokens.TokenManager;
import org.opensearch.security.authtoken.jwt.ExpiringBearerAuthToken;
import org.opensearch.security.authtoken.jwt.JwtVendor;
import org.opensearch.security.authtoken.jwt.claims.OBOJwtClaimsBuilder;
import org.opensearch.security.securityconf.ConfigModel;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.user.User;
import org.opensearch.security.user.UserService;
import org.opensearch.security.util.AuthTokenUtils;
import org.opensearch.threadpool.ThreadPool;

public class SecurityTokenManager
implements TokenManager {
    private static final Logger logger = LogManager.getLogger(SecurityTokenManager.class);
    private final ClusterService cs;
    private final ThreadPool threadPool;
    private final UserService userService;
    private Settings oboSettings = null;
    private ConfigModel configModel = null;
    private final LongSupplier timeProvider = System::currentTimeMillis;
    private static final Integer OBO_MAX_EXPIRY_SECONDS = 600;

    public SecurityTokenManager(ClusterService cs, ThreadPool threadPool, UserService userService) {
        this.cs = cs;
        this.threadPool = threadPool;
        this.userService = userService;
    }

    @Subscribe
    public void onConfigModelChanged(ConfigModel configModel) {
        this.configModel = configModel;
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        Settings oboSettingsFromDcm = dcm.getDynamicOnBehalfOfSettings();
        Boolean oboEnabled = oboSettingsFromDcm.getAsBoolean("enabled", Boolean.valueOf(false));
        if (oboEnabled.booleanValue()) {
            this.oboSettings = oboSettingsFromDcm;
        }
    }

    JwtVendor createJwtVendor(Settings settings) {
        try {
            return new JwtVendor(settings);
        }
        catch (Exception ex) {
            logger.error("Unable to create the JwtVendor instance", (Throwable)ex);
            return null;
        }
    }

    public boolean issueOnBehalfOfTokenAllowed() {
        return this.oboSettings != null && this.configModel != null;
    }

    public ExpiringBearerAuthToken issueOnBehalfOfToken(Subject subject, OnBehalfOfClaims claims) {
        if (!this.issueOnBehalfOfTokenAllowed()) {
            throw new OpenSearchSecurityException("The OnBehalfOf token generation is not enabled, see {link to doc} for more information on this feature.", new Object[0]);
        }
        if (subject != null && !(subject instanceof NoopSubject)) {
            logger.warn("Unsupported subject for OnBehalfOfToken token generation, {}", (Object)subject);
            throw new IllegalArgumentException("Unsupported subject to generate OnBehalfOfToken");
        }
        if (Strings.isNullOrEmpty((String)claims.getAudience())) {
            throw new IllegalArgumentException("Claims must be supplied with an audience value");
        }
        User user = (User)this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
        if (user == null) {
            throw new OpenSearchSecurityException("Unsupported user to generate OnBehalfOfToken", new Object[0]);
        }
        TransportAddress callerAddress = null;
        Set<String> mappedRoles = this.configModel.mapSecurityRoles(user, callerAddress);
        long currentTimeMs = this.timeProvider.getAsLong();
        Date now = new Date(currentTimeMs);
        long expirySeconds = Math.min(claims.getExpiration(), (long)OBO_MAX_EXPIRY_SECONDS.intValue());
        if (expirySeconds <= 0L) {
            throw new IllegalArgumentException("The expiration time should be a positive integer");
        }
        if (mappedRoles == null) {
            throw new IllegalArgumentException("Roles cannot be null");
        }
        if (AuthTokenUtils.isKeyNull(this.oboSettings, "encryption_key").booleanValue()) {
            throw new IllegalArgumentException("encryption_key cannot be null");
        }
        OBOJwtClaimsBuilder claimsBuilder = new OBOJwtClaimsBuilder(this.oboSettings.get("encryption_key"));
        claimsBuilder.issuer(this.cs.getClusterName().value());
        claimsBuilder.issueTime(now);
        claimsBuilder.subject(user.getName());
        claimsBuilder.audience(claims.getAudience());
        claimsBuilder.notBeforeTime(now);
        claimsBuilder.addBackendRoles(false, new ArrayList<String>((Collection<String>)user.getRoles()));
        claimsBuilder.addRoles(new ArrayList<String>(mappedRoles));
        Date expiryTime = new Date(currentTimeMs + expirySeconds * 1000L);
        claimsBuilder.expirationTime(expiryTime);
        try {
            return this.createJwtVendor(this.oboSettings).createJwt(claimsBuilder, user.getName(), expiryTime, expirySeconds);
        }
        catch (Exception ex) {
            logger.error("Error creating OnBehalfOfToken for " + user.getName(), (Throwable)ex);
            throw new OpenSearchSecurityException("Unable to generate OnBehalfOfToken", new Object[0]);
        }
    }

    public AuthToken issueServiceAccountToken(String serviceId) {
        try {
            return this.userService.generateAuthToken(serviceId);
        }
        catch (Exception e) {
            logger.error("Error creating sevice final account auth token, service " + serviceId, (Throwable)e);
            throw new OpenSearchSecurityException("Unable to issue service account token", new Object[0]);
        }
    }
}

