/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import org.ldaptive.Connection;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.cache.Cache;
import org.ldaptive.handler.OperationExceptionHandler;
import org.ldaptive.handler.OperationResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchOperationFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OperationExceptionHandler<SearchRequest, SearchResult> searchExceptionHandler;
    private OperationResponseHandler<SearchRequest, SearchResult>[] searchResponseHandlers;
    private Cache<SearchRequest> searchCache;

    public OperationExceptionHandler<SearchRequest, SearchResult> getSearchExceptionHandler() {
        return this.searchExceptionHandler;
    }

    public void setSearchExceptionHandler(OperationExceptionHandler<SearchRequest, SearchResult> handler) {
        this.searchExceptionHandler = handler;
    }

    public OperationResponseHandler<SearchRequest, SearchResult>[] getSearchResponseHandlers() {
        return this.searchResponseHandlers;
    }

    public void setSearchResponseHandlers(OperationResponseHandler<SearchRequest, SearchResult> ... handlers) {
        this.searchResponseHandlers = handlers;
    }

    public Cache<SearchRequest> getSearchCache() {
        return this.searchCache;
    }

    public void setSearchCache(Cache<SearchRequest> cache) {
        this.searchCache = cache;
    }

    protected SearchOperation createSearchOperation(Connection conn) {
        SearchOperation op = new SearchOperation(conn);
        if (this.searchExceptionHandler != null) {
            op.setOperationExceptionHandler(this.searchExceptionHandler);
        }
        if (this.searchResponseHandlers != null) {
            op.setOperationResponseHandlers(this.searchResponseHandlers);
        }
        if (this.searchCache != null) {
            op.setCache(this.searchCache);
        }
        return op;
    }
}

